/*
 * Decompiled with CFR 0.152.
 */
package com.jd.wlogin.cc;

import com.jd.wlogin.cc.IPPorts;
import com.jd.wlogin.cc.config_request;
import com.jd.wlogin.default_setting.default_setting;
import com.jd.wlogin.request.http_request;
import com.jd.wlogin.request.udp_request;
import com.jd.wlogin.server.server_node;
import com.jd.wlogin.server.server_node_pool;
import com.jd.wlogin.tools.message_decoder;
import com.jd.wlogin.tools.message_encoder;
import com.jd.wlogin.tools.util;
import java.util.ArrayList;

public class RequestConfig {
    private static final int kCCRecvBuffSize = 32768;
    private static final int kCCTimeOut = 100;
    private static final int kCCHttpTimeOut = 500;
    public static final int kWLoginSelfAppId = 1;
    private static final String kConfigAccessServiceName = "Access";
    private static final int kWLoginComponentType = 1;
    private static final int kStateMasterIdc = 1;
    private static final int kStateSlaveIdc = 2;
    private static final int kStateBase = 3;
    private default_setting _default_setting = config_request.getInstance().getDefaultSetting();
    private long _last_update_cc_time = 0L;
    private int _cc_update_interval = 600000 + util.get_rand_32() % 500;
    private ArrayList<server_node> _masters = null;
    private ArrayList<server_node> _slaves = null;
    private ArrayList<server_node> _bases = new ArrayList();
    private int _master_index = 0;
    private int _slave_index = 0;
    private int _base_index = 0;
    private int _idc_state = 1;
    private udp_request _udp_req = null;
    private http_request _http_req = null;
    private String _ccServiceAddr = "";
    private String _ccServiceUrl = "";
    private int _component_type = 1;
    private String _exception_msg = null;

    public RequestConfig(String ccServiceUrl) {
        this._slaves = new ArrayList();
        this._masters = new ArrayList();
        this._ccServiceUrl = ccServiceUrl;
        this._udp_req = new udp_request(32768, 100);
        this._http_req = new http_request();
        this._ccServiceAddr = this._default_setting.getServerBackup(kConfigAccessServiceName);
        String[] addrs = this._ccServiceAddr.split("\\|");
        this._bases.clear();
        for (String addr : addrs) {
            server_node node = server_node_pool.getNode(addr);
            if (null == node) continue;
            this._bases.add(node);
        }
    }

    public RequestConfig() {
        this._slaves = new ArrayList();
        this._masters = new ArrayList();
        this._udp_req = new udp_request(32768, 100);
        this._http_req = new http_request();
        this._ccServiceUrl = this._default_setting.getConfigCenterServiceUrl();
        this._ccServiceAddr = this._default_setting.getServerBackup(kConfigAccessServiceName);
        String[] addrs = this._ccServiceAddr.split("\\|");
        this._bases.clear();
        for (String addr : addrs) {
            server_node node = server_node_pool.getNode(addr);
            if (null == node) continue;
            this._bases.add(node);
        }
    }

    public void SetConfigCenterServiceAddr(String ccServiceUrl) {
        this._bases.clear();
        this._slaves.clear();
        this._masters.clear();
        this._ccServiceUrl = ccServiceUrl;
        String[] addrs = this._ccServiceAddr.split("\\|");
        this._bases.clear();
        for (String addr : addrs) {
            server_node node = server_node_pool.getNode(addr);
            if (null == node) continue;
            this._bases.add(node);
        }
        this.GetCCServersByHttp();
    }

    public IPPorts CC_GetAddrs(byte[] req_buf, int req_len) {
        message_decoder decoder = this.RequestConfigWithRetry(req_buf, req_len);
        if (decoder == null) {
            return null;
        }
        this.ClearErr();
        int cc_error_code = 0;
        if (decoder.status() != 0) {
            cc_error_code = decoder.GetInt32(2);
            this._exception_msg = "cc_agent get ip data status failed, cc_error_code:" + cc_error_code + ", msg:" + (null == decoder.GetString(1) ? "" : decoder.GetString(1));
        }
        if (cc_error_code == 0 || cc_error_code == 11) {
            ArrayList<String> master_list = decoder.GetStringArray(1);
            ArrayList<String> slave_list = decoder.GetStringArray(2);
            if (null == master_list || cc_error_code == 11) {
                master_list = new ArrayList();
            }
            if (null == slave_list || cc_error_code == 11) {
                slave_list = new ArrayList();
            }
            return new IPPorts(master_list, slave_list);
        }
        return null;
    }

    public String CC_GetAttr(byte[] req_buf, int req_len) {
        message_decoder decoder = this.RequestConfigWithRetry(req_buf, req_len);
        if (decoder == null) {
            return null;
        }
        this.ClearErr();
        int cc_error_code = 0;
        if (decoder.status() != 0) {
            cc_error_code = decoder.GetInt32(2);
            this._exception_msg = "cc_agent get attr data status failed, cc_error_code:" + cc_error_code + ", msg:" + (null == decoder.GetString(1) ? "" : decoder.GetString(1));
        }
        if (cc_error_code == 0 || cc_error_code == 11) {
            String value = decoder.GetString(1);
            if (value == null || cc_error_code == 11) {
                value = "";
            }
            return value;
        }
        return null;
    }

    public message_decoder RequestConfigWithRetry(byte[] req_buf, int req_len) {
        int recv_len;
        int ret = 0;
        int tc = 2;
        while (tc-- > 0) {
            this.ClearErr();
            server_node node = this.GetAddr();
            if (node == null) {
                this._exception_msg = "no cc server candidate";
                return null;
            }
            ret = this._udp_req.Request(req_buf, req_len, node.ip, node.port);
            if (ret == 0) break;
            this.RemoveCCAddr();
            this._exception_msg = "connect to cc " + node.ip + ":" + node.port + " failed: " + this._udp_req.exception_msg() + ", errcode:" + ret;
        }
        if (ret != 0) {
            this._exception_msg = "connect to cc failed after retry: " + this._udp_req.exception_msg() + ", errcode:" + ret;
            return null;
        }
        byte[] recv_buf = this._udp_req.recv_buf();
        if (message_decoder.Check(recv_buf, recv_len = this._udp_req.recv_buf_len()) <= 0) {
            this._exception_msg = "fail to check message, recv_len:" + recv_len;
            return null;
        }
        message_decoder decoder = new message_decoder(recv_buf);
        return decoder;
    }

    public message_decoder RequestConfigWithRetry(message_encoder encoder) {
        int recv_len;
        int ret = 0;
        int tc = 2;
        while (tc-- > 0) {
            this.ClearErr();
            server_node node = this.GetAddr();
            if (node == null) {
                this._exception_msg = "no cc server candidate";
                return null;
            }
            encoder.set_seq(util.get_rand_32());
            ret = this._udp_req.Request(encoder, node.ip, node.port);
            if (ret == 0) break;
            this.RemoveCCAddr();
            this._exception_msg = "connect to cc " + node.ip + ":" + node.port + " failed: " + this._udp_req.exception_msg() + ", errcode:" + ret;
        }
        if (ret != 0) {
            this._exception_msg = "connect to cc failed after retry: " + this._udp_req.exception_msg() + ", errcode:" + ret;
            return null;
        }
        byte[] recv_buf = this._udp_req.recv_buf();
        if (message_decoder.Check(recv_buf, recv_len = this._udp_req.recv_buf_len(), encoder.seq()) <= 0) {
            this._exception_msg = "fail to check message, recv_len:" + recv_len;
            return null;
        }
        message_decoder decoder = new message_decoder(recv_buf);
        return decoder;
    }

    private int GetCCServersByHttp() {
        int ret = 0;
        int tc = 2;
        String strUrl = this._ccServiceUrl + "?name=Access&appid=" + this._component_type;
        while (tc-- > 0 && (ret = this._http_req.SendGet(strUrl, 500)) != 0) {
        }
        if (ret != 0) {
            this._exception_msg = "failed to get config addrs by http:" + strUrl + " failed:" + this._http_req.exception_msg();
            return -1;
        }
        String response = this._http_req.response();
        String[] str_array = response.split("&&");
        if (str_array.length < 3) {
            this._exception_msg = "get illegal response by http";
            return -1;
        }
        String code = str_array[0];
        if ("0".equals(code)) {
            server_node node;
            String[] master_array = null;
            String[] slave_array = null;
            if (str_array.length == 3) {
                master_array = str_array[2].split("\\|");
            }
            if (str_array.length == 4) {
                master_array = str_array[2].split("\\|");
                slave_array = str_array[3].split("\\|");
            }
            if (master_array != null && master_array.length > 0) {
                this._masters.clear();
                for (String ip_port_str : master_array) {
                    node = server_node_pool.getNode(ip_port_str);
                    if (node == null) continue;
                    this._masters.add(node);
                }
            }
            if (slave_array != null && slave_array.length > 0) {
                this._slaves.clear();
                for (String ip_port_str : slave_array) {
                    node = server_node_pool.getNode(ip_port_str);
                    if (node == null) continue;
                    this._slaves.add(node);
                }
            }
        } else {
            this._exception_msg = "fail to get cc_addrs by http, msg:" + str_array[1];
            return -1;
        }
        return 0;
    }

    private server_node GetAddr() {
        if (System.currentTimeMillis() - this._last_update_cc_time > (long)this._cc_update_interval) {
            this.GetCCServersByHttp();
            this._last_update_cc_time = System.currentTimeMillis();
        }
        if (this._masters.isEmpty() && this._slaves.isEmpty()) {
            this.GetCCServersByHttp();
        }
        if (!this._masters.isEmpty()) {
            this._master_index = util.get_rand_32() % this._masters.size();
            this._idc_state = 1;
            return this._masters.get(this._master_index);
        }
        if (!this._slaves.isEmpty()) {
            this._slave_index = util.get_rand_32() % this._slaves.size();
            this._idc_state = 2;
            return this._slaves.get(this._slave_index);
        }
        if (!this._bases.isEmpty()) {
            this._base_index = util.get_rand_32() % this._bases.size();
            this._idc_state = 3;
            return this._bases.get(this._base_index);
        }
        this._idc_state = 1;
        return null;
    }

    private void RemoveCCAddr() {
        if (this._idc_state == 1) {
            if (!this._masters.isEmpty()) {
                this._masters.remove(this._master_index);
            }
        } else if (this._idc_state == 2 && !this._slaves.isEmpty()) {
            this._slaves.remove(this._slave_index);
        }
    }

    private void ClearErr() {
        this._exception_msg = "";
    }

    public String exception_msg() {
        return this._exception_msg;
    }
}

