/*
 * Decompiled with CFR 0.152.
 */
package com.jd.wlogin.cc;

import com.jd.wlogin.cc.CacheKeyProtocol;
import com.jd.wlogin.cc.IPPorts;
import com.jd.wlogin.cc.LocalCachedConfig;
import com.jd.wlogin.cc.RequestConfig;
import com.jd.wlogin.cc.agent.config_agent;
import com.jd.wlogin.default_setting.default_setting;
import com.jd.wlogin.tools.message_decoder;
import com.jd.wlogin.tools.message_encoder;
import com.jd.wlogin.tools.util;
import java.net.URI;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class config_request {
    private static final config_request instance = new config_request();
    public static final int kSuccess = 0;
    public static final int kTtcDataNotExist = 11;
    private boolean _isInited = false;
    private boolean _isLoadingConfig = false;
    private boolean _isGlobalSite = false;
    private default_setting _default_setting = null;
    private RequestConfig _request_config = null;
    private LocalCachedConfig _local_cached_config = null;
    private ExecutorService _threadPool = Executors.newSingleThreadExecutor(new ThreadFactory(){

        public Thread newThread(Runnable r) {
            Thread t = Executors.defaultThreadFactory().newThread(r);
            t.setDaemon(true);
            return t;
        }
    });

    private config_request() {
    }

    public static config_request getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void CC_Initialize(String ccServiceUrl) {
        if (this._isInited) {
            return;
        }
        if (null == ccServiceUrl || ccServiceUrl.isEmpty()) {
            return;
        }
        config_request config_request2 = this;
        synchronized (config_request2) {
            if (this._isInited) {
                return;
            }
            StringBuilder class_name = new StringBuilder("com.jd.wlogin.default_setting.");
            try {
                URI r = URI.create(ccServiceUrl);
                if (r.getPath().startsWith("/global_")) {
                    class_name.append("global.");
                    if (r.getPath().startsWith("/global_dev_")) {
                        class_name.append("global_dev");
                    } else if (r.getPath().startsWith("/global_pre_")) {
                        class_name.append("global_pre");
                    } else {
                        class_name.append("global_release");
                    }
                    this._isGlobalSite = true;
                } else if (r.getPath().startsWith("/kpl_")) {
                    class_name.append("kpl.");
                    if (r.getPath().startsWith("/kpl_dev_")) {
                        class_name.append("kpl_dev");
                    } else if (r.getPath().startsWith("/kpl_pre_")) {
                        class_name.append("kpl_pre");
                    } else {
                        class_name.append("kpl_release");
                    }
                    this._isGlobalSite = false;
                } else {
                    class_name.append("china.");
                    if (r.getPath().startsWith("/dev_")) {
                        class_name.append("china_dev");
                    } else if (r.getPath().startsWith("/pre_")) {
                        class_name.append("china_pre");
                    } else {
                        class_name.append("china_release");
                    }
                    this._isGlobalSite = false;
                }
            }
            catch (Exception e) {
                class_name.append("default_setting");
                this._isGlobalSite = false;
            }
            this._default_setting = default_setting.getInstance(class_name.toString());
            this._request_config = new RequestConfig();
            this._request_config.SetConfigCenterServiceAddr(ccServiceUrl);
            this._local_cached_config = new LocalCachedConfig(ccServiceUrl);
            this._threadPool.execute(new config_agent(this._local_cached_config));
            this._isInited = true;
        }
    }

    public final default_setting getDefaultSetting() {
        return this._default_setting;
    }

    public final boolean isGlobalSite() {
        return this._isGlobalSite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPPorts CC_GetAddrs(String service_name, int app_id) {
        String service_key = CacheKeyProtocol.EncodeAddrKey(service_name, app_id);
        IPPorts ip_ports = this._local_cached_config.GetLocalCachedAddr(service_key);
        if (ip_ports != null) {
            ip_ports = this.BalanceMasterSlave(ip_ports.getMasterIpPorts(), ip_ports.getSlaveIpPorts());
            return ip_ports;
        }
        config_request config_request2 = this;
        synchronized (config_request2) {
            if (this._isLoadingConfig) {
                return null;
            }
            this._isLoadingConfig = true;
        }
        message_encoder encoder = new message_encoder();
        encoder.set_app_id((short)1);
        encoder.set_cmd((short)1);
        encoder.set_sub_cmd((short)32);
        encoder.AddString(1, service_name);
        encoder.AddInt16(2, app_id);
        String channel = util.buf_to_string(encoder.buffer(), encoder.len());
        message_decoder decoder = this._request_config.RequestConfigWithRetry(encoder);
        if (decoder == null) {
            this._isLoadingConfig = false;
            return new IPPorts(new ArrayList<String>(), new ArrayList<String>());
        }
        int cc_error_code = 0;
        if (decoder.status() != 0) {
            cc_error_code = decoder.GetInt32(2);
        }
        if (cc_error_code == 0 || cc_error_code == 11) {
            ArrayList<String> master_list = decoder.GetStringArray(1);
            ArrayList<String> slave_list = decoder.GetStringArray(2);
            if (null == master_list || cc_error_code == 11) {
                master_list = new ArrayList();
            }
            if (null == slave_list || cc_error_code == 11) {
                slave_list = new ArrayList();
            }
            this._local_cached_config.SetLocalCachedAddr(service_key, master_list, slave_list, channel);
            this._isLoadingConfig = false;
            ip_ports = this.BalanceMasterSlave(master_list, slave_list);
            return ip_ports;
        }
        this._isLoadingConfig = false;
        return new IPPorts(new ArrayList<String>(), new ArrayList<String>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String CC_GetAttr(String service_name, String module, String attr_key) {
        String service_key = CacheKeyProtocol.EncodeAttrKey(service_name, module, attr_key);
        String value = this._local_cached_config.GetLocalCachedAttr(service_key);
        if (value != null) {
            return value;
        }
        config_request config_request2 = this;
        synchronized (config_request2) {
            if (this._isLoadingConfig) {
                return null;
            }
            this._isLoadingConfig = true;
        }
        message_encoder encoder = new message_encoder();
        encoder.set_app_id((short)1);
        encoder.set_cmd((short)1);
        encoder.set_sub_cmd((short)21);
        encoder.AddString(1, service_name);
        encoder.AddString(2, module);
        encoder.AddString(3, attr_key);
        String channel = util.buf_to_string(encoder.buffer(), encoder.len());
        message_decoder decoder = this._request_config.RequestConfigWithRetry(encoder);
        if (decoder == null) {
            this._isLoadingConfig = false;
            return "";
        }
        int cc_error_code = 0;
        if (decoder.status() != 0) {
            cc_error_code = decoder.GetInt32(2);
        }
        if (cc_error_code == 0 || cc_error_code == 11) {
            value = decoder.GetString(1);
            if (value == null || cc_error_code == 11) {
                value = "";
            }
            this._local_cached_config.SetLocalCachedAttr(service_key, value, channel);
            this._isLoadingConfig = false;
            return value;
        }
        this._isLoadingConfig = false;
        return "";
    }

    private IPPorts BalanceMasterSlave(ArrayList<String> master_list, ArrayList<String> slave_list) {
        int gap = slave_list.size() - master_list.size();
        if (gap <= 0) {
            return new IPPorts(master_list, slave_list);
        }
        ArrayList<String> master_list_backup = new ArrayList<String>();
        master_list_backup.addAll(master_list);
        ArrayList<Integer> rands = util.get_nonredundant_rand(slave_list.size(), gap);
        for (int i = 0; i < gap; ++i) {
            master_list_backup.add(slave_list.get(rands.get(i)));
        }
        return new IPPorts(master_list_backup, slave_list);
    }

    public static void main(String[] args) throws InterruptedException {
        String ccUrl = "http://192.168.144.119/dev_index";
        int appId = 400;
        if (args.length >= 1) {
            ccUrl = args[0];
        }
        if (args.length >= 2) {
            appId = Integer.parseInt(args[1]);
        }
        long begin = System.currentTimeMillis();
        config_request r = config_request.getInstance();
        r.CC_Initialize(ccUrl);
        System.out.println("[default_setting_cc_url] :" + r._default_setting.getConfigCenterServiceUrl());
        System.out.println("[global_site] :" + r._isGlobalSite);
        IPPorts ip_ports = r.CC_GetAddrs("Access", 1);
        System.out.println("[Access] master: " + ip_ports.getMasterIpPorts() + ",salve: " + ip_ports.getSlaveIpPorts());
        ip_ports = r.CC_GetAddrs("VerifyService", appId);
        System.out.println("[VerifyService] master: " + ip_ports.getMasterIpPorts() + ",salve: " + ip_ports.getSlaveIpPorts());
        ip_ports = r.CC_GetAddrs("MVerifyService", appId);
        System.out.println("[MVerifyService] master: " + ip_ports.getMasterIpPorts() + ",salve: " + ip_ports.getSlaveIpPorts());
        ip_ports = r.CC_GetAddrs("OpenVerifyService", appId);
        System.out.println("[OpenVerifyService] master: " + ip_ports.getMasterIpPorts() + ",salve: " + ip_ports.getSlaveIpPorts());
        ip_ports = r.CC_GetAddrs("AccessNotifyService", 1);
        System.out.println("[AccessNotifyService] master: " + ip_ports.getMasterIpPorts() + ",salve: " + ip_ports.getSlaveIpPorts());
        ip_ports = r.CC_GetAddrs("InterVerifyService", appId);
        System.out.println("[InterVerifyService] master: " + ip_ports.getMasterIpPorts() + ",salve: " + ip_ports.getSlaveIpPorts());
        ip_ports = r.CC_GetAddrs("InterMVerifyService", appId);
        System.out.println("[InterMVerifyService] master: " + ip_ports.getMasterIpPorts() + ",salve: " + ip_ports.getSlaveIpPorts());
        ip_ports = r.CC_GetAddrs("InterOpenVerifyService", appId);
        System.out.println("[InterOpenVerifyService] master: " + ip_ports.getMasterIpPorts() + ",salve: " + ip_ports.getSlaveIpPorts());
        System.out.println("[Access.DefaultConfig.LoginServiceAddr]ret: " + r.CC_GetAttr("Access", "DefaultConfig", "LoginServiceAddr"));
        System.out.println("[Access.DefaultConfig.RouterServiceAddr]ret: " + r.CC_GetAttr("Access", "DefaultConfig", "RouterServiceAddr"));
        System.out.println("[Access.DefaultConfig.PublishServiceAddr]ret: " + r.CC_GetAttr("Access", "DefaultConfig", "PublishServiceAddr"));
        System.out.println("[VerifyService.VerifyA4.ClientList]ret: " + r.CC_GetAttr("VerifyService", "VerifyA4", "ClientList"));
        System.out.println("[VerifyService.VerifyA4.NotExist]ret: " + r.CC_GetAttr("VerifyService", "VerifyA4", "NotExist"));
        long end = System.currentTimeMillis();
        System.out.println("\u8017\u65f6\uff1a" + (end - begin));
        config_request config = config_request.getInstance();
        String service_name = "VerifyService";
        int request_counter = 3;
        System.out.println("===========================\u83b7\u53d6ip\u5217\u8868================================");
        while (request_counter-- > 0) {
            IPPorts ports = config.CC_GetAddrs(service_name, appId);
            if (ports == null) continue;
            Thread.sleep(100L);
        }
        System.out.println("===========================\u83b7\u53d6kv================================");
        String service_name1 = "LoginService";
        String module = "MSession";
        String key = "MemcachedClientName";
        request_counter = 3;
        while (request_counter-- > 0) {
            String value = config.CC_GetAttr(service_name1, module, key);
            if (value == null) continue;
            Thread.sleep(100L);
        }
    }
}

