/*
 * Decompiled with CFR 0.152.
 */
package com.jd.wlogin.request;

import com.jd.wlogin.request.socket_request;
import com.jd.wlogin.tools.message_decoder;
import com.jd.wlogin.tools.message_encoder;
import com.jd.wlogin.tools.util;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;

public class udp_request
implements socket_request {
    public static final int kSuccess = 0;
    public static final int kErrorCreateSocketFailed = -1;
    public static final int kErrorSetTimeoutFailed = -2;
    public static final int kErrorUnknownHost = -3;
    public static final int kErrorSendDataFailed = -4;
    public static final int kErrorRecvTimeout = -5;
    public static final int kErrorRecvFailed = -6;
    public static final int kErrorSeqNotMatched = -7;
    private byte[] _recv_buf = null;
    private int _recv_buf_size = 0;
    private int _recv_buf_len = 0;
    private int _timeout = 0;
    private String _exception_msg = null;
    private DatagramSocket local_socket = null;

    public udp_request(int recv_buf_size, int timeout) {
        this._recv_buf_size = recv_buf_size;
        this._recv_buf = new byte[this._recv_buf_size];
        this._timeout = timeout;
    }

    public int Request(message_encoder encoder, String server_ip, int server_port) {
        return this.Request(encoder, server_ip, server_port, this._timeout);
    }

    public int Request(message_encoder encoder, String server_ip, int server_port, int timeout) {
        if (null == this.local_socket) {
            try {
                this.local_socket = new DatagramSocket();
            }
            catch (SocketException e) {
                this._exception_msg = e.getMessage();
                return -1;
            }
        }
        if (timeout > 0) {
            try {
                this.local_socket.setSoTimeout(timeout);
            }
            catch (SocketException e) {
                this.local_socket.close();
                this.local_socket = null;
                this._exception_msg = e.getMessage();
                return -2;
            }
        }
        InetAddress server_addr = null;
        try {
            server_addr = InetAddress.getByName(server_ip);
        }
        catch (UnknownHostException e) {
            this.local_socket.close();
            this.local_socket = null;
            this._exception_msg = e.getMessage();
            return -3;
        }
        DatagramPacket outgoing = new DatagramPacket(encoder.buffer(), encoder.len(), server_addr, server_port);
        try {
            this.local_socket.send(outgoing);
        }
        catch (IOException e) {
            this.local_socket.close();
            this.local_socket = null;
            this._exception_msg = e.getMessage();
            return -4;
        }
        boolean seqError = false;
        int tc = 3;
        while (tc-- > 0) {
            this._exception_msg = "";
            this._recv_buf_len = 0;
            seqError = false;
            DatagramPacket incoming = new DatagramPacket(this._recv_buf, this._recv_buf_size);
            try {
                this.local_socket.receive(incoming);
            }
            catch (SocketTimeoutException e) {
                this.local_socket.close();
                this.local_socket = null;
                this._recv_buf_len = 0;
                this._exception_msg = e.getMessage();
                return -5;
            }
            catch (IOException e) {
                this.local_socket.close();
                this.local_socket = null;
                this._recv_buf_len = 0;
                this._exception_msg = e.getMessage();
                return -6;
            }
            this._recv_buf_len = incoming.getLength();
            this._exception_msg = "";
            if (message_decoder.Check(this._recv_buf, this._recv_buf_len, encoder.seq()) > 0) break;
            seqError = true;
            this._exception_msg = "Received Message SEQ isn't Equal to Sent Message SEQ, Retrying...";
        }
        if (seqError) {
            this.local_socket.close();
            this.local_socket = null;
            this._recv_buf_len = 0;
            return -7;
        }
        return 0;
    }

    public int Request(byte[] bytes, int len, String server_ip, int server_port) {
        return this.Request(bytes, len, server_ip, server_port, this._timeout);
    }

    public int Request(byte[] bytes, int len, String server_ip, int server_port, int timeout) {
        if (null == this.local_socket) {
            try {
                this.local_socket = new DatagramSocket();
            }
            catch (SocketException e) {
                this._exception_msg = e.getMessage();
                return -1;
            }
        }
        if (timeout > 0) {
            try {
                this.local_socket.setSoTimeout(timeout);
            }
            catch (SocketException e) {
                this.local_socket.close();
                this.local_socket = null;
                this._exception_msg = e.getMessage();
                return -2;
            }
        }
        InetAddress server_addr = null;
        try {
            server_addr = InetAddress.getByName(server_ip);
        }
        catch (UnknownHostException e) {
            this.local_socket.close();
            this.local_socket = null;
            this._exception_msg = e.getMessage();
            return -3;
        }
        DatagramPacket outgoing = new DatagramPacket(bytes, len, server_addr, server_port);
        try {
            this.local_socket.send(outgoing);
        }
        catch (IOException e) {
            this.local_socket.close();
            this.local_socket = null;
            this._exception_msg = e.getMessage();
            return -4;
        }
        int tc = 3;
        while (tc-- > 0) {
            this._exception_msg = "";
            this._recv_buf_len = 0;
            DatagramPacket incoming = new DatagramPacket(this._recv_buf, this._recv_buf_size);
            try {
                this.local_socket.receive(incoming);
            }
            catch (SocketTimeoutException e) {
                this.local_socket.close();
                this.local_socket = null;
                this._recv_buf_len = 0;
                this._exception_msg = e.getMessage();
                return -5;
            }
            catch (IOException e) {
                this.local_socket.close();
                this.local_socket = null;
                this._recv_buf_len = 0;
                this._exception_msg = e.getMessage();
                return -6;
            }
            this._recv_buf_len = incoming.getLength();
            this._exception_msg = "";
            if (message_decoder.Check(this._recv_buf, this._recv_buf_len) <= 0) continue;
            break;
        }
        return 0;
    }

    public byte[] recv_buf() {
        return this._recv_buf;
    }

    public int recv_buf_len() {
        return this._recv_buf_len;
    }

    public String exception_msg() {
        return this._exception_msg;
    }

    protected void finalize() {
        if (null != this.local_socket) {
            this.local_socket.close();
            this.local_socket = null;
        }
    }

    public static void main(String[] args) {
        message_encoder encoder = new message_encoder();
        encoder.set_uid(123456L);
        encoder.set_partition(4660);
        encoder.set_seq(17);
        encoder.set_app_id((short)1);
        encoder.set_cmd((short)1);
        encoder.set_sub_cmd((short)2);
        encoder.AddString(100, "I Love You\uff0c\u6211\u7231\u4f60");
        encoder.AddInt16(101, 789);
        udp_request r = new udp_request(8192, 300);
        int ret = r.Request(encoder, "192.168.144.119", 14011);
        System.out.println("ret: " + ret + ", msg: " + r.exception_msg());
        System.out.println("Res: " + util.buf_to_string(r.recv_buf(), r.recv_buf_len()));
        if (message_decoder.Check(r.recv_buf(), r.recv_buf_len(), encoder.seq()) <= 0) {
            System.out.println("message check failed");
            return;
        }
        message_decoder decoder = new message_decoder(r.recv_buf());
        System.out.println("len: " + decoder.len());
        System.out.println("uid: " + decoder.uid());
        System.out.println("partition: " + decoder.partition());
        System.out.println("seq: " + decoder.seq());
        System.out.println("appid: " + decoder.app_id());
        System.out.println("cmd: " + decoder.cmd());
        System.out.println("sub_cmd: " + decoder.sub_cmd());
        System.out.println("status: 0x" + Integer.toHexString(decoder.status()));
    }
}

