/*
 * Decompiled with CFR 0.152.
 */
package com.jd.wlogin.server;

import com.jd.wlogin.cc.config_request;
import com.jd.wlogin.default_setting.default_setting;
import com.jd.wlogin.report.report_agent;
import com.jd.wlogin.request.udp_request;
import com.jd.wlogin.server.server_set;
import com.jd.wlogin.tools.message_encoder;
import com.jd.wlogin.tools.util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class server_request {
    public static final int kSuccess = 0;
    private udp_request _req = null;
    private Map<String, server_set> _servers = null;
    private byte[] _recv_buf = null;
    private int _recv_buf_len = 0;
    private String _exception_msg = null;
    private report_agent _report_agent = null;
    private int _local_ip = 0;
    private default_setting _default_setting = config_request.getInstance().getDefaultSetting();

    public server_request() {
        this._req = new udp_request(16384, this._default_setting.getServerTimeOut());
        this._servers = new HashMap<String, server_set>();
        this._recv_buf = this._req.recv_buf();
        this._recv_buf_len = this._req.recv_buf_len();
        this._report_agent = new report_agent();
        ArrayList<String> ip_list = util.get_local_ip();
        if (null != ip_list && ip_list.size() > 0) {
            for (int idx = 0; idx < ip_list.size(); ++idx) {
                if (!ip_list.get(idx).startsWith("10.")) continue;
                this._local_ip = util.string_to_ip(ip_list.get(idx));
                break;
            }
            if (0 == this._local_ip) {
                this._local_ip = util.string_to_ip(ip_list.get(0));
            }
        } else {
            this._local_ip = 0;
        }
    }

    public int request(int interface_id, message_encoder encoder, String service_name, int app_id) {
        return this.request(interface_id, encoder, service_name, app_id, -1);
    }

    public int request(int interface_id, message_encoder encoder, String service_name, int app_id, int timeout) {
        String key = this.generateKey(service_name, app_id);
        server_set set = this._servers.get(key);
        if (set == null) {
            set = new server_set(service_name, app_id);
            this._servers.put(key, set);
        }
        int ret = 0;
        int tc = 2;
        while (tc-- > 0) {
            long time_begin = System.currentTimeMillis();
            encoder.set_seq(util.get_rand_32());
            ret = set.request(encoder, this._req, timeout);
            this._exception_msg = set.exception_msg();
            long time_end = System.currentTimeMillis();
            int status = 0;
            switch (ret) {
                case 0: {
                    status = 0;
                    break;
                }
                case -1: {
                    status = 1;
                    break;
                }
                case -3: {
                    status = 2;
                    break;
                }
                default: {
                    status = 1;
                }
            }
            int callSIP = this._local_ip;
            int callDIP = set.last_used_server_ip() == null ? 0 : util.string_to_ip(set.last_used_server_ip());
            this._report_agent.InterCallReport(app_id, interface_id, callSIP, callDIP, status, time_begin / 1000L, (int)(time_end - time_begin));
            if (ret != 0) continue;
            break;
        }
        if (ret != 0) {
            this._exception_msg = set.exception_msg();
            return ret;
        }
        this._recv_buf = this._req.recv_buf();
        this._recv_buf_len = this._req.recv_buf_len();
        return 0;
    }

    private String generateKey(String service_name, int app_id) {
        return service_name + "." + app_id;
    }

    public byte[] recv_buf() {
        return this._recv_buf;
    }

    public int recv_buf_len() {
        return this._recv_buf_len;
    }

    public String exception_msg() {
        return this._exception_msg;
    }
}

