/*
 * Decompiled with CFR 0.152.
 */
package com.jd.wlogin.server;

import com.jd.wlogin.cc.IPPorts;
import com.jd.wlogin.cc.config_request;
import com.jd.wlogin.default_setting.default_setting;
import com.jd.wlogin.server.server_node;
import com.jd.wlogin.server.server_node_pool;
import com.jd.wlogin.tools.util;
import java.util.ArrayList;
import java.util.Iterator;

public class server_set_util {
    public static final int kSuccess = 0;
    public static final int kErrorConnection = -1;
    public static final int kErrorGetConfig = -2;
    public static final int kErrorTimeout = -3;
    private String _default_config_key = null;
    private default_setting _default_setting = config_request.getInstance().getDefaultSetting();
    private static final int kStateMasterIdc = 1;
    private static final int kStateSlaveIdc = 2;
    private static final int kStateBaseIdc = 3;
    private int _app_id = 0;
    private String _service_name = null;
    private long _last_update_cc_time = 0L;
    private long _last_update_default_time = 0L;
    private int _master_index = 0;
    private ArrayList<server_node> _master_sets = new ArrayList();
    private ArrayList<Integer> _master_node_count_down = new ArrayList();
    private int _slave_index = 0;
    private ArrayList<server_node> _slave_sets = new ArrayList();
    private ArrayList<Integer> _slave_node_count_down = new ArrayList();
    private ArrayList<server_node> _base_sets = new ArrayList();
    private int _base_index = 0;
    private ArrayList<Integer> _base_node_count_down = new ArrayList();
    private int _idc_state = 1;
    private int _cc_update_interval = 60000 + util.get_rand_32() % 500;
    private config_request _config_center_service = config_request.getInstance();
    private String _last_default_config = null;

    public server_set_util(String service_name, int app_id, String default_config_key) {
        this._app_id = app_id;
        this._service_name = service_name;
        this._default_config_key = default_config_key;
    }

    public server_node getNode() {
        if (System.currentTimeMillis() - this._last_update_cc_time > (long)this._cc_update_interval) {
            this.updateConfig();
        }
        if (!this._master_sets.isEmpty()) {
            this._master_index = util.get_rand_32() % this._master_sets.size();
            this._idc_state = 1;
            return this._master_sets.get(this._master_index);
        }
        if (!this._slave_sets.isEmpty()) {
            this._slave_index = util.get_rand_32() % this._slave_sets.size();
            this._idc_state = 2;
            return this._slave_sets.get(this._slave_index);
        }
        this.useDefaultConfig();
        if (!this._base_sets.isEmpty()) {
            this._base_index = util.get_rand_32() % this._base_sets.size();
            this._idc_state = 3;
            return this._base_sets.get(this._base_index);
        }
        this._idc_state = 1;
        return null;
    }

    public void removeNode() {
        if (this._idc_state == 1) {
            int leftNumber = this._master_node_count_down.get(this._master_index);
            if (--leftNumber <= 0) {
                this._master_node_count_down.remove(this._master_index);
                this._master_sets.remove(this._master_index);
            } else {
                this._master_node_count_down.set(this._master_index, leftNumber);
            }
        } else if (this._idc_state == 2) {
            int leftNumber = this._slave_node_count_down.get(this._slave_index);
            if (--leftNumber <= 0) {
                this._slave_node_count_down.remove(this._slave_index);
                this._slave_sets.remove(this._slave_index);
            } else {
                this._slave_node_count_down.set(this._slave_index, leftNumber);
            }
        } else if (this._idc_state == 3) {
            int leftNumber = this._base_node_count_down.get(this._base_index);
            if (--leftNumber <= 0) {
                this._base_node_count_down.remove(this._base_index);
                this._base_sets.remove(this._base_index);
            } else {
                this._base_node_count_down.set(this._base_index, leftNumber);
            }
        }
    }

    private void updateConfig() {
        server_node node;
        Iterator<String> iterator;
        IPPorts ip_ports = this._config_center_service.CC_GetAddrs(this._service_name, this._app_id);
        if (null == ip_ports) {
            return;
        }
        this._last_update_cc_time = System.currentTimeMillis();
        if (ip_ports.getMasterIpPorts() != null && !ip_ports.getMasterIpPorts().isEmpty()) {
            this._master_sets.clear();
            this._master_node_count_down.clear();
            iterator = ip_ports.getMasterIpPorts().iterator();
            while (iterator.hasNext()) {
                node = server_node_pool.getNode(iterator.next());
                if (node == null) continue;
                this._master_sets.add(node);
                this._master_node_count_down.add(4);
            }
        }
        if (ip_ports.getSlaveIpPorts() != null && !ip_ports.getSlaveIpPorts().isEmpty()) {
            this._slave_sets.clear();
            this._slave_node_count_down.clear();
            iterator = ip_ports.getSlaveIpPorts().iterator();
            while (iterator.hasNext()) {
                node = server_node_pool.getNode(iterator.next());
                if (node == null) continue;
                this._slave_sets.add(node);
                this._slave_node_count_down.add(4);
            }
        }
    }

    private void useDefaultConfig() {
        String default_config = "";
        if (System.currentTimeMillis() - this._last_update_default_time <= (long)this._cc_update_interval && !this._base_sets.isEmpty()) {
            return;
        }
        default_config = this.updateDefaultConfig();
        if (default_config == null || default_config.isEmpty()) {
            if (this._base_sets.isEmpty()) {
                default_config = this._default_setting.getServerBackup(this._default_config_key);
                if (default_config == null) {
                    return;
                }
            } else {
                return;
            }
        }
        if (default_config.equals(this._last_default_config) && !this._base_sets.isEmpty()) {
            return;
        }
        this._last_default_config = default_config;
        this._base_sets.clear();
        this._base_node_count_down.clear();
        String[] ip_ports = default_config.split("\\|");
        for (int i = 0; i < ip_ports.length; ++i) {
            server_node node = server_node_pool.getNode(ip_ports[i]);
            if (node == null) continue;
            this._base_sets.add(node);
            this._base_node_count_down.add(4);
        }
    }

    private String updateDefaultConfig() {
        String default_config = this._config_center_service.CC_GetAttr("Access", "DefaultConfig", this._default_config_key);
        if (default_config == null) {
            return null;
        }
        this._last_update_default_time = System.currentTimeMillis();
        return default_config;
    }
}

