/*
 * Decompiled with CFR 0.152.
 */
package com.jd.wlogin.tools;

import com.jd.wlogin.tools.message_header;
import com.jd.wlogin.tools.util;
import java.io.UnsupportedEncodingException;

public class message_encoder {
    private static final int kDefaultMaxBytes = 16384;
    private int _max = 0;
    private int _pos = 0;
    private byte[] _buf = null;
    private message_header _header = null;

    public message_encoder(int max) {
        if (max < 31) {
            max = 31;
        }
        this._max = max;
        this._buf = new byte[this._max];
        this._header = new message_header();
        this.Reset_();
    }

    public message_encoder() {
        this(16384);
    }

    public short getCmd() {
        return this._header.cmd;
    }

    public short getAppId() {
        return this._header.app_id;
    }

    public short getSubCmd() {
        return this._header.sub_cmd;
    }

    private void Reset_() {
        this._pos = 31;
        this.UpdateLen_(31);
        this._header.uid = 0L;
        util.int64_to_buf(this._buf, 2, this._header.uid);
        this._header.partition = 0;
        util.int32_to_buf(this._buf, 10, this._header.partition);
        this._header.seq = 0;
        util.int32_to_buf(this._buf, 14, this._header.seq);
        this._header.client_ip = 0;
        util.int32_to_buf(this._buf, 18, this._header.client_ip);
        this._header.cmd = 0;
        util.int16_to_buf(this._buf, 22, this._header.cmd);
        this._header.sub_cmd = 0;
        util.int16_to_buf(this._buf, 24, this._header.sub_cmd);
        this._header.app_id = 0;
        util.int16_to_buf(this._buf, 26, this._header.app_id);
        this._header.version = (short)273;
        util.int16_to_buf(this._buf, 28, 273);
        this._header.status = 0;
        util.int8_to_buf(this._buf, 30, this._header.status);
    }

    private void UpdateLen_(int len) {
        this._header.len = (short)len;
        util.int16_to_buf(this._buf, 0, this._header.len);
    }

    public void set_uid(long uid) {
        this._header.uid = uid;
        util.int64_to_buf(this._buf, 2, this._header.uid);
    }

    public void set_partition(int partition) {
        this._header.partition = partition;
        util.int32_to_buf(this._buf, 10, this._header.partition);
    }

    public void set_seq(int seq) {
        this._header.seq = seq;
        util.int32_to_buf(this._buf, 14, this._header.seq);
    }

    public void set_client_ip(int client_ip) {
        this._header.client_ip = client_ip;
        util.int32_to_buf(this._buf, 18, this._header.client_ip);
    }

    public void set_cmd(short cmd) {
        this._header.cmd = cmd;
        util.int16_to_buf(this._buf, 22, this._header.cmd);
    }

    public void set_sub_cmd(short sub_cmd) {
        this._header.sub_cmd = sub_cmd;
        util.int16_to_buf(this._buf, 24, this._header.sub_cmd);
    }

    public void set_app_id(short app_id) {
        this._header.app_id = app_id;
        util.int16_to_buf(this._buf, 26, this._header.app_id);
    }

    public void set_status(byte status) {
        this._header.status = status;
        util.int8_to_buf(this._buf, 30, this._header.status);
    }

    public void Clear() {
        this.Reset_();
    }

    public byte[] buffer() {
        return this._buf;
    }

    public int len() {
        return this._pos;
    }

    public int seq() {
        return this._header.seq;
    }

    private void ensureWritable(int minWritableBytes) {
        int newMax;
        if (this._pos + minWritableBytes <= this._max) {
            return;
        }
        int newNeedMax = (this._pos + minWritableBytes) * 2;
        for (newMax = 64; newMax < newNeedMax; newMax <<= 1) {
        }
        byte[] newBuf = new byte[newMax];
        System.arraycopy(this._buf, 0, newBuf, 0, this._pos);
        this._buf = newBuf;
        this._max = newMax;
    }

    public void AddByteArray(int key, byte[] value) {
        this.AddByteArray(key, value, value.length);
    }

    public void AddByteArray(int key, byte[] value, int len) {
        this.AddByteArray(key, value, 0, len);
    }

    private void AddByteArray(int key, byte[] value, int pos, int len) {
        this.ensureWritable(4 + len);
        util.int16_to_buf(this._buf, this._pos, key);
        this._pos += 2;
        if (null == value) {
            len = 0;
        } else if (len > value.length) {
            len = value.length;
        }
        util.int16_to_buf(this._buf, this._pos, len);
        this._pos += 2;
        if (len > 0) {
            System.arraycopy(value, pos, this._buf, this._pos, len);
            this._pos += len;
        }
        this.UpdateLen_(this._pos);
    }

    public void AddInt8(int key, int value) {
        int len = 1;
        this.ensureWritable(4 + len);
        util.int16_to_buf(this._buf, this._pos, key);
        this._pos += 2;
        util.int16_to_buf(this._buf, this._pos, len);
        this._pos += 2;
        util.int8_to_buf(this._buf, this._pos, value);
        this._pos += len;
        this.UpdateLen_(this._pos);
    }

    public void AddInt16(int key, int value) {
        int len = 2;
        this.ensureWritable(4 + len);
        util.int16_to_buf(this._buf, this._pos, key);
        this._pos += 2;
        util.int16_to_buf(this._buf, this._pos, len);
        this._pos += 2;
        util.int16_to_buf(this._buf, this._pos, value);
        this._pos += len;
        this.UpdateLen_(this._pos);
    }

    public void AddInt32(int key, int value) {
        int len = 4;
        this.ensureWritable(4 + len);
        util.int16_to_buf(this._buf, this._pos, key);
        this._pos += 2;
        util.int16_to_buf(this._buf, this._pos, len);
        this._pos += 2;
        util.int32_to_buf(this._buf, this._pos, value);
        this._pos += len;
        this.UpdateLen_(this._pos);
    }

    public void AddInt64(int key, long value) {
        int len = 8;
        this.ensureWritable(4 + len);
        util.int16_to_buf(this._buf, this._pos, key);
        this._pos += 2;
        util.int16_to_buf(this._buf, this._pos, len);
        this._pos += 2;
        util.int64_to_buf(this._buf, this._pos, value);
        this._pos += len;
        this.UpdateLen_(this._pos);
    }

    public void AddString(int key, String value) {
        this.AddString(key, value, "UTF-8");
    }

    public void AddString(int key, String value, String charset_name) {
        byte[] buf = null;
        try {
            buf = value.getBytes(charset_name);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (null == buf) {
            this.AddByteArray(key, null, 0);
        } else {
            this.AddByteArray(key, buf, buf.length);
        }
    }
}

