/*
 * Decompiled with CFR 0.152.
 */
package com.jd.wlogin.cc;

import com.jd.wlogin.cc.CacheKeyProtocol;
import com.jd.wlogin.cc.IPPorts;
import com.jd.wlogin.cc.RequestConfig;
import com.jd.wlogin.tools.message_decoder;
import com.jd.wlogin.tools.message_encoder;
import com.jd.wlogin.tools.util;
import java.util.ArrayList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalCachedConfig {
    public static final int kChannelListMaxSize = 1000000;
    private RequestConfig _req_config = null;
    private static Map<String, IPPorts> _local_ip_ports = null;
    private static Map<String, String> _local_attr = null;
    private static Queue<String> _subscribe_channels = null;
    private String _exception_msg = null;

    LocalCachedConfig(String ccServiceUrl) {
        _local_ip_ports = new ConcurrentHashMap<String, IPPorts>();
        _local_attr = new ConcurrentHashMap<String, String>();
        _subscribe_channels = new LinkedBlockingQueue<String>(1000000);
        this._req_config = new RequestConfig();
        this._req_config.SetConfigCenterServiceAddr(ccServiceUrl);
    }

    public IPPorts GetLocalCachedAddr(String service_key) {
        if (_local_ip_ports.containsKey(service_key) && _local_ip_ports.get(service_key) != null) {
            return _local_ip_ports.get(service_key);
        }
        return null;
    }

    public void SetLocalCachedAddr(String service_key, ArrayList<String> master_ip_ports, ArrayList<String> slave_ip_ports, String channel) {
        if (master_ip_ports == null || slave_ip_ports == null) {
            return;
        }
        if (_local_ip_ports.get(service_key) == null) {
            _local_ip_ports.put(service_key, new IPPorts(master_ip_ports, slave_ip_ports));
            _subscribe_channels.offer(channel);
        } else {
            _local_ip_ports.get(service_key).setIpPorts(master_ip_ports, slave_ip_ports);
        }
    }

    public void SetLocalCachedAddr(String service_key, ArrayList<String> master_ip_ports, ArrayList<String> slave_ip_ports) {
        if (master_ip_ports == null || slave_ip_ports == null) {
            return;
        }
        if (_local_ip_ports.get(service_key) == null) {
            _local_ip_ports.put(service_key, new IPPorts(master_ip_ports, slave_ip_ports));
        } else {
            _local_ip_ports.get(service_key).setIpPorts(master_ip_ports, slave_ip_ports);
        }
    }

    public String GetLocalCachedAttr(String service_key) {
        if (_local_attr.containsKey(service_key) && _local_attr.get(service_key) != null) {
            return _local_attr.get(service_key);
        }
        return null;
    }

    public void SetLocalCachedAttr(String service_attr_key, String attr_value, String channel) {
        if (null == attr_value) {
            return;
        }
        if (_local_attr.get(service_attr_key) == null) {
            _local_attr.put(service_attr_key, attr_value);
            _subscribe_channels.offer(channel);
        } else {
            _local_attr.put(service_attr_key, attr_value);
        }
    }

    public void SetLocalCachedAttr(String service_attr_key, String attr_value) {
        if (null == attr_value) {
            return;
        }
        _local_attr.put(service_attr_key, attr_value);
    }

    public void FlushAllLocalCachedAddrs() {
        for (Map.Entry<String, IPPorts> entry : _local_ip_ports.entrySet()) {
            IPPorts ip_ports;
            String service_key = entry.getKey();
            message_encoder encoder = CacheKeyProtocol.ConvertAddrKeyToChannelEncoder(service_key);
            if (encoder == null || (ip_ports = this._req_config.CC_GetAddrs(encoder.buffer(), encoder.len())) == null) continue;
            this.SetLocalCachedAddr(service_key, ip_ports.getMasterIpPorts(), ip_ports.getSlaveIpPorts());
        }
    }

    public void FlushAllLocalCachedAttrs() {
        for (Map.Entry<String, String> entry : _local_attr.entrySet()) {
            String value;
            String service_key = entry.getKey();
            message_encoder encoder = CacheKeyProtocol.ConvertAttrKeyToChannelEncoder(service_key);
            if (encoder == null || (value = this._req_config.CC_GetAttr(encoder.buffer(), encoder.len())) == null) continue;
            this.SetLocalCachedAttr(service_key, value);
        }
    }

    public int FlushLocalCachedData(byte[] channel, int channel_len) {
        message_decoder decoder = new message_decoder(channel);
        short cmd = decoder.cmd();
        short sub_cmd = decoder.sub_cmd();
        this.ClearErr();
        if (cmd == 1 && sub_cmd == 32) {
            IPPorts ip_ports = this._req_config.CC_GetAddrs(channel, channel_len);
            if (ip_ports == null) {
                this._exception_msg = this._req_config.exception_msg();
                return -1;
            }
            String service_name = decoder.GetString(1);
            int app_id = decoder.GetInt16(2);
            String service_key = CacheKeyProtocol.EncodeAddrKey(service_name, app_id);
            this.SetLocalCachedAddr(service_key, ip_ports.getMasterIpPorts(), ip_ports.getSlaveIpPorts());
        } else if (cmd == 1 && sub_cmd == 21) {
            String value = this._req_config.CC_GetAttr(channel, channel_len);
            if (value == null) {
                this._exception_msg = this._req_config.exception_msg();
                return -1;
            }
            String service_name = decoder.GetString(1);
            String module = decoder.GetString(2);
            String attr_key = decoder.GetString(3);
            String service_key = CacheKeyProtocol.EncodeAttrKey(service_name, module, attr_key);
            this.SetLocalCachedAttr(service_key, value);
        }
        return 0;
    }

    public void GetAllSubscribeChannels() {
        String channel;
        message_encoder encoder;
        String service_key;
        _subscribe_channels.clear();
        for (Map.Entry<String, IPPorts> entry : _local_ip_ports.entrySet()) {
            service_key = entry.getKey();
            encoder = CacheKeyProtocol.ConvertAddrKeyToChannelEncoder(service_key);
            if (encoder == null) continue;
            channel = util.buf_to_string(encoder.buffer(), encoder.len());
            _subscribe_channels.offer(channel);
        }
        for (Map.Entry<String, Object> entry : _local_attr.entrySet()) {
            service_key = entry.getKey();
            encoder = CacheKeyProtocol.ConvertAttrKeyToChannelEncoder(service_key);
            if (encoder == null) continue;
            channel = util.buf_to_string(encoder.buffer(), encoder.len());
            _subscribe_channels.offer(channel);
        }
    }

    private void ClearErr() {
        this._exception_msg = "";
    }

    public Queue<String> subscribe_channels() {
        return _subscribe_channels;
    }

    public String exception_msg() {
        return this._exception_msg;
    }
}

