/*
 * Decompiled with CFR 0.152.
 */
package com.jd.wlogin.cc.agent;

import com.jd.wlogin.tools.util;

public class FifoBuffer {
    private static final int kFifoBufferSize = 0x100000;
    private byte[] _buf = new byte[this._size];
    private int _in_pos = 0;
    private int _out_pos = 0;
    private int _size = 0x100000;

    public int GetTotalPackage(byte[] buf) {
        byte[] tmp_buffer = new byte[4096];
        int msg_head_bytes = 31;
        int get_bytes = this.Query(tmp_buffer, msg_head_bytes);
        if (get_bytes < msg_head_bytes) {
            return -1;
        }
        int msg_total_len = util.buf_to_int16(tmp_buffer, 0);
        get_bytes = Math.min(msg_total_len, this.UsedSize());
        if (get_bytes < msg_total_len) {
            return -1;
        }
        get_bytes = this.Get(buf, msg_total_len);
        return get_bytes;
    }

    public int Put(byte[] buf, int bufLen) {
        int lengthToPut = Math.min(bufLen, this.AvailableSize());
        int len = Math.min(lengthToPut, this._size - (this._in_pos & this._size - 1));
        System.arraycopy(buf, 0, this._buf, this._in_pos & this._size - 1, len);
        System.arraycopy(buf, len, this._buf, 0, lengthToPut - len);
        this._in_pos += lengthToPut;
        return lengthToPut;
    }

    public int Get(byte[] buf, int maxBufLen) {
        int lengthToGet = Math.min(maxBufLen, this.UsedSize());
        int len = Math.min(lengthToGet, this._size - (this._out_pos & this._size - 1));
        System.arraycopy(this._buf, this._out_pos & this._size - 1, buf, 0, len);
        System.arraycopy(this._buf, 0, buf, len, lengthToGet - len);
        this._out_pos += lengthToGet;
        return lengthToGet;
    }

    private int Query(byte[] buf, int maxBufLen) {
        int lengthToGet = Math.min(maxBufLen, this.UsedSize());
        int len = Math.min(lengthToGet, this._size - (this._out_pos & this._size - 1));
        System.arraycopy(this._buf, this._out_pos & this._size - 1, buf, 0, len);
        System.arraycopy(this._buf, 0, buf, len, lengthToGet - len);
        return lengthToGet;
    }

    private int AvailableSize() {
        return this._size - this._in_pos + this._out_pos;
    }

    private int UsedSize() {
        return this._in_pos - this._out_pos;
    }
}

