/*
 * Decompiled with CFR 0.152.
 */
package com.jd.wlogin.cc.agent;

import com.jd.wlogin.cc.LocalCachedConfig;
import com.jd.wlogin.cc.agent.FifoBuffer;
import com.jd.wlogin.cc.agent.PublishService;
import com.jd.wlogin.cc.agent.SubscribeProtocol;
import com.jd.wlogin.server.server_node;
import com.jd.wlogin.tools.message_decoder;
import com.jd.wlogin.tools.message_encoder;
import com.jd.wlogin.tools.util;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Set;

public class config_agent
implements Runnable {
    private static final int PEER_FLUSH_SEC = 300000 + util.get_rand_32() % 500;
    private static final int PEER_HERATBEAT_SEC = 40000;
    private static final int BUFFER_MAX_SIZE = 32768;
    private static final int kHeartBeatPackage = 1;
    private static final int kDataPackage = 2;
    private ByteBuffer _send_buffer = ByteBuffer.allocate(32768);
    private ByteBuffer _receive_buffer = ByteBuffer.allocate(32768);
    private LocalCachedConfig _local_cached_config = null;
    private PublishService _publish_service = null;
    private FifoBuffer _fifo_buffer = null;
    private long _last_flush_time = 0L;
    private long _last_heart_time = 0L;
    boolean _running = true;

    public config_agent(LocalCachedConfig local_cached_config) {
        this._local_cached_config = local_cached_config;
        this._publish_service = new PublishService();
        this._fifo_buffer = new FifoBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        server_node publish_node = this._publish_service.GetPublishSvrAddr();
        if (publish_node == null) {
            return;
        }
        while (this._running) {
            SocketChannel socket_channel = null;
            Selector selector = null;
            this._local_cached_config.GetAllSubscribeChannels();
            this.FlushAllLocalCachedData();
            try {
                socket_channel = SocketChannel.open();
                socket_channel.configureBlocking(false);
                selector = Selector.open();
                socket_channel.connect(new InetSocketAddress(publish_node.ip, publish_node.port));
                socket_channel.register(selector, 13);
                boolean is_finish_connect = false;
                block26: while (this._running) {
                    int package_type = 0;
                    this.FlushAllLocalCachedData();
                    long now = System.currentTimeMillis();
                    if (now - this._last_heart_time > 40000L) {
                        package_type = 1;
                        if (is_finish_connect) {
                            socket_channel.register(selector, 4);
                        } else {
                            socket_channel.register(selector, 12);
                        }
                        this._last_heart_time = now;
                    }
                    if (!this._local_cached_config.subscribe_channels().isEmpty()) {
                        package_type = 2;
                        if (is_finish_connect) {
                            socket_channel.register(selector, 4);
                        } else {
                            socket_channel.register(selector, 12);
                        }
                    }
                    selector.select(1000L);
                    Set<SelectionKey> selectionKeys = selector.selectedKeys();
                    for (SelectionKey selectionKey : selectionKeys) {
                        socket_channel = (SocketChannel)selectionKey.channel();
                        if (selectionKey.isConnectable()) {
                            if (!socket_channel.isConnectionPending()) continue;
                            socket_channel.finishConnect();
                            is_finish_connect = true;
                            continue;
                        }
                        if (selectionKey.isReadable()) {
                            int total_recv_len = 0;
                            int recv_len = 0;
                            while (this._running) {
                                this._receive_buffer.clear();
                                recv_len = socket_channel.read(this._receive_buffer);
                                if (recv_len <= 0) break;
                                this._fifo_buffer.Put(this._receive_buffer.array(), recv_len);
                                total_recv_len += recv_len;
                            }
                            if (recv_len < 0) {
                                selectionKey.cancel();
                                selector.close();
                                socket_channel.close();
                                continue block26;
                            }
                            if (total_recv_len <= 0) continue;
                            this.HandleRecvMessage();
                            continue;
                        }
                        if (!selectionKey.isWritable()) continue;
                        int send_flag = this.HandleSendMessage(package_type);
                        if (0 == send_flag) {
                            int ret = 0;
                            while (this._send_buffer.hasRemaining() && (ret = socket_channel.write(this._send_buffer)) > 0) {
                            }
                        }
                        socket_channel.register(selector, 1);
                    }
                }
                selector.close();
            }
            catch (ConnectException conn_e) {
                try {
                    socket_channel.close();
                    selector.close();
                    Thread.sleep(3000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this._publish_service.RemovePublishSvrAddr();
                publish_node = this._publish_service.GetPublishSvrAddr();
                if (publish_node != null) continue;
                return;
            }
            catch (Exception e) {
                try {
                    socket_channel.close();
                    selector.close();
                    Thread.sleep(3000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if ((publish_node = this._publish_service.GetPublishSvrAddr()) != null) continue;
                return;
            }
            finally {
                try {
                    socket_channel.close();
                    selector.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void FlushAllLocalCachedData() {
        long now = System.currentTimeMillis();
        if (now - this._last_flush_time > (long)PEER_FLUSH_SEC) {
            this._local_cached_config.FlushAllLocalCachedAddrs();
            this._local_cached_config.FlushAllLocalCachedAttrs();
            this._last_flush_time = now;
        }
    }

    private void HandleRecvMessage() {
        byte[] fifo_buffer;
        int get_bytes;
        while (this._running && -1 != (get_bytes = this._fifo_buffer.GetTotalPackage(fifo_buffer = new byte[32768]))) {
            int ret;
            byte[] channel;
            message_decoder decoder;
            if (message_decoder.Check(fifo_buffer, get_bytes) <= 0 || SubscribeProtocol.Decode(decoder = new message_decoder(fifo_buffer)) != 0) continue;
            short cmd = SubscribeProtocol.cmd();
            short sub_cmd = SubscribeProtocol.sub_cmd();
            if ((cmd == 2 && sub_cmd == 3 || cmd == 2 && sub_cmd == 6) && message_decoder.Check(channel = SubscribeProtocol.output_byte_array(), channel.length) > 0 && (ret = this._local_cached_config.FlushLocalCachedData(channel, channel.length)) == 0) continue;
        }
    }

    private int HandleSendMessage(int package_type) {
        if (package_type == 1 || package_type == 2 && !this._local_cached_config.subscribe_channels().isEmpty()) {
            message_encoder encoder = new message_encoder(1024);
            String data = "";
            if (package_type == 1) {
                SubscribeProtocol.Encode(encoder, 2, 2, data.getBytes());
            } else if (package_type == 2) {
                data = this._local_cached_config.subscribe_channels().poll();
                SubscribeProtocol.Encode(encoder, 2, 4, util.string_to_buf(data));
            }
            this._send_buffer.clear();
            this._send_buffer.put(encoder.buffer(), 0, encoder.len());
            this._send_buffer.flip();
            return 0;
        }
        return -1;
    }
}

