/*
 * Decompiled with CFR 0.152.
 */
package com.jd.wlogin.request;

import com.jd.wlogin.request.socket_request;
import com.jd.wlogin.tools.message_decoder;
import com.jd.wlogin.tools.message_encoder;
import com.jd.wlogin.tools.util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;

public class tcp_request
implements socket_request {
    public static final int kSuccess = 0;
    public static final int kErrorCreateSocketFailed = -1;
    public static final int kErrorSetTimeoutFailed = -2;
    public static final int kErrorUnknownHost = -3;
    public static final int kErrorSendDataFailed = -4;
    public static final int kErrorRecvTimeout = -5;
    public static final int kErrorRecvFailed = -6;
    public static final int kErrorConnectFailed = -7;
    public static final int kErrorSetTcpNoDelayFailed = -8;
    public static final int kErrorSetTcpLingerFailed = -9;
    public static final int kErrorCloseSocketFailed = -10;
    private byte[] _recv_buf = null;
    private int _recv_buf_size = 0;
    private int _recv_buf_len = 0;
    private int _timeout = 0;
    private String _exception_msg = null;

    public tcp_request(int recv_buf_size, int timeout) {
        this._recv_buf_size = recv_buf_size;
        this._recv_buf = new byte[this._recv_buf_size];
        this._timeout = timeout;
    }

    public int Request(message_encoder encoder, String server_ip, int server_port) {
        return this.Request(encoder, server_ip, server_port, this._timeout);
    }

    public int Request(message_encoder encoder, String server_ip, int server_port, int timeout) {
        this._exception_msg = "";
        this._recv_buf_len = 0;
        try {
            Socket client = new Socket();
            try {
                client.setTcpNoDelay(true);
            }
            catch (SocketException e) {
                client.close();
                this._exception_msg = e.getMessage();
                return -8;
            }
            try {
                client.setSoLinger(false, 0);
            }
            catch (SocketException e) {
                client.close();
                this._exception_msg = e.getMessage();
                return -9;
            }
            if (timeout > 0) {
                try {
                    client.setSoTimeout(timeout);
                }
                catch (SocketException e) {
                    client.close();
                    this._exception_msg = e.getMessage();
                    return -2;
                }
            }
            InetAddress server_ip_addr = null;
            try {
                server_ip_addr = InetAddress.getByName(server_ip);
            }
            catch (UnknownHostException e) {
                client.close();
                this._exception_msg = e.getMessage();
                return -3;
            }
            try {
                InetSocketAddress server_addr = new InetSocketAddress(server_ip_addr, server_port);
                client.connect(server_addr, timeout);
            }
            catch (IOException e) {
                client.close();
                this._exception_msg = e.getMessage();
                return -7;
            }
            try {
                OutputStream outgoing = client.getOutputStream();
                outgoing.write(encoder.buffer(), 0, encoder.len());
            }
            catch (IOException e) {
                client.close();
                this._exception_msg = e.getMessage();
                return -4;
            }
            try {
                int offset;
                InputStream incoming = client.getInputStream();
                int ret = 0;
                for (offset = 0; offset < 31; offset += ret) {
                    ret = incoming.read(this._recv_buf, offset, 31 - offset);
                    if (ret >= 0) continue;
                    client.close();
                    this._exception_msg = "Read Message Header Failed";
                    return -6;
                }
                short version = (short)util.buf_to_int16(this._recv_buf, 28);
                if (version != 273) {
                    client.close();
                    this._exception_msg = "Response Message Version Invalid";
                    return -6;
                }
                int message_len = util.buf_to_int16(this._recv_buf, 0);
                if (message_len > this._recv_buf_size) {
                    client.close();
                    this._exception_msg = "Response Message Len is Too Long";
                    return -6;
                }
                while (offset < message_len) {
                    ret = incoming.read(this._recv_buf, offset, message_len - offset);
                    if (ret < 0) {
                        client.close();
                        this._exception_msg = "Read Message Header Failed";
                        return -6;
                    }
                    offset += ret;
                }
                this._recv_buf_len = offset;
                this._exception_msg = "";
            }
            catch (SocketTimeoutException e) {
                client.close();
                this._exception_msg = e.getMessage();
                return -5;
            }
            catch (IOException e) {
                client.close();
                this._exception_msg = e.getMessage();
                return -6;
            }
            client.close();
            return 0;
        }
        catch (IOException e) {
            this._exception_msg = e.getMessage();
            return -10;
        }
    }

    public byte[] recv_buf() {
        return this._recv_buf;
    }

    public int recv_buf_len() {
        return this._recv_buf_len;
    }

    public String exception_msg() {
        return this._exception_msg;
    }

    public static void main(String[] args) {
        message_encoder encoder = new message_encoder();
        encoder.set_uid(123456L);
        encoder.set_partition(4660);
        encoder.set_seq(17);
        encoder.set_app_id((short)1);
        encoder.set_cmd((short)1);
        encoder.set_sub_cmd((short)2);
        encoder.AddString(100, "I Love You\uff0c\u6211\u7231\u4f60");
        encoder.AddInt16(101, 789);
        tcp_request r = new tcp_request(8192, 100);
        System.out.println(System.currentTimeMillis());
        int ret = 0;
        for (int i = 0; i < 1; ++i) {
            ret = r.Request(encoder, "192.168.144.119", 14011);
        }
        System.out.println(System.currentTimeMillis());
        System.out.println("ret: " + ret + ", msg: " + r.exception_msg());
        System.out.println("Response Len: " + r.recv_buf_len());
        System.out.println("Response: " + util.buf_to_string(r.recv_buf(), r.recv_buf_len()));
        if (message_decoder.Check(r.recv_buf(), r.recv_buf_len(), encoder.seq()) <= 0) {
            System.out.println("message check failed");
            return;
        }
        message_decoder decoder = new message_decoder(r.recv_buf());
        System.out.println("len: " + decoder.len());
        System.out.println("uid: " + decoder.uid());
        System.out.println("partition: " + decoder.partition());
        System.out.println("seq: " + decoder.seq());
        System.out.println("appid: " + decoder.app_id());
        System.out.println("cmd: " + decoder.cmd());
        System.out.println("sub_cmd: " + decoder.sub_cmd());
        System.out.println("status: 0x" + Integer.toHexString(decoder.status()));
    }
}

