/*
 * Decompiled with CFR 0.152.
 */
package com.jd.wlogin.server;

import com.jd.wlogin.request.udp_request;
import com.jd.wlogin.server.server_node;
import com.jd.wlogin.server.server_set_util;
import com.jd.wlogin.tools.message_encoder;

public class server_set {
    private String _exception_msg = null;
    private String _last_used_server_ip = null;
    private server_set_util _server_set = null;

    public server_set(String service_name, int app_id) {
        String default_config_key = "LoginServiceAddr";
        if (service_name.startsWith("Jdopen_")) {
            default_config_key = "Jdopen_LoginServiceAddr";
        }
        this._server_set = new server_set_util(service_name, app_id, default_config_key);
    }

    public int request(message_encoder encoder, udp_request req) {
        return this.request(encoder, req, -1);
    }

    public int request(message_encoder encoder, udp_request req, int timeout) {
        server_node node = this._server_set.getNode();
        this._exception_msg = "ip:port = " + node.ip + ":" + node.port;
        if (node == null) {
            this._exception_msg = "get config failed: no alive server node";
            this._last_used_server_ip = null;
            return -2;
        }
        this._last_used_server_ip = node.ip;
        int ret = 0;
        ret = timeout > 0 ? req.Request(encoder, node.ip, node.port, timeout) : req.Request(encoder, node.ip, node.port);
        if (ret != 0) {
            this._server_set.removeNode();
            this._exception_msg = "connect to " + node.ip + ":" + node.port + " failed: " + req.exception_msg() + ", errcode:" + ret;
            return -1;
        }
        return 0;
    }

    public String last_used_server_ip() {
        return this._last_used_server_ip;
    }

    public String exception_msg() {
        return this._exception_msg;
    }
}

