/*
 * Decompiled with CFR 0.152.
 */
package com.jd.wlogin.tlv_type;

import com.jd.wlogin.tools.util;
import java.io.UnsupportedEncodingException;

public class tlv_buffer {
    private byte[] _buf = null;
    private int _pos = 0;
    private int _max = 0;
    private int _start_pos = 0;
    private int _offset = 0;
    private int _real_len = 0;

    public tlv_buffer(int max) {
        this._buf = new byte[max];
        this._pos = 0;
        this._max = max;
    }

    public tlv_buffer(byte[] buf, int pos, int len) {
        this._buf = buf;
        this._start_pos = pos;
        this._offset = 0;
        this._real_len = len;
    }

    private void ensureWritable(int minWritableBytes) {
        int newMax;
        if (this._pos + minWritableBytes <= this._max) {
            return;
        }
        int newNeedMax = (this._pos + minWritableBytes) * 2;
        for (newMax = 64; newMax < newNeedMax; newMax <<= 1) {
        }
        byte[] newBuf = new byte[newMax];
        System.arraycopy(this._buf, 0, newBuf, 0, this._pos);
        this._buf = newBuf;
        this._max = newMax;
    }

    public tlv_buffer(byte[] buf, int len) {
        this(buf, 0, len);
    }

    public tlv_buffer(byte[] buf) {
        this(buf, 0, buf.length);
    }

    public void AddByteArrayWithLen(byte[] value, int pos, int len) {
        if (null == value) {
            len = 0;
        }
        this.AddInt16(len);
        this.AddByteArray(value, pos, len);
    }

    private void AddByteArray(byte[] value, int pos, int len) {
        if (null != value) {
            this.ensureWritable(len);
            System.arraycopy(value, pos, this._buf, this._pos, len);
            this._pos += len;
        }
    }

    private void AddByteArray(byte[] value, int len) {
        this.AddByteArray(value, 0, len);
    }

    private void AddByteArray(byte[] value) {
        if (null != value) {
            this.AddByteArray(value, value.length);
        }
    }

    public void AddInt8(int value) {
        this.ensureWritable(1);
        util.int8_to_buf(this._buf, this._pos, value);
        ++this._pos;
    }

    public void AddInt16(int value) {
        this.ensureWritable(2);
        util.int16_to_buf(this._buf, this._pos, value);
        this._pos += 2;
    }

    public void AddInt32(int value) {
        this.ensureWritable(4);
        util.int32_to_buf(this._buf, this._pos, value);
        this._pos += 4;
    }

    public void AddInt64(long value) {
        this.ensureWritable(8);
        util.int64_to_buf(this._buf, this._pos, value);
        this._pos += 8;
    }

    public void AddString(String value, String charset_name) {
        if (value == null) {
            value = "";
        }
        byte[] str_bytes = null;
        try {
            str_bytes = value.getBytes(charset_name);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (null == str_bytes) {
            this.AddInt16(0);
        } else {
            this.AddInt16(str_bytes.length);
            this.AddByteArray(str_bytes);
        }
    }

    public void AddString(String value) {
        this.AddString(value, "UTF-8");
    }

    public void AddStringByByteArray(String value, String charset_name) {
        value = null == value ? "" : value;
        byte[] str_bytes = null;
        try {
            str_bytes = value.getBytes(charset_name);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (null != str_bytes) {
            this.AddByteArray(str_bytes);
        }
    }

    public void AddStringByByteArray(String value) {
        this.AddStringByByteArray(value, "UTF-8");
    }

    public void Clear() {
        this._buf = null;
        this._pos = 0;
        this._start_pos = 0;
        this._offset = 0;
        this._real_len = 0;
    }

    public byte[] buf() {
        return this._buf;
    }

    public int len() {
        return this._pos;
    }

    public byte[] GetByteArrayWithLen() {
        if (this._offset + 2 > this._real_len) {
            return null;
        }
        int byte_array_len = util.buf_to_int16(this._buf, this._start_pos + this._offset);
        this._offset += 2;
        if (this._offset + byte_array_len > this._real_len) {
            return null;
        }
        byte[] buf = new byte[byte_array_len];
        System.arraycopy(this._buf, this._start_pos + this._offset, buf, 0, byte_array_len);
        this._offset += byte_array_len;
        return buf;
    }

    public Integer GetInt8() {
        if (this._offset + 1 > this._real_len) {
            return null;
        }
        Integer result = new Integer(util.buf_to_int8(this._buf, this._start_pos + this._offset));
        ++this._offset;
        return result;
    }

    public Integer GetInt16() {
        if (this._offset + 2 > this._real_len) {
            return null;
        }
        Integer result = new Integer(util.buf_to_int16(this._buf, this._start_pos + this._offset));
        this._offset += 2;
        return result;
    }

    public Integer GetInt32() {
        if (this._offset + 4 > this._real_len) {
            return null;
        }
        Integer result = new Integer(util.buf_to_int32(this._buf, this._start_pos + this._offset));
        this._offset += 4;
        return result;
    }

    public Long GetInt64() {
        if (this._offset + 8 > this._real_len) {
            return null;
        }
        Long result = new Long(util.buf_to_int64(this._buf, this._start_pos + this._offset));
        this._offset += 8;
        return result;
    }

    public String GetString(String charset_name) {
        if (this._offset + 2 > this._real_len) {
            return null;
        }
        int str_len = util.buf_to_int16(this._buf, this._start_pos + this._offset);
        this._offset += 2;
        if (this._offset + str_len > this._real_len) {
            return null;
        }
        String ret_str = null;
        try {
            ret_str = new String(this._buf, this._start_pos + this._offset, str_len, charset_name);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        this._offset += str_len;
        return ret_str;
    }

    public String GetString() {
        return this.GetString("UTF-8");
    }

    public String GetStringFromByteArray(int byte_array_len, String charset_name) {
        String ret_str = null;
        try {
            ret_str = new String(this._buf, this._start_pos + this._offset, byte_array_len, charset_name);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        this._offset += byte_array_len;
        return ret_str;
    }

    public String GetStringFromByteArray(int byte_array_len) {
        return this.GetStringFromByteArray(byte_array_len, "UTF-8");
    }
}

