/*
 * Decompiled with CFR 0.152.
 */
package com.jd.wlogin.tools;

import com.jd.wlogin.tools.message_byte_array_result;
import com.jd.wlogin.tools.message_header;
import com.jd.wlogin.tools.util;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class message_decoder {
    private static final short kMessageAttrHeaderLen = 4;
    private byte[] _buf = null;
    private message_header _header = new message_header();
    private Map<Integer, ArrayList<message_attr_value>> _attr = null;

    public static int Check(byte[] buf, int len, int seq) {
        if (len < 31) {
            return 0;
        }
        short version = (short)util.buf_to_int16(buf, 28);
        if (version != 273) {
            return -1;
        }
        int msg_len = util.buf_to_int16(buf, 0);
        if (len < msg_len) {
            return 0;
        }
        if (seq != util.buf_to_int32(buf, 14)) {
            return -1;
        }
        return msg_len;
    }

    public static int Check(byte[] buf, int len) {
        if (len < 31) {
            return 0;
        }
        short version = (short)util.buf_to_int16(buf, 28);
        if (version != 273) {
            return -1;
        }
        int msg_len = util.buf_to_int16(buf, 0);
        if (len < msg_len) {
            return 0;
        }
        return msg_len;
    }

    public message_decoder(byte[] buf) {
        this._buf = buf;
        this._header.len = (short)util.buf_to_int16(this._buf, 0);
        this._header.uid = util.buf_to_int64(this._buf, 2);
        this._header.partition = util.buf_to_int32(this._buf, 10);
        this._header.seq = util.buf_to_int32(this._buf, 14);
        this._header.client_ip = util.buf_to_int32(this._buf, 18);
        this._header.cmd = (short)util.buf_to_int16(this._buf, 22);
        this._header.sub_cmd = (short)util.buf_to_int16(this._buf, 24);
        this._header.app_id = (short)util.buf_to_int16(this._buf, 26);
        this._header.version = (short)util.buf_to_int16(this._buf, 28);
        this._header.status = (byte)util.buf_to_int8(this._buf, 30);
        this._attr = new HashMap<Integer, ArrayList<message_attr_value>>();
        int body_len = this._header.len - 31;
        int offset = 0;
        int pos = 31 + offset;
        while (offset + 4 <= body_len) {
            ArrayList<Object> arr_val;
            int key = util.buf_to_int16(this._buf, pos);
            int val_len = util.buf_to_int16(this._buf, pos += 2);
            pos += 2;
            if (offset + 4 + val_len > body_len) break;
            message_attr_value value = new message_attr_value(pos, val_len);
            Integer tlv_key = key;
            if (!this._attr.containsKey(tlv_key)) {
                arr_val = new ArrayList<message_attr_value>();
                arr_val.add(value);
                this._attr.put(tlv_key, arr_val);
            } else {
                arr_val = this._attr.get(tlv_key);
                arr_val.add(value);
            }
            offset += 4 + val_len;
            pos += val_len;
        }
    }

    public byte[] buffer() {
        return this._buf;
    }

    public int len() {
        return this._header.len & 0xFFFF;
    }

    public long uid() {
        return this._header.uid;
    }

    public int partition() {
        return this._header.partition;
    }

    public int seq() {
        return this._header.seq;
    }

    public int client_ip() {
        return this._header.client_ip;
    }

    public short cmd() {
        return this._header.cmd;
    }

    public short sub_cmd() {
        return this._header.sub_cmd;
    }

    public short app_id() {
        return this._header.app_id;
    }

    public short version() {
        return this._header.version;
    }

    public byte status() {
        return this._header.status;
    }

    public byte[] GetByteArray(int key) {
        ArrayList<message_attr_value> arr_val = this._attr.get(key);
        if (null == arr_val) {
            return null;
        }
        message_attr_value value = arr_val.get(0);
        byte[] val_buf = new byte[value.len];
        System.arraycopy(this._buf, value.pos, val_buf, 0, value.len);
        return val_buf;
    }

    public message_byte_array_result GetByteArrayByReference(int key) {
        ArrayList<message_attr_value> arr_val = this._attr.get(key);
        if (null == arr_val) {
            return null;
        }
        message_attr_value value = arr_val.get(0);
        return new message_byte_array_result(this._buf, value.pos, value.len);
    }

    public ArrayList<message_byte_array_result> GetByteArrayArrayByReference(int key) {
        ArrayList<message_attr_value> arr_val = this._attr.get(key);
        if (null == arr_val) {
            return null;
        }
        ArrayList<message_byte_array_result> result = new ArrayList<message_byte_array_result>();
        for (message_attr_value value : arr_val) {
            result.add(new message_byte_array_result(this._buf, value.pos, value.len));
        }
        return result;
    }

    public Integer GetInt8(int key) {
        ArrayList<message_attr_value> arr_val = this._attr.get(key);
        if (null == arr_val) {
            return null;
        }
        message_attr_value value = arr_val.get(0);
        return new Integer(util.buf_to_int8(this._buf, value.pos));
    }

    public ArrayList<Integer> GetInt8Array(int key) {
        ArrayList<message_attr_value> arr_val = this._attr.get(key);
        if (null == arr_val) {
            return null;
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < arr_val.size(); ++i) {
            result.add(new Integer(util.buf_to_int8(this._buf, arr_val.get((int)i).pos)));
        }
        return result;
    }

    public Integer GetInt16(int key) {
        ArrayList<message_attr_value> arr_val = this._attr.get(key);
        if (null == arr_val) {
            return null;
        }
        message_attr_value value = arr_val.get(0);
        return new Integer(util.buf_to_int16(this._buf, value.pos));
    }

    public ArrayList<Integer> GetInt16Array(int key) {
        ArrayList<message_attr_value> arr_val = this._attr.get(key);
        if (null == arr_val) {
            return null;
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < arr_val.size(); ++i) {
            result.add(new Integer(util.buf_to_int16(this._buf, arr_val.get((int)i).pos)));
        }
        return result;
    }

    public Integer GetInt32(int key) {
        ArrayList<message_attr_value> arr_val = this._attr.get(key);
        if (null == arr_val) {
            return null;
        }
        message_attr_value value = arr_val.get(0);
        return new Integer(util.buf_to_int32(this._buf, value.pos));
    }

    public ArrayList<Integer> GetInt32Array(int key) {
        ArrayList<message_attr_value> arr_val = this._attr.get(key);
        if (null == arr_val) {
            return null;
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < arr_val.size(); ++i) {
            result.add(new Integer(util.buf_to_int32(this._buf, arr_val.get((int)i).pos)));
        }
        return result;
    }

    public Long GetInt64(int key) {
        ArrayList<message_attr_value> arr_val = this._attr.get(key);
        if (null == arr_val) {
            return null;
        }
        message_attr_value value = arr_val.get(0);
        return new Long(util.buf_to_int64(this._buf, value.pos));
    }

    public ArrayList<Long> GetInt64Array(int key) {
        ArrayList<message_attr_value> arr_val = this._attr.get(key);
        if (null == arr_val) {
            return null;
        }
        ArrayList<Long> result = new ArrayList<Long>();
        for (int i = 0; i < arr_val.size(); ++i) {
            result.add(new Long(util.buf_to_int64(this._buf, arr_val.get((int)i).pos)));
        }
        return result;
    }

    public String GetString(int key, String charset_name) {
        ArrayList<message_attr_value> arr_val = this._attr.get(key);
        if (null == arr_val) {
            return null;
        }
        message_attr_value value = arr_val.get(0);
        String ret_str = null;
        try {
            ret_str = new String(this._buf, value.pos, value.len, charset_name);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        return ret_str;
    }

    public String GetString(int key) {
        return this.GetString(key, "UTF-8");
    }

    public ArrayList<byte[]> GetByteArrayArray(int key) {
        ArrayList<message_attr_value> arr_val = this._attr.get(key);
        if (null == arr_val) {
            return null;
        }
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        for (int i = 0; i < arr_val.size(); ++i) {
            byte[] bytes = new byte[arr_val.get((int)i).len];
            System.arraycopy(this._buf, arr_val.get((int)i).pos, bytes, 0, arr_val.get((int)i).len);
            result.add(bytes);
        }
        return result;
    }

    public ArrayList<String> GetStringArray(int key, String charset_name) {
        ArrayList<message_attr_value> arr_val = this._attr.get(key);
        if (null == arr_val) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < arr_val.size(); ++i) {
            String str_ret = null;
            try {
                str_ret = new String(this._buf, arr_val.get((int)i).pos, arr_val.get((int)i).len, charset_name);
            }
            catch (UnsupportedEncodingException e) {
                continue;
            }
            result.add(str_ret);
        }
        return result;
    }

    public ArrayList<String> GetStringArray(int key) {
        return this.GetStringArray(key, "UTF-8");
    }

    class message_attr_value {
        int pos = 0;
        int len = 0;

        public message_attr_value(int pos, int len) {
            this.pos = pos;
            this.len = len;
        }
    }
}

