//格式化代码函数,已经用原生方式写好了不需要改动,直接引用就好
    var formatJson = function (json) {
        var formatted = '',     //转换后的json字符串
            padIdx = 0,         //换行后是否增减PADDING的标识
            PADDING = '        ';   //6个空格符
        /**
         * 将对象转化为string
         */
        if (typeof json !== 'string') {
            json = JSON.stringify(json);
        }
        /** 
         *利用正则类似将{'name':'ccy','age':18,'info':['address':'wuhan','interest':'playCards']}
         *---> \r\n{\r\n'name':'ccy',\r\n'age':18,\r\n
         *'info':\r\n[\r\n'address':'wuhan',\r\n'interest':'playCards'\r\n]\r\n}\r\n
         */
        json = json.replace(/([\{\}])/g, '\r\n$1\r\n')
                    .replace(/([\[\]])/g, '\r\n$1\r\n')
                    .replace(/(\,)/g, '$1\r\n')
                    .replace(/(\r\n\r\n)/g, '\r\n')
                    .replace(/\r\n\,/g, ',');
        /** 
         * 根据split生成数据进行遍历，一行行判断是否增减PADDING
         */
       (json.split('\r\n')).forEach(function (node, index) {
    	   if(node == null || Trim(node) == ''){
    		   return;
    	   }
            var indent = 0,
                padding = '';
            if (node.match(/\{$/) || node.match(/\[$/)) indent = 1;
            else if (node.match(/\}/) || node.match(/\]/))  padIdx = padIdx !== 0 ? --padIdx : padIdx;
            else    indent = 0;
            for (var i = 0; i < padIdx; i++)    padding += PADDING;
            formatted += padding + Trim(node) + '\r\n';
            padIdx += indent;
            //console.log('index:'+index+',indent:'+indent+',padIdx:'+padIdx+',node-->'+node);
        });
        return formatted;
    };
    var Trim=function Trim(str)
    { 
     return str.replace(/(^\s*)|(\s*$)/g, ""); 
   }
    //引用示例部分
    //var originalJson = {'name':'ccy','age':18,'info':[{'address':'wuhan'},{'interest':'playCards'}]};
    var showJson = function(inputName){
        var originalJson = document.getElementById(inputName).value;
        //(2)调用formatJson函数,将json格式进行格式化
        if(!isJSON(originalJson)){
        	return false;
        }
        var resultJson = formatJson(originalJson);
        document.getElementById(inputName).value = resultJson;
    }
    //判断是否为json字符串
    var isJSON = function(str) {
        if (typeof str == 'string') {
            try {
                var obj=JSON.parse(str);
                if(typeof obj == 'object' && obj ){
                    return true;
                }else{
                	if(typeof JSON.parse(obj) == 'object' && obj){
                		 return true;
                	}
                    return false;
                }
            } catch(e) {
                return false;
            }
        }
        return isJSON(JSON.stringify(str));
    }
    //如果为json则转换为json对象
    var isJSONParse = function(str) {
    	if(isJSON(str)){
    		return JSON.parse(str);
    	}
        return str;
    }
    //如果为json则转换为json字符串
    var isJSONStringify = function(obj) {
    	if(isJSON(obj)){
    		return JSON.stringify(obj)
    	}
    	return obj;
    }