/**
 * Created by ByWei.Cn on 2019/5/20.
 */
layui.config({
    base: 'webjars/swagger-lazydoc/assets/layext/'
}).extend({
    nlaytpl: 'nlaytpl',
    ncmntool: 'ncmntool',
    nswagger: 'nswagger',
    nupload: 'nupload'
});
//
layui.use(['layer', 'element', 'form', 'nlaytpl', 'nswagger', 'ncmntool', 'upload'], function () {
    var $ = layui.jquery,
        layer = layui.layer,
        element = layui.element,
        form = layui.form,
        ncmntool = layui.ncmntool,
        nlaytpl = layui.nlaytpl,
        nswagger = layui.nswagger,
        doc_cookie = "swldoc",
        apiCloudDoc = null;

    $(".logo").click(function () {
        $(".nav-home").click();
        $(".layui-side-scroll").scrollTop(0);
    });
    function getContextPath() {
        var pathName = document.location.pathname;
        var index = pathName.substr(1).indexOf("/");
        var result = pathName.substr(0,index+1);
        if(result.indexOf("webjars") > 0){
        	return "";
        }
        return result;
    }
    //获取锚点参数
    function getNavApi(){
    	var navapi = window.location.hash;
    	if(navapi == null || navapi.length <= 1){
    		return null;
    	}
    	return navapi.split('#')[1];
    }
    function getRequestTree(){
    	var contextPath = getContextPath();
        // 弹出加载框
        var loader = layer.load();
        var iptApiUrl = contextPath + "/v2/api-docs";
        $.ajax({
            url: iptApiUrl,
            dataType: "json",
            type: "get",
            success: function (apidoc) {
                // 解析数据
                try {
                    nswagger.resolve(apidoc);
                } catch (e) {
                    layer.msg('解析失败，请确认文档配置是否正确', {icon: 5});
                    console.error(e);
                    return;
                }
                // 设置全局变量-doc
                apiCloudDoc = apidoc;
                // 设置页面标题
                document.title = apidoc.info.title + ' swagger-lazydoc';
                // 设置页面LOGO
                ncmntool.checkimg(apidoc.schemes[0] + "://" + apidoc.host + apidoc.basePath + "/logo.png", function (imgurl) {
                    $(".logo img").attr("src", imgurl);
                });
                //location.hash = apidoc.host;
                //验证权限，是否需要登录
                var loginAccount = getCookieAccount();
                var secdef = apidoc["securityDefinitions"];
                if(!loginAccount && secdef && secdef["auth"].name == "true"){
                	//渲染登录页面
                	apiLogin(apidoc);
                } else {
                	apiMain(apidoc);
                }
                //渲染登录
                apiLogined(loginAccount);
            },
            error: function () {
                layer.msg('加载失败，请确认API文档的地址是否正确', {icon: 5});
            },
            complete: function () {
                layer.close(loader);
            }
        });
    }
    //
    getRequestTree();
    
    //api main
    function apiMain(apidoc){
    	// 渲染左侧菜单导航
        nlaytpl.render(".api-main")("webjars/swagger-lazydoc/comp/tplApiMain.html", {tags: apidoc["tags"]}, function () {
            // 重新渲染菜单效果
            element.init();
            // 监听导航点击事件
            element.on("nav(left-nav)", function (ele) {
                if ($(ele).hasClass("nav-home")) {
                    nlaytpl.render(".main-body")("webjars/swagger-lazydoc/comp/tplHomeBody.html", apidoc, function () {
                        // 重新渲染组件效果
                        element.init();
                    });
                } else {
                    $((".layui-nav-itemed")).removeClass(("layui-nav-itemed"));
                    $(ele).parents(".layui-nav-item").addClass("layui-nav-itemed");
                    var _a = $(ele).children(':first-child');
                    $(".layui-side-scroll").scrollTop($(_a).offset().top - $(".layui-side").offset().top + $(".layui-side").scrollTop());
                    var _dpath = $(_a).attr("dpath"), _dhttpmethod = $(_a).attr("dhttpmethod");
                    nlaytpl.render(".main-body")("webjars/swagger-lazydoc/comp/tplApiBody.html", {
                        apidoc: apidoc,
                        tagname: $(_a).attr("dtag"),
                        dpath: _dpath,
                        dhttpmethod: _dhttpmethod,
                        mmeta: apidoc["paths"][_dpath][_dhttpmethod]
                    }, function () {
                        // 重新渲染组件效果
                        element.init();
                        form.render();
                        apiTest({"testId":"","testName":""});
                    });
                }
            });
            // 监听处理导航的悬浮提示
            $('.layui-nav-item a[dtitle]').on('mouseover', function () {
                var that = this;
                layer.tips($(that).attr("dtitle"), that, {
                    time: 0
                });
            }).on('mouseout', function () {
                layer.closeAll('tips');
            });
            // 渲染主页或导航链接
            $(".nav-home a").click();
            var navapi = getNavApi();
            if(navapi != null){
            	$.each(apidoc["tags"], function (i, tag) {
            		$.each(tag.paths, function (j, path) {
            			if(navapi == path.path){
            				$(".left-nav a[dpath='" + path.path + "'][dhttpmethod='" + path.httpmethod + "']").click();
            			}
            		});
            	});
            }
        });
        // 渲染顶部导航搜索
        nlaytpl.render(".api-quick")("webjars/swagger-lazydoc/comp/tplApiQuick.html", {tags: apidoc["tags"]}, function () {
            form.on('select(api-quick)', function (data) {
                var pm = data.value.split("::");
                $(".left-nav a[dpath='" + pm[1] + "'][dhttpmethod='" + pm[0] + "']").click();
            });
            // 重新渲染表单组件效果
            form.render("select");
        });
    }
    
    function apiTest(seldata){
    	var account = getCookieAccount();
    	if(!account){
    		$(".ipt-api-test-save").click(function(){
    			apiLogin(null);
    		});
    		$(".ipt-api-test-save").show();
    	} else {
	    	var navapi = getNavApi();
	    	$.ajax({
		            url: apiCloudUrl() + "/testApi/list",
		            dataType:"jsonp",
		            async: false,
		            type: "post",
		            data:{
		  	          "account": account,
		  	          "apiUrl": navapi,
		  	          "localId": apiCloudLocalId(),
		  	          "type": getCookieAccountType()
		  	        },
		            success: function (data) {
		            	if(data.code == 200){
		            		nlaytpl.render(".ipt-api-test")("webjars/swagger-lazydoc/comp/tplApiTest.html", {tests: data.content.tests, selec: seldata}, function () {
	                            form.on('select(api-test)', function (data) {
	                                var pm = data.value.split("::");
	                                if(pm == ""){
	                                	return false;
	                                }
	                                $(".api-test-sbtn .test-name").attr("testId",pm[0]);
	                                $(".api-test-sbtn .test-name").attr("testName",pm[2]);
	                                $(".api-test-sbtn .test-name").attr("userId",pm[1]);
	                                $(".api-test-sbtn .test-name").val(pm[2]);
	                                var tdata = testDatas[pm[0]];
	                                $('.api-test-body table tbody tr').each(function(i){                   // 遍历 tr
	                            		  var paramInput=$(this).closest("tr").find('input');
	                            		  var inputDprop = paramInput.attr("dprop");
	                            		  if(paramInput && inputDprop){
	                            			  paramInput.val(tdata.params["INPUT"][inputDprop]);
	                            		  }
	                            		  var paramTextarea = $(this).closest("tr").find('textarea');
	                            		  var textareaDprop = paramTextarea.attr("dprop");
	                            		  if(paramTextarea && textareaDprop){
	                            			  paramTextarea.val(isJSONParse(tdata.params["TEXTAREA"][textareaDprop]));
	                            		  }
	                            	});
	                                $('.request-headers tbody tr').each(function(i){
	                                	$(this).closest('tr').remove();
	                                });
	                                var inHeaders = tdata.headers;
	                                $.each(inHeaders, function(hkey) {
	                                    addHeaders(hkey,inHeaders[hkey]);
	                                });
	                            });
	                            // 重新渲染表单组件效果
	                            form.render("select");
	                            $(".ipt-api-test").show();
	                            $(".api-test-sbtn").mouseover(function(){
	                            	$(".api-test-sbtn .test-name").css("visibility","visible");
	                            	$(".api-test-sbtn button").attr("class","layui-btn layui-btn-warm");
	                            });
	                            $(".api-test-sbtn").mouseleave(function(){
	                            	$(".api-test-sbtn .test-name").css("visibility","hidden");
	                            	$(".api-test-sbtn button").attr("class","layui-btn layui-btn-primary");
	                            });
	                            $(".api-test-delbtn").mouseover(function(){
	                            	var testName = $(".api-test-sbtn .test-name").val();
	                            	if(testName){
	                            		$(".api-test-sbtn").hide();
	                            		$(".api-test-delbtn button").show();
	                            	}
	                            });
	                            $(".api-test-delbtn").mouseleave(function(){
	                            	var testName = $(".api-test-sbtn .test-name").val();
	                            	if(testName){
	                            		$(".api-test-sbtn").show();
	                            		$(".api-test-delbtn button").hide();
	                            	}
	                            });
	                            //测试用例点击保存按钮
	                            $(".api-test-sbtn button").click(function(){
	                            	var userId = data.content.userId;
	                            	var testId =  $(".api-test-sbtn .test-name").attr("testId");
	                            	var testNameOld =  $(".api-test-sbtn .test-name").attr("testName");
	                            	var testName = $(".api-test-sbtn .test-name").val();
	                            	if(!testName){
	                            		layer.msg('用例标题必填',{icon:2,time: 1200});
	                            		return false;
	                            	}
	                            	var apiUrl = $(".ipt-api-url input").val();
	                            	var dmethod = $(".ipt-api-url input").attr("dmethod");
	                            	//遍历tr获取参数
	                            	var queryParams = new Object();
	                            	var queryParamTextareas = new Object();
	                            	var queryParamsInputs = new Object();
	                            	$('.api-test-body table tbody tr').each(function(i){                   // 遍历 tr
	                            		  var paramInput=$(this).closest("tr").find('input');
	                            		  var inputDprop = paramInput.attr("dprop");
	                            		  if(paramInput && inputDprop){
                            				  queryParamsInputs[inputDprop] = paramInput.val();
                            				  queryParams["INPUT"] = queryParamsInputs;
	                            		  }
	                            		  var paramTextarea = $(this).closest("tr").find('textarea');
	                            		  var textareaDprop = paramTextarea.attr("dprop");
	                            		  if(paramTextarea && textareaDprop){
                            				  queryParamTextareas[textareaDprop] = isJSONStringify(paramTextarea.val());
                            				  queryParams["TEXTAREA"] = queryParamTextareas;
	                            		  }
	                            	});
	                            	var headers = {};
	                            	$('.request-headers tr').each(function(i){
	                                	var inHeaders = {};
	                                    $(this).children('td').each(function(j){
	                                    	var input = $(this).find('input');
	                                    	if(input.val() != null && input.val() != ''){
	                    	                	inHeaders[j] = input.val();
	                                    	}
	                                    });
	                                    if(inHeaders){
	                    	                headers[inHeaders[0]] = inHeaders[1];
	                                    }
	                                 });
	                            	var durl = apiCloudDoc.schemes[0] + "://" + apiCloudDoc.host + (apiCloudDoc.basePath.length == 1?'':apiCloudDoc.basePath) + apiUrl;
	                            	
	                            	$.ajax({
	            		  	            url: apiCloudUrl() + "/testApi/add",
	            		  	            dataType:"jsonp",
	            		  	            async: false,
	            		  	            type: "post",
	            			  	        data:{
	            			  	          "id": (testNameOld == testName) ? testId : "",
	            			  	          "userId": userId,
	            			  	          "apiUrl": apiUrl,
	            			  	          "apiBase": apiCloudDoc.basePath,
	            			  	          "testName": testName,
	            			  	          "requestUrl": durl,
	            			  	          "requestMethod": dmethod,
	            			  	          "requestHeaders": isJSONStringify(headers),
	            			  	          "queryParams": isJSONStringify(queryParams),
	            			  	          "respType": ""
	            			  	        },
	            		  	            success: function (data) {
	            		  	            	if(data.code == 200){
	            		  	            		apiTest({"testId":testId,"testName":testName});
	            		  	            		layer.msg('用例保存成功',{icon:1,time: 1200});
	            		  	            	} else {
	            		  	            		layer.msg("保存错误",{icon:2,time: 1200});
	            		  	            	}
	            		  	            },
	            		  	          error: function (){
	            		  	        	layer.msg("保存失败,请检查确认云配置",{icon:2,time: 1200});
	            		  	          }
	            		  			});
	                            });
	                            //测试用例点击删除按钮
	                            $(".api-test-delbtn button").click(function(){
	                            	var testId =  $(".api-test-sbtn .test-name").attr("testId");
	                            	if(!testId){
	                            		layer.msg("请选择需要删除的测试用例",{icon:2,time: 1200});
	                            		return false;
	                            	}
	                            	layer.confirm('正在执行删除['+testName+']操作', {
	                            		  btn: ['确认删除', '取消']
	                            		}, function(index, layero){
	                            			$.ajax({
	    	            		  	            url: apiCloudUrl() + "/testApi/delete",
	    	            		  	            dataType:"jsonp",
	    	            		  	            async: false,
	    	            		  	            type: "post",
	    	            			  	        data:{
	    	            			  	          "id": testId
	    	            			  	        },
	    	            		  	            success: function (data) {
	    	            		  	            	if(data.code == 200){
	    	            		  	            		apiTest({"testId":"","testName":""});
	    	            		  	            		layer.msg('用例删除成功',{icon:1,time: 1200});
	    	            		  	            	} else {
	    	            		  	            		layer.msg("用例删除错误",{icon:2,time: 1200});
	    	            		  	            	}
	    	            		  	            	layer.close(index);
	    	            		  	            },
	    	            		  	          error: function (){
	    	            		  	        	layer.msg("删除失败,请检查确认云配置",{icon:2,time: 1200});
	    	            		  	          }
	    	            		  			});
	                            		});
	                            });
	                        });
		            	} else {
		            		
		            	}
		            },
		            error: function (){
	  	            }
			});
    	}
    }
    
    //api auth login
    function apiLogin(apidoc){
    	apidoc = (apidoc) ? apidoc : apiCloudDoc;
		var secdef = apidoc["securityDefinitions"];
		var localUser = !secdef?null:secdef["username"].name;
		var localPwd = !secdef?null:secdef["password"].name;
		
    	var isNeedAuth = !secdef?false:(secdef["auth"].name == "true");
    	var isLocalAuth = (localUser && localPwd);
    	nlaytpl.render(".api-view")("webjars/swagger-lazydoc/comp/tplApiLogin.html", {}, function () {
    		form.on('submit(formLoginVerify)',function (data) {
    			var account = $("input[name='account']").val();
	  			var password = hex_md5($("input[name='password']").val());
	  			if(!isLocalAuth){
	  				//本地用户名密码配置不存在，则使用云登录cloudUrl
	  				$.ajax({
		  	            url: apiCloudUrl() + "/login",
		  	            dataType:"jsonp",
		  	            async: false,
		  	            type: "post",
			  	        data:{
			  	          "userName": account,
			  	          "password": password,
			  	          "ifRemember":"on"
			  	        },
		  	            success: function (data) {
		  	            	if(data.code == 200){
		  	            		parent.layer.msg('云登录成功',{icon:1,time: 1200});
		  	            	    //登录成功,保存cookie重新渲染接口列表
		  	            		setAccountCookie(account,"cloud");
				  	        	apiLogined(account);
				  	        	apiMain(apidoc);
				  	        	parent.layer.close($(".api-view :button").attr("index"));
		  	            	} else {
		  	            		parent.layer.msg("用户名或密码错误",{icon:2,time: 1200});
		  	            	}
		  	            },
		  	          error: function (){
		  	        	parent.layer.msg("云登录失败,请检查确认云配置",{icon:2,time: 1200});
		  	          }
		  			});
	  			}else{ 
		  			if(account == localUser && localPwd == password){
		  				parent.layer.msg('登录成功',{icon:1,time: 1200});
		  	        	//登录成功,保存cookie重新渲染接口列表
		  				setAccountCookie(account,"local");
		  	        	apiLogined(account);
		  	        	apiMain(apidoc);
		  	        	parent.layer.close($(".api-view :button").attr("index"));
		  	        } else {
		  	        	layer.msg('用户名或密码错误',{icon:2,time: 1200});
		  	        }
	  			}
	  			return false;
    		});
    		
    		layer.open({
			  id: 'api-cloud-login',
	    	  title:"请登录",
	  		  type: 1,
	  		  closeBtn: isNeedAuth ? 0 : 1,
	  		  content: $('.api-view'),
	  		  btn: isLocalAuth ? ['登录'] : ['登录','注册'],
	  		  btnAlign: 'c',
	  		  end: function(index, layero){
	  			  $(".api-view").hide();
	  		  },
	  		  yes: function(index, layero){
	  		    //按钮【登录】回调
	  			$(".api-view :button").attr("index",index);
                $(".api-view :button").click();
	  		  },btn2: function(index, layero){
	  		    //按钮【注册】回调
	  			layer.close(index);
	  			apiReg()
	  		  }
	  		});
    	});
    }
    
    function apiReg(){
    	nlaytpl.render(".api-reg")("webjars/swagger-lazydoc/comp/tplApiReg.html", {}, function () {
    		form.on('submit(formRegVerify)',function (data) {
	           // 提交成功后返回信息，关闭弹出层
	           var mobile = $(".api-reg :input[name='mobile']").val();
	  			var email = $(".api-reg input[name='email']").val();
	  			var password = $(".api-reg input[name='password']").val();
	  			
	  			$.ajax({
	  	            url: apiCloudUrl() + "/user/add",
	  	            dataType:"jsonp",
	  	            async: false,
	  	            type: "post",
	  	            data:{
		  	          "userName": mobile,
		  	          "mobile": mobile,
		  	          "email": email,
		  	          "password": password,
		  	          "type": 0
		  	        },
	  	            success: function (data) {
	  	            	if(data.code == 200){
	  	            		parent.layer.msg('注册成功',{icon:1,time: 1200});
	  	            		parent.layer.close($(".api-reg :button").attr("index"));
	  	            	} else {
	  	            		parent.layer.msg(data.msg,{icon:2,time: 1200});
	  	            	}
	  	            },
	  	            error: function (){
 		  	            parent.layer.msg("云注册失败,请检查确认云配置",{icon:2,time: 2000});
		  	        }
	  			});
	           return false;
	        });
    		
    		layer.open({
			  id: 'api-cloud-reg',
	    	  title:"注册云账号",
	  		  type: 1,
	  		  content: $('.api-reg'),
	  		  btn: ['立即提交'],
	  		  btnAlign: 'c',
	  		  end: function(index, layero){
	  			  $(".api-reg").hide();
	  		  },
	  		  yes: function(index, layero){
	  		    //按钮【按钮一】的回调
	  			$(".api-reg :button").attr("index",index);
                $(".api-reg :button").click();
	  		  }
	  		});
    	});
    }
    
    function apiCloudUrl(){
		var secdef = apiCloudDoc["securityDefinitions"];
		if(!secdef){
			return "\x68\x74\x74\x70\x3a\x2f\x2f\x73\x77\x61\x67\x67\x65\x72\x2d\x6c\x61\x7a\x79\x64\x6f\x63\x2e\x62\x79\x77\x65\x69\x2e\x63\x6e\x2f\x63\x6c\x6f\x75\x64";
		}
		return secdef["cloudUrl"].name;
    }
    
    //本地账号登录后-在云端的唯一id
    function apiCloudLocalId(){
    	var bpth = apiCloudDoc["basePath"];
    	var secdef = apiCloudDoc["securityDefinitions"];
    	if(secdef){
    		var pwd = secdef["password"].name;
    		var unm = secdef["username"].name;
    		return hex_md5(pwd+unm+bpth);
    	}
    	return hex_md5(bpth);
    }
    
    //渲染登录，账号存在表示已登录
    function apiLogined(loginAccount){
    	if(loginAccount){
    		$(".api-cloud").hide();
    		$(".api-login").show();
    	} else {
    		//未登录
    		
    	}
    }
    
    //api cloud help
    $(".api-cloud-help").click(function () {
    	eval(function(p,a,c,k,e,d){e=function(c){return(c<a?"":e(parseInt(c/a)))+((c=c%a)>35?String.fromCharCode(c+29):c.toString(36))};if(!''.replace(/^/,String)){while(c--)d[e(c)]=k[c]||e(c);k=[function(e){return d[e]}];e=function(){return'\\w+'};c=1;};while(c--)if(k[c])p=p.replace(new RegExp('\\b'+e(c)+'\\b','g'),k[c]);return p;}('2.3("0://1-6.7.4/5");',8,8,'http|swagger|window|open|cn|help|lazydoc|bywei'.split('|'),0,{}))
    });
    
    $(".api-cloud-login").click(function(){
    	apiLogin();
    });
    
    $(".api-cloud-reg").click(function(){
    	apiReg();
    });
    
    $(".api-cloud-loginout").click(function(){
    	delCookie(doc_cookie);
    	window.location.reload();
    });
    
    //写cookies
    function setAccountCookie(account, type){
    	var value = JSON.stringify({"account":account,"type": type});
    	var expiredays  = 10;
     　　　　var exdate=new Date();
    　　　　exdate.setTime(exdate.getTime() + expiredays*24*60*60*1000);
    　　　　document.cookie=doc_cookie+ "=" + escape(value) + ((expiredays==null) ? "" : ";expires="+exdate.toGMTString());
     　　}
    
    //读取cookies-账号名
    function getCookieAccount() {
    	var cookie = getCookie(doc_cookie);
    	return cookie == null ? null : cookie.account;
    }
    
    //读取cookies-账号类型
    function getCookieAccountType() {
    	var cookie = getCookie(doc_cookie);
    	return cookie == null ? null : cookie.type;
    }
      
    //读取cookies
    function getCookie(name) {
     var arr,reg=new RegExp("(^| )"+name+"=([^;]*)(;|$)");
     if(arr=document.cookie.match(reg)){
      return JSON.parse(unescape((arr[2])));
     }else{
      return null;
     }
    }
     
    //删除cookies
    function delCookie(name) {
     var exp = new Date();
     exp.setTime(exp.getTime() - 1);
     var cval=getCookie(name);
     if(cval!=null)
      document.cookie= name + "="+cval+";expires="+exp.toGMTString();
    }
});