/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.mapping;

import com.alibaba.druid.mapping.Entity;
import com.alibaba.druid.mapping.MappingContext;
import com.alibaba.druid.mapping.Property;
import com.alibaba.druid.mapping.spi.MappingProvider;
import com.alibaba.druid.mapping.spi.MappingVisitor;
import com.alibaba.druid.mapping.spi.MySqlMappingProvider;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.visitor.ExportParameterVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import com.alibaba.druid.util.JdbcUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public class MappingEngine {
    private LinkedHashMap<String, Entity> entities = new LinkedHashMap();
    private Integer maxLimit;
    private final MappingProvider provider;
    private DataSource dataSource;

    public MappingEngine() {
        this(new MySqlMappingProvider());
    }

    public MappingEngine(MappingProvider provider) {
        this.provider = provider;
    }

    public Entity getFirstEntity(MappingContext context) {
        Entity entity = context.getDefaultEntity();
        if (entity != null) {
            return entity;
        }
        Iterator<Map.Entry<String, Entity>> i$ = this.entities.entrySet().iterator();
        if (i$.hasNext()) {
            Map.Entry<String, Entity> entry = i$.next();
            return entry.getValue();
        }
        return null;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public MappingProvider getMappingProvider() {
        return this.provider;
    }

    public Integer getMaxLimit() {
        return this.maxLimit;
    }

    public void setMaxLimit(Integer maxLimit) {
        this.maxLimit = maxLimit;
    }

    public LinkedHashMap<String, Entity> getEntities() {
        return this.entities;
    }

    public void addEntity(Entity entity) {
        this.entities.put(entity.getName(), entity);
    }

    public MappingVisitor createMappingVisitor() {
        return this.provider.createMappingVisitor(this);
    }

    public MappingVisitor createMappingVisitor(List<Object> parameters) {
        return this.createMappingVisitor(new MappingContext(parameters));
    }

    public MappingVisitor createMappingVisitor(MappingContext context) {
        return this.provider.createMappingVisitor(this, context);
    }

    public SQLASTOutputVisitor createOutputVisitor(Appendable out) {
        return this.provider.createOutputVisitor(this, out);
    }

    public String explain(String sql) {
        return this.explain(sql);
    }

    public String explain(String sql, MappingContext context) {
        List<SQLStatement> stmtList = this.provider.explain(this, sql);
        if (stmtList.size() > 0) {
            throw new IllegalArgumentException(sql);
        }
        SQLStatement stmt = stmtList.get(0);
        MappingVisitor visitor = this.createMappingVisitor(context);
        stmt.accept(visitor);
        visitor.afterResolve();
        this.afterResole(visitor);
        return this.toSQL(stmt);
    }

    public SQLSelectQueryBlock explainToSelectSQLObject(String sql) {
        return this.explainToSelectSQLObject(sql, new MappingContext());
    }

    public SQLSelectQueryBlock explainToSelectSQLObject(String sql, MappingContext context) {
        return this.provider.explainToSelectSQLObject(this, sql, context);
    }

    public String explainToSelectSQL(String sql) {
        return this.explainToSelectSQL(sql, Collections.<Object>emptyList());
    }

    public String explainToSelectSQL(String sql, List<Object> parameters) {
        return this.explainToSelectSQL(sql, new MappingContext(parameters));
    }

    public String explainToSelectSQL(String sql, MappingContext context) {
        SQLSelectQueryBlock query = this.explainToSelectSQLObject(sql, context);
        MappingVisitor visitor = this.createMappingVisitor(context);
        query.accept(visitor);
        visitor.afterResolve();
        this.afterResole(visitor);
        return this.toSQL(query);
    }

    public void afterResole(MappingVisitor visitor) {
    }

    public SQLDeleteStatement explainToDeleteSQLObject(String sql, MappingContext context) {
        return this.provider.explainToDeleteSQLObject(this, sql, context);
    }

    public String explainToDeleteSQL(String sql) {
        return this.explainToDeleteSQL(sql, new MappingContext());
    }

    public String explainToDeleteSQL(String sql, MappingContext context) {
        SQLDeleteStatement stmt = this.explainToDeleteSQLObject(sql, context);
        MappingVisitor visitor = this.createMappingVisitor(context);
        stmt.accept(visitor);
        visitor.afterResolve();
        this.afterResole(visitor);
        return this.toSQL(stmt);
    }

    public String resolveTableName(Entity entity, MappingContext context) {
        return entity.getTableName();
    }

    public String resovleColumnName(Entity entity, Property property, MappingContext context) {
        return property.getDbColumnName();
    }

    public SQLUpdateStatement explainToUpdateSQLObject(String sql, MappingContext context) {
        return this.provider.explainToUpdateSQLObject(this, sql, context);
    }

    public String explainToUpdateSQL(String sql) {
        return this.explainToUpdateSQL(sql, new MappingContext());
    }

    public String explainToUpdateSQL(String sql, MappingContext context) {
        SQLUpdateStatement stmt = this.explainToUpdateSQLObject(sql, context);
        MappingVisitor visitor = this.createMappingVisitor(context);
        stmt.accept(visitor);
        visitor.afterResolve();
        this.afterResole(visitor);
        return this.toSQL(stmt);
    }

    public SQLInsertStatement explainToInsertSQLObject(String sql, MappingContext context) {
        return this.provider.explainToInsertSQLObject(this, sql, context);
    }

    public String explainToInsertSQL(String sql) {
        return this.explainToInsertSQL(sql, new MappingContext());
    }

    public String explainToInsertSQL(String sql, MappingContext context) {
        SQLInsertStatement stmt = this.explainToInsertSQLObject(sql, context);
        MappingVisitor visitor = this.createMappingVisitor(context);
        stmt.accept(visitor);
        visitor.afterResolve();
        this.afterResole(visitor);
        return this.toSQL(stmt);
    }

    public List<Object> exportParameters(SQLObject sqlObject) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        this.exportParameters(sqlObject, parameters);
        return parameters;
    }

    public void exportParameters(SQLObject sqlObject, List<Object> parameters) {
        ExportParameterVisitor exporter = this.provider.createExportParameterVisitor(parameters);
        sqlObject.accept(exporter);
    }

    public String toSQL(SQLObject sqlObject) {
        return this.toSQL(sqlObject, false);
    }

    public String toSQL(SQLObject sqlObject, boolean exportParameter) {
        if (exportParameter) {
            this.exportParameters(sqlObject);
        }
        StringBuilder out = new StringBuilder();
        SQLASTOutputVisitor outputVisitor = this.createOutputVisitor(out);
        sqlObject.accept(outputVisitor);
        return out.toString();
    }

    public List<Map<String, Object>> select(Connection conn, String sql, List<Object> parameters) throws SQLException {
        return this.select(conn, sql, new MappingContext(parameters));
    }

    public List<Map<String, Object>> select(Connection conn, String sql, MappingContext context) throws SQLException {
        SQLSelectQueryBlock sqlObject = this.explainToSelectSQLObject(sql, context);
        this.exportParameters(sqlObject, context.getParameters());
        String rawSql = this.toSQL(sqlObject);
        return JdbcUtils.executeQuery(conn, rawSql, context.getParameters());
    }

    public int delete(Connection conn, String sql, List<Object> parameters) throws SQLException {
        return this.delete(conn, sql, new MappingContext(parameters));
    }

    public int delete(Connection conn, String sql, MappingContext context) throws SQLException {
        SQLDeleteStatement sqlObject = this.explainToDeleteSQLObject(sql, context);
        this.exportParameters(sqlObject, context.getParameters());
        String rawSql = this.toSQL(sqlObject);
        int updateCount = JdbcUtils.executeUpdate(conn, rawSql, context.getParameters());
        return updateCount;
    }

    public int update(Connection conn, String sql, List<Object> parameters) throws SQLException {
        return this.update(conn, sql, new MappingContext(parameters));
    }

    public int update(Connection conn, String sql, MappingContext context) throws SQLException {
        SQLUpdateStatement sqlObject = this.explainToUpdateSQLObject(sql, context);
        this.exportParameters(sqlObject, context.getParameters());
        String rawSql = this.toSQL(sqlObject);
        int updateCount = JdbcUtils.executeUpdate(conn, rawSql, context.getParameters());
        return updateCount;
    }

    public void insert(Connection conn, String sql, Object ... parameters) throws SQLException {
        this.insert(conn, sql, Arrays.asList(parameters));
    }

    public void insert(Connection conn, String sql, List<Object> parameters) throws SQLException {
        this.insert(conn, sql, new MappingContext(parameters));
    }

    public void insert(Connection conn, String sql, MappingContext context) throws SQLException {
        SQLInsertStatement sqlObject = this.explainToInsertSQLObject(sql, context);
        this.exportParameters(sqlObject, context.getParameters());
        String rawSql = this.toSQL(sqlObject);
        JdbcUtils.execute(conn, rawSql, context.getParameters());
    }

    public Connection getConnection() throws SQLException {
        if (this.dataSource == null) {
            throw new SQLException("datasource not init.");
        }
        return this.dataSource.getConnection();
    }

    public List<Map<String, Object>> select(String sql, Object ... parameters) throws SQLException {
        return this.select(sql, Arrays.asList(parameters));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> select(String sql, List<Object> parameters) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            List<Map<String, Object>> list = this.select(conn, sql, parameters);
            return list;
        }
        finally {
            JdbcUtils.close(conn);
        }
    }

    public int delete(String sql, Object ... parameters) throws SQLException {
        return this.delete(sql, Arrays.asList(parameters));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete(String sql, List<Object> parameters) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            int n = this.delete(conn, sql, parameters);
            return n;
        }
        finally {
            JdbcUtils.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(String sql, List<Object> parameters) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            int n = this.update(conn, sql, parameters);
            return n;
        }
        finally {
            JdbcUtils.close(conn);
        }
    }

    public void insertToTable(String tableName, Map<String, Object> map) throws SQLException {
        StringBuilder sql = new StringBuilder().append("insert into ").append(tableName).append("(");
        int nameCount = 0;
        for (String name : map.keySet()) {
            if (nameCount > 0) {
                sql.append(",");
            }
            sql.append(name);
            ++nameCount;
        }
        sql.append(") values (");
        for (int i = 0; i < nameCount; ++i) {
            if (i != 0) {
                sql.append(",");
            }
            sql.append("?");
        }
        sql.append(")");
        ArrayList<Object> parameters = new ArrayList<Object>(map.values());
        this.insert(sql.toString(), parameters);
    }

    public void insert(String sql, Object ... parameters) throws SQLException {
        this.insert(sql, Arrays.asList(parameters));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(String sql, List<Object> parameters) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            this.insert(conn, sql, parameters);
        }
        finally {
            JdbcUtils.close(conn);
        }
    }
}

