/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.http;

import com.alibaba.druid.filter.stat.StatFilterContext;
import com.alibaba.druid.filter.stat.StatFilterContextListenerAdapter;
import com.alibaba.druid.support.http.stat.WebAppStat;
import com.alibaba.druid.support.http.stat.WebAppStatManager;
import com.alibaba.druid.support.http.stat.WebRequestStat;
import com.alibaba.druid.support.http.stat.WebSessionStat;
import com.alibaba.druid.support.http.stat.WebURIStat;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.alibaba.druid.util.DruidWebUtils;
import com.alibaba.druid.util.PatternMatcher;
import com.alibaba.druid.util.ServletPathMatcher;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;

public class WebStatFilter
implements Filter {
    private static final Log LOG = LogFactory.getLog(WebStatFilter.class);
    public static final String PARAM_NAME_SESSION_STAT_ENABLE = "sessionStatEnable";
    public static final String PARAM_NAME_SESSION_STAT_MAX_COUNT = "sessionStatMaxCount";
    public static final String PARAM_NAME_EXCLUSIONS = "exclusions";
    public static final String PARAM_NAME_PRINCIPAL_SESSION_NAME = "principalSessionName";
    public static final String PARAM_NAME_PRINCIPAL_COOKIE_NAME = "principalCookieName";
    public static final int DEFAULT_MAX_STAT_SESSION_COUNT = 100000;
    private WebAppStat webAppStat = null;
    private WebStatFilterContextListener statFilterContextListener = new WebStatFilterContextListener();
    protected PatternMatcher pathMatcher = new ServletPathMatcher();
    private Set<String> excludesPattern;
    private boolean sessionStatEnable = true;
    private int sessionStatMaxCount = 100000;
    private boolean createSession = false;
    private String contextPath;
    private String principalSessionName;
    private String principalCookieName;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        int index;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        StatHttpServletResponseWrapper responseWrapper = new StatHttpServletResponseWrapper(httpResponse);
        String requestURI = this.getRequestURI(httpRequest);
        if (this.isExclusion(requestURI)) {
            chain.doFilter(request, response);
            return;
        }
        long startNano = System.nanoTime();
        long startMillis = System.currentTimeMillis();
        WebRequestStat requestStat = new WebRequestStat(startNano, startMillis);
        WebRequestStat.set(requestStat);
        WebSessionStat sessionStat = this.getSessionStat(httpRequest);
        this.webAppStat.beforeInvoke();
        WebURIStat uriStat = this.webAppStat.getURIStat(requestURI, false);
        if (uriStat == null && (index = requestURI.indexOf(";jsessionid=")) != -1) {
            requestURI = requestURI.substring(0, index);
            uriStat = this.webAppStat.getURIStat(requestURI, false);
        }
        if (uriStat != null) {
            uriStat.beforeInvoke();
        }
        if (sessionStat != null) {
            sessionStat.beforeInvoke();
        }
        Throwable error = null;
        try {
            chain.doFilter(request, (ServletResponse)responseWrapper);
        }
        catch (IOException e) {
            error = e;
            throw e;
        }
        catch (ServletException e) {
            error = e;
            throw e;
        }
        catch (RuntimeException e) {
            error = e;
            throw e;
        }
        catch (Error e) {
            error = e;
            throw e;
        }
        finally {
            long endNano = System.nanoTime();
            requestStat.setEndNano(endNano);
            long nanos = endNano - startNano;
            this.webAppStat.afterInvoke(error, nanos);
            if (sessionStat == null && (sessionStat = this.getSessionStat(httpRequest)) != null) {
                sessionStat.beforeInvoke();
            }
            if (sessionStat != null) {
                sessionStat.afterInvoke(error, nanos);
                sessionStat.setPrincipal(this.getPrincipal(httpRequest));
            }
            if (uriStat == null) {
                int status = responseWrapper.getStatus();
                if (status == 404) {
                    String errorUrl = this.contextPath + "error_" + status;
                    uriStat = this.webAppStat.getURIStat(errorUrl, true);
                } else {
                    uriStat = this.webAppStat.getURIStat(requestURI, true);
                }
                if (uriStat != null) {
                    uriStat.beforeInvoke();
                }
            }
            if (uriStat != null) {
                uriStat.afterInvoke(error, nanos);
            }
            WebRequestStat.set(null);
        }
    }

    public WebSessionStat getSessionStat(HttpServletRequest request) {
        if (!this.isSessionStatEnable()) {
            return null;
        }
        WebSessionStat sessionStat = null;
        String sessionId = this.getSessionId(request);
        if (sessionId != null) {
            sessionStat = this.webAppStat.getSessionStat(sessionId, true);
        }
        if (sessionStat != null) {
            long currentMillis = System.currentTimeMillis();
            String userAgent = request.getHeader("user-agent");
            if (sessionStat.getCreateTimeMillis() == -1L) {
                HttpSession session = request.getSession(false);
                if (session != null) {
                    sessionStat.setCreateTimeMillis(session.getCreationTime());
                } else {
                    sessionStat.setCreateTimeMillis(currentMillis);
                }
                this.webAppStat.computeUserAgent(userAgent);
                this.webAppStat.incrementSessionCount();
            }
            sessionStat.setUserAgent(userAgent);
            String ip = DruidWebUtils.getRemoteAddr(request);
            int addressCount = sessionStat.getRemoteAddresses().size();
            if (addressCount < 10) {
                sessionStat.addRemoteAddress(ip);
            } else if (!sessionStat.getRemoteAddress().contains(ip)) {
                LOG.error("sessoin ip change too many");
            }
        }
        return sessionStat;
    }

    public String getSessionId(HttpServletRequest httpRequest) {
        String sessionId = null;
        HttpSession session = httpRequest.getSession(this.createSession);
        if (session != null) {
            sessionId = session.getId();
        }
        return sessionId;
    }

    public String getPrincipal(HttpServletRequest httpRequest) {
        if (this.principalSessionName != null) {
            HttpSession session = httpRequest.getSession(this.createSession);
            if (session == null) {
                return null;
            }
            Object sessionValue = session.getAttribute(this.principalSessionName);
            if (sessionValue == null) {
                return null;
            }
            return sessionValue.toString();
        }
        if (this.principalCookieName != null) {
            for (Cookie cookie : httpRequest.getCookies()) {
                if (!this.principalCookieName.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    public boolean isExclusion(String requestURI) {
        if (this.excludesPattern == null) {
            return false;
        }
        if (this.contextPath != null && requestURI.startsWith(this.contextPath) && !(requestURI = requestURI.substring(this.contextPath.length())).startsWith("/")) {
            requestURI = "/" + requestURI;
        }
        for (String pattern : this.excludesPattern) {
            if (!this.pathMatcher.matches(pattern, requestURI)) continue;
            return true;
        }
        return false;
    }

    public String getRequestURI(HttpServletRequest request) {
        return request.getRequestURI();
    }

    public String getPrincipalSessionName() {
        return this.principalSessionName;
    }

    public String getPrincipalCookieName() {
        return this.principalCookieName;
    }

    public void init(FilterConfig config) throws ServletException {
        String param;
        String exclusions = config.getInitParameter(PARAM_NAME_EXCLUSIONS);
        if (exclusions != null && exclusions.trim().length() != 0) {
            this.excludesPattern = new HashSet<String>(Arrays.asList(exclusions.split("\\s*,\\s*")));
        }
        if ((param = config.getInitParameter(PARAM_NAME_PRINCIPAL_SESSION_NAME)) != null && (param = param.trim()).length() != 0) {
            this.principalSessionName = param;
        }
        if ((param = config.getInitParameter(PARAM_NAME_PRINCIPAL_COOKIE_NAME)) != null && (param = param.trim()).length() != 0) {
            this.principalCookieName = param;
        }
        if ((param = config.getInitParameter(PARAM_NAME_SESSION_STAT_ENABLE)) != null && param.trim().length() != 0) {
            if ("true".equals(param = param.trim())) {
                this.sessionStatEnable = true;
            } else if ("false".equals(param)) {
                this.sessionStatEnable = false;
            } else {
                LOG.error("WebStatFilter Parameter 'sessionStatEnable' config error");
            }
        }
        if ((param = config.getInitParameter(PARAM_NAME_SESSION_STAT_MAX_COUNT)) != null && param.trim().length() != 0) {
            param = param.trim();
            try {
                this.sessionStatMaxCount = Integer.parseInt(param);
            }
            catch (NumberFormatException e) {
                LOG.error("WebStatFilter Parameter 'sessionStatEnable' config error", e);
            }
        }
        StatFilterContext.getInstance().addContextListener(this.statFilterContextListener);
        this.contextPath = DruidWebUtils.getContextPath(config.getServletContext());
        this.webAppStat = new WebAppStat(this.contextPath, this.sessionStatMaxCount);
        WebAppStatManager.getInstance().addWebAppStatSet(this.webAppStat);
    }

    public void destroy() {
        StatFilterContext.getInstance().removeContextListener(this.statFilterContextListener);
        if (this.webAppStat != null) {
            WebAppStatManager.getInstance().remove(this.webAppStat);
        }
    }

    public boolean isSessionStatEnable() {
        return this.sessionStatEnable;
    }

    public void setSessionStatEnable(boolean sessionStatEnable) {
        this.sessionStatEnable = sessionStatEnable;
    }

    public WebAppStat getWebAppStat() {
        return this.webAppStat;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public int getSessionStatMaxCount() {
        return this.sessionStatMaxCount;
    }

    public WebStatFilterContextListener getStatFilterContextListener() {
        return this.statFilterContextListener;
    }

    public static final class StatHttpServletResponseWrapper
    extends HttpServletResponseWrapper
    implements HttpServletResponse {
        private int status;

        public StatHttpServletResponseWrapper(HttpServletResponse response) {
            super(response);
        }

        public void setStatus(int statusCode) {
            super.setStatus(statusCode);
            this.status = statusCode;
        }

        public void setStatus(int statusCode, String statusMessage) {
            super.setStatus(statusCode, statusMessage);
            this.status = statusCode;
        }

        public void sendError(int statusCode, String statusMessage) throws IOException {
            super.sendError(statusCode, statusMessage);
            this.status = statusCode;
        }

        public void sendError(int statusCode) throws IOException {
            super.sendError(statusCode);
            this.status = statusCode;
        }

        public int getStatus() {
            return this.status;
        }
    }

    class WebStatFilterContextListener
    extends StatFilterContextListenerAdapter {
        WebStatFilterContextListener() {
        }

        @Override
        public void addUpdateCount(int updateCount) {
            WebRequestStat reqStat = WebRequestStat.current();
            if (reqStat != null) {
                reqStat.addJdbcUpdateCount(updateCount);
            }
        }

        @Override
        public void addFetchRowCount(int fetchRowCount) {
            WebRequestStat reqStat = WebRequestStat.current();
            if (reqStat != null) {
                reqStat.addJdbcFetchRowCount(fetchRowCount);
            }
        }

        @Override
        public void executeBefore(String sql, boolean inTransaction) {
            WebRequestStat reqStat = WebRequestStat.current();
            if (reqStat != null) {
                reqStat.incrementJdbcExecuteCount();
            }
        }

        @Override
        public void executeAfter(String sql, long nanos, Throwable error) {
            WebRequestStat reqStat = WebRequestStat.current();
            if (reqStat != null) {
                reqStat.addJdbcExecuteTimeNano(nanos);
                if (error != null) {
                    reqStat.incrementJdbcExecuteErrorCount();
                }
            }
        }

        @Override
        public void commit() {
            WebRequestStat reqStat = WebRequestStat.current();
            if (reqStat != null) {
                reqStat.incrementJdbcCommitCount();
            }
        }

        @Override
        public void rollback() {
            WebRequestStat reqStat = WebRequestStat.current();
            if (reqStat != null) {
                reqStat.incrementJdbcRollbackCount();
            }
        }

        @Override
        public void pool_connect() {
            WebRequestStat reqStat = WebRequestStat.current();
            if (reqStat != null) {
                reqStat.incrementJdbcPoolConnectCount();
            }
        }

        @Override
        public void pool_close(long nanos) {
            WebRequestStat reqStat = WebRequestStat.current();
            if (reqStat != null) {
                reqStat.incrementJdbcPoolCloseCount();
            }
        }

        @Override
        public void resultSet_open() {
            WebRequestStat reqStat = WebRequestStat.current();
            if (reqStat != null) {
                reqStat.incrementJdbcResultSetOpenCount();
            }
        }

        @Override
        public void resultSet_close(long nanos) {
            WebRequestStat reqStat = WebRequestStat.current();
            if (reqStat != null) {
                reqStat.incrementJdbcResultSetCloseCount();
            }
        }
    }
}

