/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.http.stat;

import com.alibaba.druid.support.http.stat.WebRequestStat;
import com.alibaba.druid.util.Histogram;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class WebSessionStat {
    private final String sessionId;
    private final AtomicInteger runningCount = new AtomicInteger();
    private final AtomicInteger concurrentMax = new AtomicInteger();
    private final AtomicLong requestCount = new AtomicLong(0L);
    private final AtomicLong requestErrorCount = new AtomicLong(0L);
    private final AtomicLong requestTimeNano = new AtomicLong();
    private final AtomicLong jdbcFetchRowCount = new AtomicLong();
    private final AtomicLong jdbcUpdateCount = new AtomicLong();
    private final AtomicLong jdbcExecuteCount = new AtomicLong();
    private final AtomicLong jdbcExecuteTimeNano = new AtomicLong();
    private final AtomicLong jdbcCommitCount = new AtomicLong();
    private final AtomicLong jdbcRollbackCount = new AtomicLong();
    private long createTimeMillis = -1L;
    private volatile long lastAccessTimeMillis = -1L;
    private Set<String> remoteAddresses = new HashSet<String>();
    private String principal = null;
    private String userAgent;
    private Histogram requestIntervalHistogram = Histogram.makeHistogram(8);

    public WebSessionStat(String sessionId) {
        this.sessionId = sessionId;
    }

    public void reset() {
        this.concurrentMax.set(0);
        this.requestCount.set(0L);
        this.requestErrorCount.set(0L);
        this.requestTimeNano.set(0L);
        this.jdbcFetchRowCount.set(0L);
        this.jdbcUpdateCount.set(0L);
        this.jdbcExecuteCount.set(0L);
        this.jdbcExecuteTimeNano.set(0L);
        this.jdbcCommitCount.set(0L);
        this.jdbcRollbackCount.set(0L);
        this.remoteAddresses.clear();
        this.principal = null;
        this.requestIntervalHistogram.reset();
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public long getCreateTimeMillis() {
        return this.createTimeMillis;
    }

    public Date getCreateTime() {
        if (this.createTimeMillis == -1L) {
            return null;
        }
        return new Date(this.createTimeMillis);
    }

    public String getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public void setCreateTimeMillis(long createTimeMillis) {
        this.createTimeMillis = createTimeMillis;
    }

    public long getLastAccessTimeMillis() {
        return this.lastAccessTimeMillis;
    }

    public Date getLastAccessTime() {
        if (this.lastAccessTimeMillis < 0L) {
            return null;
        }
        return new Date(this.lastAccessTimeMillis);
    }

    public Set<String> getRemoteAddresses() {
        return this.remoteAddresses;
    }

    public String getRemoteAddress() {
        if (this.remoteAddresses.size() == 0) {
            return null;
        }
        if (this.remoteAddresses.size() == 1) {
            return this.remoteAddresses.iterator().next();
        }
        StringBuilder buf = new StringBuilder();
        for (String item : this.remoteAddresses) {
            if (buf.length() != 0) {
                buf.append(";");
            }
            buf.append(item);
        }
        return buf.toString();
    }

    public void setLastAccessTimeMillis(long lastAccessTimeMillis) {
        if (this.lastAccessTimeMillis > 0L) {
            long interval = lastAccessTimeMillis - this.lastAccessTimeMillis;
            this.requestIntervalHistogram.record(interval);
        }
        this.lastAccessTimeMillis = lastAccessTimeMillis;
    }

    public void beforeInvoke() {
        int max;
        int running = this.runningCount.incrementAndGet();
        while (running > (max = this.concurrentMax.get()) && !this.concurrentMax.compareAndSet(max, running)) {
        }
        this.incrementRequestCount();
        WebRequestStat requestStat = WebRequestStat.current();
        if (requestStat != null) {
            this.setLastAccessTimeMillis(requestStat.getStartMillis());
        }
    }

    public void incrementRequestCount() {
        this.requestCount.incrementAndGet();
    }

    public void afterInvoke(Throwable error, long nanos) {
        this.runningCount.decrementAndGet();
        this.reacord(nanos);
    }

    public void reacord(long nanos) {
        this.requestTimeNano.addAndGet(nanos);
        WebRequestStat requestStat = WebRequestStat.current();
        if (requestStat != null) {
            this.addJdbcExecuteCount(requestStat.getJdbcExecuteCount());
            this.addJdbcFetchRowCount(requestStat.getJdbcFetchRowCount());
            this.addJdbcUpdateCount(requestStat.getJdbcUpdateCount());
            this.addJdbcCommitCount(requestStat.getJdbcCommitCount());
            this.addJdbcRollbackCount(requestStat.getJdbcRollbackCount());
            this.addJdbcExecuteTimeNano(requestStat.getJdbcExecuteTimeNano());
        }
    }

    public void addRemoteAddress(String ip) {
        this.remoteAddresses.add(ip);
    }

    public int getRunningCount() {
        return this.runningCount.get();
    }

    public long getConcurrentMax() {
        return this.concurrentMax.get();
    }

    public long getRequestCount() {
        return this.requestCount.get();
    }

    public long getRequestErrorCount() {
        return this.requestErrorCount.get();
    }

    public long getRequestTimeNano() {
        return this.requestTimeNano.get();
    }

    public long getRequestTimeMillis() {
        return this.getRequestTimeNano() / 1000000L;
    }

    public void addJdbcFetchRowCount(long delta) {
        this.jdbcFetchRowCount.addAndGet(delta);
    }

    public long getJdbcFetchRowCount() {
        return this.jdbcFetchRowCount.get();
    }

    public void addJdbcUpdateCount(long updateCount) {
        this.jdbcUpdateCount.addAndGet(updateCount);
    }

    public long getJdbcUpdateCount() {
        return this.jdbcUpdateCount.get();
    }

    public void incrementJdbcExecuteCount() {
        this.jdbcExecuteCount.incrementAndGet();
    }

    public void addJdbcExecuteCount(long executeCount) {
        this.jdbcExecuteCount.addAndGet(executeCount);
    }

    public long getJdbcExecuteCount() {
        return this.jdbcExecuteCount.get();
    }

    public long getJdbcExecuteTimeMillis() {
        return this.getJdbcExecuteTimeNano() / 1000000L;
    }

    public long getJdbcExecuteTimeNano() {
        return this.jdbcExecuteTimeNano.get();
    }

    public void addJdbcExecuteTimeNano(long nano) {
        this.jdbcExecuteTimeNano.addAndGet(nano);
    }

    public void incrementJdbcCommitCount() {
        this.jdbcCommitCount.incrementAndGet();
    }

    public long getJdbcCommitCount() {
        return this.jdbcCommitCount.get();
    }

    public void addJdbcCommitCount(long commitCount) {
        this.jdbcCommitCount.addAndGet(commitCount);
    }

    public void incrementJdbcRollbackCount() {
        this.jdbcRollbackCount.incrementAndGet();
    }

    public long getJdbcRollbackCount() {
        return this.jdbcRollbackCount.get();
    }

    public void addJdbcRollbackCount(long rollbackCount) {
        this.jdbcRollbackCount.addAndGet(rollbackCount);
    }

    public long[] getRequestInterval() {
        return this.requestIntervalHistogram.toArray();
    }

    public Map<String, Object> getStatData() {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        data.put("SESSIONID", this.getSessionId());
        data.put("Principal", this.getPrincipal());
        data.put("RunningCount", this.getRunningCount());
        data.put("ConcurrentMax", this.getConcurrentMax());
        data.put("RequestCount", this.getRequestCount());
        data.put("RequestTimeMillisTotal", this.getRequestTimeMillis());
        data.put("CreateTime", this.getCreateTime());
        data.put("LastAccessTime", this.getLastAccessTime());
        data.put("RemoteAddress", this.getRemoteAddress());
        data.put("Principal", this.getPrincipal());
        data.put("JdbcCommitCount", this.getJdbcCommitCount());
        data.put("JdbcRollbackCount", this.getJdbcRollbackCount());
        data.put("JdbcExecuteCount", this.getJdbcExecuteCount());
        data.put("JdbcExecuteTimeMillis", this.getJdbcExecuteTimeMillis());
        data.put("JdbcFetchRowCount", this.getJdbcFetchRowCount());
        data.put("JdbcUpdateCount", this.getJdbcUpdateCount());
        data.put("UserAgent", this.getUserAgent());
        data.put("RequestInterval", this.getRequestInterval());
        return data;
    }
}

