/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.jconsole;

import com.alibaba.druid.support.jconsole.model.DruidTableModel;
import com.alibaba.druid.support.json.JSONUtils;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.sun.tools.jconsole.JConsoleContext;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public abstract class DruidPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected static final int RESP_SUCCESS_RESULT = 1;
    protected static final String RESP_JSON_RESULT_KEY = "ResultCode";
    protected static final String RESP_JSON_CONTENT_KEY = "Content";
    protected static final long DEFAULT_ACTIVE_TIME = 300000L;
    protected static final int DRUID_TABLE_WIDTH = 600;
    protected static final int DRUID_TABLE_HEIGHT = 500;
    protected JScrollPane scrollPane;
    protected DruidTableModel tableModel;
    protected JTable table;
    protected String url;
    protected long activeTime;
    protected long lastRefreshTime;
    private static final Log LOG = LogFactory.getLog(DruidPanel.class);

    protected DruidPanel(long activeTime) {
        this.activeTime = activeTime;
    }

    protected DruidPanel() {
        this.activeTime = 300000L;
    }

    protected ArrayList<LinkedHashMap<String, Object>> parseData(Object respData) {
        LinkedHashMap map;
        int rv;
        ArrayList<LinkedHashMap> data = null;
        if (respData instanceof Map && (rv = ((Integer)(map = (LinkedHashMap)respData).get(RESP_JSON_RESULT_KEY)).intValue()) == 1) {
            Object content = map.get(RESP_JSON_CONTENT_KEY);
            if (content instanceof List) {
                data = (ArrayList<LinkedHashMap>)content;
            } else if (content instanceof Map) {
                LinkedHashMap contentEle = (LinkedHashMap)content;
                data = new ArrayList<LinkedHashMap>();
                data.add(contentEle);
            }
        }
        return data;
    }

    protected Object getData(String url, MBeanServerConnection conn) throws Exception {
        Object o = null;
        ObjectName name = new ObjectName("com.alibaba.druid:type=DruidStatService");
        String result = (String)conn.invoke(name, "service", new String[]{url}, new String[]{String.class.getName()});
        o = JSONUtils.parse(result);
        if (LOG.isDebugEnabled()) {
            LOG.debug(o.toString());
        }
        return o;
    }

    protected abstract void tableDataProcess(ArrayList<LinkedHashMap<String, Object>> var1);

    protected void addOrRefreshTable(String url, MBeanServerConnection conn) throws Exception {
        if (url != null) {
            boolean needRefresh = false;
            long timeNow = new Date().getTime();
            if (this.scrollPane == null) {
                this.table = new JTable();
                this.scrollPane = new JScrollPane(this.table);
                this.scrollPane.setAutoscrolls(true);
                GridBagLayout gridbag = new GridBagLayout();
                GridBagConstraints c = new GridBagConstraints();
                this.setLayout(gridbag);
                c.fill = 1;
                c.gridx = 0;
                c.gridy = 0;
                c.weightx = 9.0;
                c.weighty = 9.0;
                gridbag.setConstraints(this.scrollPane, c);
                this.add(this.scrollPane);
                needRefresh = true;
                this.lastRefreshTime = timeNow;
            } else if (this.lastRefreshTime + this.activeTime < timeNow) {
                needRefresh = true;
                this.lastRefreshTime = timeNow;
            }
            if (needRefresh) {
                LOG.debug("refresh" + timeNow);
                ArrayList<LinkedHashMap<String, Object>> data = this.parseData(this.getData(url, conn));
                if (data != null) {
                    this.tableDataProcess(data);
                }
            }
        } else {
            LOG.warn("url\u4e0d\u5b58\u5728");
        }
    }

    protected Object doInBackground(JConsoleContext context) throws Exception {
        this.doInBackground(context.getMBeanServerConnection());
        return null;
    }

    protected void doInBackground(MBeanServerConnection conn) {
        try {
            this.addOrRefreshTable(this.url, conn);
        }
        catch (Exception e) {
            LOG.warn("", e);
        }
    }
}

