/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.config;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.Version;
import com.alibaba.dubbo.common.bytecode.Wrapper;
import com.alibaba.dubbo.common.extension.ExtensionLoader;
import com.alibaba.dubbo.common.utils.ClassHelper;
import com.alibaba.dubbo.common.utils.ConfigUtils;
import com.alibaba.dubbo.common.utils.NetUtils;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.dubbo.config.AbstractServiceConfig;
import com.alibaba.dubbo.config.ArgumentConfig;
import com.alibaba.dubbo.config.MethodConfig;
import com.alibaba.dubbo.config.ProtocolConfig;
import com.alibaba.dubbo.config.ProviderConfig;
import com.alibaba.dubbo.config.annotation.Service;
import com.alibaba.dubbo.config.support.Parameter;
import com.alibaba.dubbo.rpc.Exporter;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Protocol;
import com.alibaba.dubbo.rpc.ProxyFactory;
import com.alibaba.dubbo.rpc.cluster.ConfiguratorFactory;
import com.alibaba.dubbo.rpc.protocol.ServiceImplHolder;
import com.alibaba.dubbo.rpc.service.GenericService;
import com.alibaba.dubbo.rpc.support.ProtocolUtils;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class ServiceConfig<T>
extends AbstractServiceConfig {
    private static final long serialVersionUID = 3033787999037024738L;
    private static final Protocol protocol = ExtensionLoader.getExtensionLoader(Protocol.class).getAdaptiveExtension();
    private static final ProxyFactory proxyFactory = ExtensionLoader.getExtensionLoader(ProxyFactory.class).getAdaptiveExtension();
    private static final Map<String, Integer> RANDOM_PORT_MAP = new HashMap<String, Integer>();
    private String interfaceName;
    private Class<?> interfaceClass;
    private T ref;
    private String path;
    private List<MethodConfig> methods;
    private ProviderConfig provider;
    private final List<URL> urls = new ArrayList<URL>();
    private final List<Exporter<?>> exporters = new ArrayList();
    private volatile transient boolean exported;
    private volatile transient boolean unexported;
    private volatile String generic;

    public ServiceConfig() {
    }

    public ServiceConfig(Service service) {
        this.appendAnnotation(Service.class, service);
    }

    public URL toUrl() {
        return this.urls == null || this.urls.size() == 0 ? null : this.urls.iterator().next();
    }

    public List<URL> toUrls() {
        return this.urls;
    }

    @Parameter(excluded=true)
    public boolean isExported() {
        return this.exported;
    }

    @Parameter(excluded=true)
    public boolean isUnexported() {
        return this.unexported;
    }

    public synchronized void export() {
        if (this.provider != null) {
            if (this.export == null) {
                this.export = this.provider.getExport();
            }
            if (this.delay == null) {
                this.delay = this.provider.getDelay();
            }
        }
        if (this.export != null && !this.export.booleanValue()) {
            return;
        }
        if (this.delay != null && this.delay > 0) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(ServiceConfig.this.delay.intValue());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    ServiceConfig.this.doExport();
                }
            });
            thread.setDaemon(true);
            thread.setName("DelayExportServiceThread");
            thread.start();
        } else {
            this.doExport();
        }
    }

    protected synchronized void doExport() {
        if (this.unexported) {
            throw new IllegalStateException("Already unexported!");
        }
        if (this.exported) {
            return;
        }
        this.exported = true;
        if (this.interfaceName == null || this.interfaceName.length() == 0) {
            throw new IllegalStateException("<dubbo:service interface=\"\" /> interface not allow null!");
        }
        this.checkDefault();
        if (this.provider != null) {
            if (this.application == null) {
                this.application = this.provider.getApplication();
            }
            if (this.module == null) {
                this.module = this.provider.getModule();
            }
            if (this.registries == null) {
                this.registries = this.provider.getRegistries();
            }
            if (this.monitor == null) {
                this.monitor = this.provider.getMonitor();
            }
            if (this.protocols == null) {
                this.protocols = this.provider.getProtocols();
            }
        }
        if (this.module != null) {
            if (this.registries == null) {
                this.registries = this.module.getRegistries();
            }
            if (this.monitor == null) {
                this.monitor = this.module.getMonitor();
            }
        }
        if (this.application != null) {
            if (this.registries == null) {
                this.registries = this.application.getRegistries();
            }
            if (this.monitor == null) {
                this.monitor = this.application.getMonitor();
            }
        }
        if (this.ref instanceof GenericService) {
            this.interfaceClass = GenericService.class;
            if (StringUtils.isEmpty(this.generic)) {
                this.generic = Boolean.TRUE.toString();
            }
        } else {
            try {
                this.interfaceClass = Class.forName(this.interfaceName, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
            this.checkInterfaceAndMethods(this.interfaceClass, this.methods);
            this.checkRef();
            this.generic = Boolean.FALSE.toString();
        }
        if (this.local != null) {
            Class<?> localClass;
            if (this.local == "true") {
                this.local = this.interfaceName + "Local";
            }
            try {
                localClass = ClassHelper.forNameWithThreadContextClassLoader(this.local);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
            if (!this.interfaceClass.isAssignableFrom(localClass)) {
                throw new IllegalStateException("The local implemention class " + localClass.getName() + " not implement interface " + this.interfaceName);
            }
        }
        if (this.stub != null) {
            Class<?> stubClass;
            if (this.stub == "true") {
                this.stub = this.interfaceName + "Stub";
            }
            try {
                stubClass = ClassHelper.forNameWithThreadContextClassLoader(this.stub);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
            if (!this.interfaceClass.isAssignableFrom(stubClass)) {
                throw new IllegalStateException("The stub implemention class " + stubClass.getName() + " not implement interface " + this.interfaceName);
            }
        }
        this.checkApplication();
        this.checkRegistry();
        this.checkProtocol();
        ServiceConfig.appendProperties(this);
        this.checkStubAndMock(this.interfaceClass);
        if (this.path == null || this.path.length() == 0) {
            this.path = this.interfaceName;
        }
        this.doExportUrls();
    }

    private void checkRef() {
        if (this.ref == null) {
            throw new IllegalStateException("ref not allow null!");
        }
        if (!this.interfaceClass.isInstance(this.ref)) {
            throw new IllegalStateException("The class " + this.ref.getClass().getName() + " unimplemented interface " + this.interfaceClass + "!");
        }
    }

    public synchronized void unexport() {
        if (!this.exported) {
            return;
        }
        if (this.unexported) {
            return;
        }
        if (this.exporters != null && this.exporters.size() > 0) {
            for (Exporter<?> exporter : this.exporters) {
                try {
                    exporter.unexport();
                }
                catch (Throwable t) {
                    logger.warn("unexpected err when unexport" + exporter, t);
                }
            }
            this.exporters.clear();
        }
        this.unexported = true;
    }

    private void doExportUrls() {
        List<URL> registryURLs = this.loadRegistries(true);
        for (ProtocolConfig protocolConfig : this.protocols) {
            this.doExportUrlsFor1Protocol(protocolConfig, registryURLs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExportUrlsFor1Protocol(ProtocolConfig protocolConfig, List<URL> registryURLs) {
        String contextPath;
        String name = protocolConfig.getName();
        if (name == null || name.length() == 0) {
            name = "dubbo";
        }
        String host = protocolConfig.getHost();
        if (this.provider != null && (host == null || host.length() == 0)) {
            host = this.provider.getHost();
        }
        boolean anyhost = false;
        if (NetUtils.isInvalidLocalHost(host)) {
            anyhost = true;
            try {
                host = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                logger.warn(e.getMessage(), e);
            }
            if (NetUtils.isInvalidLocalHost(host)) {
                if (registryURLs != null && registryURLs.size() > 0) {
                    for (URL registryURL : registryURLs) {
                        try {
                            Socket socket = new Socket();
                            try {
                                InetSocketAddress addr = new InetSocketAddress(registryURL.getHost(), registryURL.getPort());
                                socket.connect(addr, 1000);
                                host = socket.getLocalAddress().getHostAddress();
                                break;
                            }
                            finally {
                                try {
                                    socket.close();
                                }
                                catch (Throwable e) {}
                            }
                        }
                        catch (Exception e) {
                            logger.warn(e.getMessage(), e);
                        }
                    }
                }
                if (NetUtils.isInvalidLocalHost(host)) {
                    host = NetUtils.getLocalHost();
                }
            }
        }
        Integer port = protocolConfig.getPort();
        if (this.provider != null && (port == null || port == 0)) {
            port = this.provider.getPort();
        }
        int defaultPort = ExtensionLoader.getExtensionLoader(Protocol.class).getExtension(name).getDefaultPort();
        if (port == null || port == 0) {
            port = defaultPort;
        }
        if (port == null || port <= 0) {
            port = ServiceConfig.getRandomPort(name);
            if (port == null || port < 0) {
                port = NetUtils.getAvailablePort(defaultPort);
                ServiceConfig.putRandomPort(name, port);
            }
            logger.warn("Use random available port(" + port + ") for protocol " + name);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if (anyhost) {
            map.put("anyhost", "true");
        }
        map.put("side", "provider");
        map.put("dubbo", Version.getVersion());
        map.put("timestamp", String.valueOf(System.currentTimeMillis()));
        if (ConfigUtils.getPid() > 0) {
            map.put("pid", String.valueOf(ConfigUtils.getPid()));
        }
        ServiceConfig.appendParameters(map, this.application);
        ServiceConfig.appendParameters(map, this.module);
        ServiceConfig.appendParameters(map, this.provider, "default");
        ServiceConfig.appendParameters(map, protocolConfig);
        ServiceConfig.appendParameters(map, this);
        if (this.methods != null && this.methods.size() > 0) {
            for (MethodConfig method : this.methods) {
                List<ArgumentConfig> arguments;
                String retryValue;
                ServiceConfig.appendParameters(map, method, method.getName());
                String retryKey = method.getName() + ".retry";
                if (map.containsKey(retryKey) && "false".equals(retryValue = (String)map.remove(retryKey))) {
                    map.put(method.getName() + ".retries", "0");
                }
                if ((arguments = method.getArguments()) == null || arguments.size() <= 0) continue;
                for (ArgumentConfig argument : arguments) {
                    if (argument.getType() != null && argument.getType().length() > 0) {
                        Method[] methods = this.interfaceClass.getMethods();
                        if (methods == null || methods.length <= 0) continue;
                        for (int i = 0; i < methods.length; ++i) {
                            String methodName = methods[i].getName();
                            if (!methodName.equals(method.getName())) continue;
                            Class<?>[] argtypes = methods[i].getParameterTypes();
                            if (argument.getIndex() != -1) {
                                if (argtypes[argument.getIndex()].getName().equals(argument.getType())) {
                                    ServiceConfig.appendParameters(map, argument, method.getName() + "." + argument.getIndex());
                                    continue;
                                }
                                throw new IllegalArgumentException("argument config error : the index attribute and type attirbute not match :index :" + argument.getIndex() + ", type:" + argument.getType());
                            }
                            for (int j = 0; j < argtypes.length; ++j) {
                                Class<?> argclazz = argtypes[j];
                                if (!argclazz.getName().equals(argument.getType())) continue;
                                ServiceConfig.appendParameters(map, argument, method.getName() + "." + j);
                                if (argument.getIndex() == -1 || argument.getIndex() == j) continue;
                                throw new IllegalArgumentException("argument config error : the index attribute and type attirbute not match :index :" + argument.getIndex() + ", type:" + argument.getType());
                            }
                        }
                        continue;
                    }
                    if (argument.getIndex() != -1) {
                        ServiceConfig.appendParameters(map, argument, method.getName() + "." + argument.getIndex());
                        continue;
                    }
                    throw new IllegalArgumentException("argument config must set index or type attribute.eg: <dubbo:argument index='0' .../> or <dubbo:argument type=xxx .../>");
                }
            }
        }
        if (ProtocolUtils.isGeneric(this.generic)) {
            map.put("generic", this.generic);
            map.put("methods", "*");
        } else {
            String[] methods;
            String revision = Version.getVersion(this.interfaceClass, this.version);
            if (revision != null && revision.length() > 0) {
                map.put("revision", revision);
            }
            if ((methods = Wrapper.getWrapper(this.interfaceClass).getMethodNames()).length == 0) {
                logger.warn("NO method found in service interface " + this.interfaceClass.getName());
                map.put("methods", "*");
            } else {
                map.put("methods", StringUtils.join(new HashSet<String>(Arrays.asList(methods)), ","));
            }
        }
        if (!ConfigUtils.isEmpty(this.token)) {
            if (ConfigUtils.isDefault(this.token)) {
                map.put("token", UUID.randomUUID().toString());
            } else {
                map.put("token", this.token);
            }
        }
        if ("injvm".equals(protocolConfig.getName())) {
            protocolConfig.setRegister(false);
            map.put("notify", "false");
        }
        if (((contextPath = protocolConfig.getContextpath()) == null || contextPath.length() == 0) && this.provider != null) {
            contextPath = this.provider.getContextpath();
        }
        URL url = new URL(name, host, (int)port, (contextPath == null || contextPath.length() == 0 ? "" : contextPath + "/") + this.path, map);
        if (ExtensionLoader.getExtensionLoader(ConfiguratorFactory.class).hasExtension(url.getProtocol())) {
            url = ExtensionLoader.getExtensionLoader(ConfiguratorFactory.class).getExtension(url.getProtocol()).getConfigurator(url).configure(url);
        }
        String scope = url.getParameter("scope");
        if (!"none".toString().equalsIgnoreCase(scope)) {
            if (!"remote".toString().equalsIgnoreCase(scope)) {
                this.exportLocal(url);
            }
            if (!"local".toString().equalsIgnoreCase(scope)) {
                if (logger.isInfoEnabled()) {
                    logger.info("Export dubbo service " + this.interfaceClass.getName() + " to url " + url);
                }
                if (registryURLs != null && registryURLs.size() > 0 && url.getParameter("register", true)) {
                    for (URL registryURL : registryURLs) {
                        url = url.addParameterIfAbsent("dynamic", registryURL.getParameter("dynamic"));
                        URL monitorUrl = this.loadMonitor(registryURL);
                        if (monitorUrl != null) {
                            url = url.addParameterAndEncoded("monitor", monitorUrl.toFullString());
                        }
                        if (logger.isInfoEnabled()) {
                            logger.info("Register dubbo service " + this.interfaceClass.getName() + " url " + url + " to registry " + registryURL);
                        }
                        Invoker<T> invoker = proxyFactory.getInvoker(this.ref, this.interfaceClass, registryURL.addParameterAndEncoded("export", url.toFullString()));
                        Exporter<T> exporter = protocol.export(invoker);
                        this.exporters.add(exporter);
                    }
                } else {
                    Invoker<T> invoker = proxyFactory.getInvoker(this.ref, this.interfaceClass, url);
                    Exporter<T> exporter = protocol.export(invoker);
                    this.exporters.add(exporter);
                }
            }
        }
        this.urls.add(url);
    }

    private void exportLocal(URL url) {
        if (!"injvm".equalsIgnoreCase(url.getProtocol())) {
            URL local = URL.valueOf(url.toFullString()).setProtocol("injvm").setHost("127.0.0.1").setPort(0);
            ServiceImplHolder.getInstance().pushServiceImpl(this.ref);
            Exporter<T> exporter = protocol.export(proxyFactory.getInvoker(this.ref, this.interfaceClass, local));
            this.exporters.add(exporter);
            logger.info("Export dubbo service " + this.interfaceClass.getName() + " to local registry");
        }
    }

    private void checkDefault() {
        if (this.provider == null) {
            this.provider = new ProviderConfig();
        }
        ServiceConfig.appendProperties(this.provider);
    }

    private void checkProtocol() {
        if ((this.protocols == null || this.protocols.size() == 0) && this.provider != null) {
            this.setProtocols(this.provider.getProtocols());
        }
        if (this.protocols == null || this.protocols.size() == 0) {
            this.setProtocol(new ProtocolConfig());
        }
        for (ProtocolConfig protocolConfig : this.protocols) {
            if (StringUtils.isEmpty(protocolConfig.getName())) {
                protocolConfig.setName("dubbo");
            }
            ServiceConfig.appendProperties(protocolConfig);
        }
    }

    public Class<?> getInterfaceClass() {
        if (this.interfaceClass != null) {
            return this.interfaceClass;
        }
        if (this.ref instanceof GenericService) {
            return GenericService.class;
        }
        try {
            if (this.interfaceName != null && this.interfaceName.length() > 0) {
                this.interfaceClass = Class.forName(this.interfaceName, true, Thread.currentThread().getContextClassLoader());
            }
        }
        catch (ClassNotFoundException t) {
            throw new IllegalStateException(t.getMessage(), t);
        }
        return this.interfaceClass;
    }

    public void setInterfaceClass(Class<?> interfaceClass) {
        this.setInterface(interfaceClass);
    }

    public String getInterface() {
        return this.interfaceName;
    }

    public void setInterface(String interfaceName) {
        this.interfaceName = interfaceName;
        if (this.id == null || this.id.length() == 0) {
            this.id = interfaceName;
        }
    }

    public void setInterface(Class<?> interfaceClass) {
        if (interfaceClass != null && !interfaceClass.isInterface()) {
            throw new IllegalStateException("The interface class " + interfaceClass + " is not a interface!");
        }
        this.interfaceClass = interfaceClass;
        this.setInterface(interfaceClass == null ? (String)null : interfaceClass.getName());
    }

    public T getRef() {
        return this.ref;
    }

    public void setRef(T ref) {
        this.ref = ref;
    }

    @Parameter(excluded=true)
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        ServiceConfig.checkPathName("path", path);
        this.path = path;
    }

    public List<MethodConfig> getMethods() {
        return this.methods;
    }

    public void setMethods(List<? extends MethodConfig> methods) {
        this.methods = methods;
    }

    public ProviderConfig getProvider() {
        return this.provider;
    }

    public void setGeneric(String generic) {
        if (StringUtils.isEmpty(generic)) {
            return;
        }
        if (!ProtocolUtils.isGeneric(generic)) {
            throw new IllegalArgumentException("Unsupported generic type " + generic);
        }
        this.generic = generic;
    }

    public String getGeneric() {
        return this.generic;
    }

    public void setProvider(ProviderConfig provider) {
        this.provider = provider;
    }

    public List<URL> getExportedUrls() {
        return this.urls;
    }

    @Deprecated
    public List<ProviderConfig> getProviders() {
        return ServiceConfig.convertProtocolToProvider(this.protocols);
    }

    @Deprecated
    public void setProviders(List<ProviderConfig> providers) {
        this.protocols = ServiceConfig.convertProviderToProtocol(providers);
    }

    @Deprecated
    private static final List<ProtocolConfig> convertProviderToProtocol(List<ProviderConfig> providers) {
        if (providers == null || providers.size() == 0) {
            return null;
        }
        ArrayList<ProtocolConfig> protocols = new ArrayList<ProtocolConfig>(providers.size());
        for (ProviderConfig provider : providers) {
            protocols.add(ServiceConfig.convertProviderToProtocol(provider));
        }
        return protocols;
    }

    @Deprecated
    private static final List<ProviderConfig> convertProtocolToProvider(List<ProtocolConfig> protocols) {
        if (protocols == null || protocols.size() == 0) {
            return null;
        }
        ArrayList<ProviderConfig> providers = new ArrayList<ProviderConfig>(protocols.size());
        for (ProtocolConfig provider : protocols) {
            providers.add(ServiceConfig.convertProtocolToProvider(provider));
        }
        return providers;
    }

    @Deprecated
    private static final ProtocolConfig convertProviderToProtocol(ProviderConfig provider) {
        ProtocolConfig protocol = new ProtocolConfig();
        protocol.setName(provider.getProtocol().getName());
        protocol.setServer(provider.getServer());
        protocol.setClient(provider.getClient());
        protocol.setCodec(provider.getCodec());
        protocol.setHost(provider.getHost());
        protocol.setPort(provider.getPort());
        protocol.setPath(provider.getPath());
        protocol.setPayload(provider.getPayload());
        protocol.setThreads(provider.getThreads());
        protocol.setParameters(provider.getParameters());
        return protocol;
    }

    @Deprecated
    private static final ProviderConfig convertProtocolToProvider(ProtocolConfig protocol) {
        ProviderConfig provider = new ProviderConfig();
        provider.setProtocol(protocol);
        provider.setServer(protocol.getServer());
        provider.setClient(protocol.getClient());
        provider.setCodec(protocol.getCodec());
        provider.setHost(protocol.getHost());
        provider.setPort(protocol.getPort());
        provider.setPath(protocol.getPath());
        provider.setPayload(protocol.getPayload());
        provider.setThreads(protocol.getThreads());
        provider.setParameters(protocol.getParameters());
        return provider;
    }

    private static Integer getRandomPort(String protocol) {
        if (RANDOM_PORT_MAP.containsKey(protocol = protocol.toLowerCase())) {
            return RANDOM_PORT_MAP.get(protocol);
        }
        return Integer.MIN_VALUE;
    }

    private static void putRandomPort(String protocol, Integer port) {
        if (!RANDOM_PORT_MAP.containsKey(protocol = protocol.toLowerCase())) {
            RANDOM_PORT_MAP.put(protocol, port);
        }
    }
}

