/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.http.client.response;

import com.alibaba.nacos.common.http.client.response.HttpClientResponse;
import com.alibaba.nacos.common.http.param.Header;
import com.alibaba.nacos.common.utils.IoUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;

public class JdkHttpClientResponse
implements HttpClientResponse {
    private final HttpURLConnection conn;
    private InputStream responseStream;
    private Header responseHeader;

    public JdkHttpClientResponse(HttpURLConnection conn) {
        this.conn = conn;
    }

    @Override
    public Header getHeaders() {
        if (this.responseHeader == null) {
            this.responseHeader = Header.newInstance();
        }
        this.responseHeader.setOriginalResponseHeader(this.conn.getHeaderFields());
        return this.responseHeader;
    }

    @Override
    public InputStream getBody() throws IOException {
        InputStream errorStream = this.conn.getErrorStream();
        this.responseStream = errorStream != null ? errorStream : this.conn.getInputStream();
        return this.responseStream;
    }

    @Override
    public int getStatusCode() throws IOException {
        return this.conn.getResponseCode();
    }

    @Override
    public String getStatusText() throws IOException {
        return this.conn.getResponseMessage();
    }

    @Override
    public void close() {
        IoUtils.closeQuietly(this.responseStream);
    }
}

