/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.config;

import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.po.TableField;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public interface INameConvert {
    @NotNull
    public String entityNameConvert(@NotNull TableInfo var1);

    @NotNull
    public String propertyNameConvert(@NotNull TableField var1);

    public static class DefaultNameConvert
    implements INameConvert {
        private final StrategyConfig strategyConfig;

        public DefaultNameConvert(StrategyConfig strategyConfig) {
            this.strategyConfig = strategyConfig;
        }

        @Override
        @NotNull
        public String entityNameConvert(@NotNull TableInfo tableInfo) {
            return NamingStrategy.capitalFirst(this.processName(tableInfo.getName(), this.strategyConfig.entity().getNaming(), this.strategyConfig.getTablePrefix()));
        }

        @Override
        @NotNull
        public String propertyNameConvert(@NotNull TableField field) {
            return this.processName(field.getName(), this.strategyConfig.entity().getColumnNaming(), this.strategyConfig.getFieldPrefix());
        }

        private String processName(String name, NamingStrategy strategy, Set<String> prefix) {
            String propertyName = prefix.size() > 0 ? (strategy == NamingStrategy.underline_to_camel ? NamingStrategy.removePrefixAndCamel(name, prefix) : NamingStrategy.removePrefix(name, prefix)) : (strategy == NamingStrategy.underline_to_camel ? NamingStrategy.underlineToCamel(name) : name);
            return propertyName;
        }
    }
}

