/*
 * Decompiled with CFR 0.152.
 */
package com.ace.cache.api.impl;

import com.ace.cache.api.CacheAPI;
import com.ace.cache.config.RedisConfig;
import com.ace.cache.entity.CacheBean;
import com.ace.cache.service.IRedisService;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CacheRedis
implements CacheAPI {
    @Autowired
    private RedisConfig redisConfig;
    @Autowired
    private IRedisService redisCacheService;

    @Override
    public String get(String key) {
        if (!this.isEnabled()) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        CacheBean cache = this.getCacheBean(key);
        if (cache != null) {
            if (cache.getExpireTime().getTime() > new Date().getTime()) {
                return this.redisCacheService.get(cache.getKey());
            }
            this.redisCacheService.del(this.addSys(key));
            this.redisCacheService.del(cache.getKey());
        }
        return null;
    }

    @Override
    public void set(String key, Object value, int expireMin) {
        this.set(key, value, expireMin, "");
    }

    @Override
    public Long remove(String key) {
        if (!this.isEnabled()) {
            return 0L;
        }
        if (StringUtils.isBlank((CharSequence)key)) {
            return 0L;
        }
        try {
            CacheBean cache = this.getCacheBean(key);
            if (cache != null) {
                this.redisCacheService.del(this.addSys(key));
                this.redisCacheService.del(cache.getKey());
            }
        }
        catch (Exception e) {
            return 0L;
        }
        return 1L;
    }

    @Override
    public Long remove(String ... keys) {
        if (!this.isEnabled()) {
            return null;
        }
        try {
            for (int i = 0; i < keys.length; ++i) {
                this.remove(keys[i]);
            }
        }
        catch (Exception e) {
            return 0L;
        }
        return 1L;
    }

    @Override
    public Long removeByPre(String pre) {
        if (!this.isEnabled()) {
            return 0L;
        }
        if (StringUtils.isBlank((CharSequence)pre)) {
            return 0L;
        }
        try {
            Set<String> result = this.redisCacheService.getByPre(this.addSys(pre));
            ArrayList<String> list = new ArrayList<String>();
            for (String key : result) {
                CacheBean cache = this.getCacheBean(key);
                list.add(cache.getKey());
            }
            this.redisCacheService.del(list.toArray(new String[0]));
            this.redisCacheService.delPre(this.addSys(pre));
        }
        catch (Exception e) {
            return 0L;
        }
        return 1L;
    }

    private CacheBean getCacheBean(String key) {
        key = this.addSys(key);
        CacheBean cache = null;
        try {
            cache = (CacheBean)JSON.parseObject((String)this.redisCacheService.get(key), CacheBean.class);
        }
        catch (Exception e) {
            cache = new CacheBean();
            cache.setKey(key);
            cache.setExpireTime(this.redisCacheService.getExpireDate(key));
        }
        return cache;
    }

    @Override
    public String addSys(String key) {
        String result = key;
        String sys = this.redisConfig.getSysName();
        result = key.startsWith(sys) ? key : sys + ":" + key;
        return result;
    }

    @Override
    public void set(String key, Object value, int expireMin, String desc) {
        if (StringUtils.isBlank((CharSequence)key) || value == null || StringUtils.isBlank((CharSequence)value.toString())) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        String realValue = "";
        realValue = value instanceof String ? value.toString() : JSON.toJSONString((Object)value, (boolean)false);
        String realKey = "i_" + this.addSys(key);
        Date time = new DateTime((Object)this.redisCacheService.getExpireDate(realKey)).plusMinutes(expireMin).toDate();
        CacheBean cache = new CacheBean(realKey, desc, time);
        String result = JSON.toJSONString((Object)cache, (boolean)false);
        this.redisCacheService.set(this.addSys(key), result, expireMin * 60);
        this.redisCacheService.set(realKey, realValue, expireMin * 60);
    }

    @Override
    public List<CacheBean> listAll() {
        Set<String> result = this.redisCacheService.getByPre(this.addSys(""));
        ArrayList<CacheBean> caches = new ArrayList<CacheBean>();
        if (result == null) {
            return caches;
        }
        Iterator<String> it = result.iterator();
        String key = "";
        CacheBean cache = null;
        while (it.hasNext()) {
            cache = null;
            key = it.next();
            try {
                cache = (CacheBean)JSON.parseObject((String)this.redisCacheService.get(key), CacheBean.class);
            }
            catch (Exception e) {
                cache = new CacheBean();
                cache.setKey(key);
                cache.setExpireTime(this.redisCacheService.getExpireDate(key));
            }
            if (cache == null) continue;
            cache.setKey(key);
            caches.add(cache);
        }
        return caches;
    }

    @Override
    public List<CacheBean> getCacheBeanByPre(String pre) {
        if (StringUtils.isBlank((CharSequence)pre)) {
            return new ArrayList<CacheBean>();
        }
        Set<String> result = this.redisCacheService.getByPre(pre);
        Iterator<String> it = result.iterator();
        ArrayList<CacheBean> caches = new ArrayList<CacheBean>();
        String key = "";
        CacheBean cache = null;
        while (it.hasNext()) {
            key = it.next();
            try {
                cache = (CacheBean)JSON.parseObject((String)this.redisCacheService.get(key), CacheBean.class);
            }
            catch (Exception e) {
                cache = new CacheBean();
                cache.setKey(key);
                cache.setExpireTime(this.redisCacheService.getExpireDate(key));
            }
            cache.setKey(key);
            caches.add(cache);
        }
        return caches;
    }

    @Override
    public boolean isEnabled() {
        return Boolean.parseBoolean(this.redisConfig.getEnable());
    }
}

