/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.hickory.incremental;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

public class StateSaver<T extends Serializable> {
    static Map<String, StateSaver<?>> cache = new HashMap();
    Filer filer;
    static ProcessingEnvironment penv;
    private boolean stateSaved;
    private boolean stateRoundStarted;
    String persistenceName;
    private Map<String, List<T>> srcCompUnitData;

    private StateSaver(String processorFQN, Filer filer) {
        this.persistenceName = processorFQN;
        this.filer = filer;
        this.restore();
    }

    public static <K extends Serializable> StateSaver<K> getInstance(Processor processor, Class<K> type, ProcessingEnvironment penv) {
        String key;
        if (penv != StateSaver.penv) {
            StateSaver.penv = penv;
            cache.clear();
        }
        if (cache.containsKey(key = processor.getClass().getName() + " " + type.getClass().getName())) {
            return cache.get(key);
        }
        StateSaver result = new StateSaver(key, penv.getFiler());
        cache.put(key, result);
        return result;
    }

    public void startRound(RoundEnvironment env) {
        this.stateRoundStarted = true;
        if (this.stateSaved) {
            throw new IllegalStateException("getData() has already been called in this processor run");
        }
        for (Element element : env.getRootElements()) {
            if (element.getKind() != ElementKind.CLASS && element.getKind() != ElementKind.INTERFACE) continue;
            TypeElement cu = (TypeElement)element;
            String fqn = cu.getQualifiedName().toString();
            this.srcCompUnitData.remove(fqn);
        }
    }

    public void addData(TypeElement contributor, T data) {
        if (!this.stateRoundStarted) {
            throw new IllegalStateException("startRound() must be called before addData()");
        }
        String ownerFQN = contributor.getQualifiedName().toString();
        List<T> existing = this.srcCompUnitData.get(ownerFQN);
        if (existing == null) {
            existing = new ArrayList<T>();
            this.srcCompUnitData.put(ownerFQN, existing);
        }
        existing.add(data);
    }

    public List<T> getData() {
        if (!this.stateSaved) {
            this.save();
            this.stateSaved = true;
        }
        ArrayList<T> result = new ArrayList<T>();
        for (List<T> sub : this.srcCompUnitData.values()) {
            result.addAll(sub);
        }
        return result;
    }

    public Iterable<List<T>> getData(Comparator<? super T> comparator) {
        List<T> flat = this.getData();
        Collections.sort(flat, comparator);
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        Serializable prev = null;
        ArrayList<Serializable> current = null;
        for (Serializable t : flat) {
            if (prev == null || comparator.compare(t, prev) != 0) {
                current = new ArrayList<Serializable>();
                result.add(current);
            }
            current.add(t);
            prev = t;
        }
        return result;
    }

    private void save() {
        try {
            FileObject fo = this.filer.createResource(StandardLocation.SOURCE_OUTPUT, StateSaver.class.getName(), this.persistenceName + ".state", new Element[0]);
            ObjectOutputStream oos = new ObjectOutputStream(fo.openOutputStream());
            oos.writeObject(this.srcCompUnitData);
            oos.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void restore() {
        FileObject fo = null;
        try {
            fo = this.filer.getResource(StandardLocation.SOURCE_OUTPUT, StateSaver.class.getName(), this.persistenceName + ".state");
            ObjectInputStream ois = new ObjectInputStream(fo.openInputStream());
            this.srcCompUnitData = (Map)ois.readObject();
            ois.close();
        }
        catch (FileNotFoundException fnf) {
            this.srcCompUnitData = new HashMap<String, List<T>>();
        }
        catch (IOException ex) {
            System.err.format("reading: %s%n", fo.toUri());
            ex.printStackTrace();
        }
        catch (ClassNotFoundException ex) {
            System.err.format("reading: %s%n", fo.toUri());
            ex.printStackTrace();
        }
    }
}

