/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.utils;

import com.netflix.hystrix.contrib.javanica.aop.aspectj.WeavingMode;
import java.util.Arrays;

public final class EnvUtils {
    private EnvUtils() {
    }

    public static WeavingMode getWeavingMode() {
        String wavingModeParam = System.getProperty("weavingMode", WeavingMode.RUNTIME.name()).toUpperCase();
        try {
            return WeavingMode.valueOf(wavingModeParam);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("wrong 'weavingMode' property, supported: " + Arrays.toString((Object[])WeavingMode.values()) + ", actual = " + wavingModeParam, e);
        }
    }

    public static boolean isCompileWeaving() {
        return WeavingMode.COMPILE == EnvUtils.getWeavingMode();
    }
}

