/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.protocol.rpc;

import com.weibo.api.motan.codec.AbstractCodec;
import com.weibo.api.motan.codec.Serialization;
import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.core.extension.ExtensionLoader;
import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.exception.MotanErrorMsgConstant;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.protocol.rpc.RpcProtocolVersion;
import com.weibo.api.motan.rpc.DefaultRequest;
import com.weibo.api.motan.rpc.DefaultResponse;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.transport.Channel;
import com.weibo.api.motan.util.ByteUtil;
import com.weibo.api.motan.util.ExceptionUtil;
import com.weibo.api.motan.util.ReflectUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;

@SpiMeta(name="motan")
public class DefaultRpcCodec
extends AbstractCodec {
    private static final short MAGIC = -3856;
    private static final byte MASK = 7;

    @Override
    public byte[] encode(Channel channel, Object message) throws IOException {
        try {
            if (message instanceof Request) {
                return this.encodeRequest(channel, (Request)message);
            }
            if (message instanceof Response) {
                return this.encodeResponse(channel, (Response)message);
            }
        }
        catch (Exception e) {
            if (ExceptionUtil.isMotanException(e)) {
                throw (RuntimeException)e;
            }
            throw new MotanFrameworkException("encode error: isResponse=" + (message instanceof Response), e, MotanErrorMsgConstant.FRAMEWORK_ENCODE_ERROR);
        }
        throw new MotanFrameworkException("encode error: message type not support, " + message.getClass(), MotanErrorMsgConstant.FRAMEWORK_ENCODE_ERROR);
    }

    @Override
    public Object decode(Channel channel, String remoteIp, byte[] data) throws IOException {
        if (data.length <= RpcProtocolVersion.VERSION_1.getHeaderLength()) {
            throw new MotanFrameworkException("decode error: format problem", MotanErrorMsgConstant.FRAMEWORK_DECODE_ERROR);
        }
        short type = ByteUtil.bytes2short(data, 0);
        if (type != -3856) {
            throw new MotanFrameworkException("decode error: magic error", MotanErrorMsgConstant.FRAMEWORK_DECODE_ERROR);
        }
        if (data[2] != RpcProtocolVersion.VERSION_1.getVersion()) {
            throw new MotanFrameworkException("decode error: version error", MotanErrorMsgConstant.FRAMEWORK_DECODE_ERROR);
        }
        int bodyLength = ByteUtil.bytes2int(data, 12);
        if (RpcProtocolVersion.VERSION_1.getHeaderLength() + bodyLength != data.length) {
            throw new MotanFrameworkException("decode error: content length error", MotanErrorMsgConstant.FRAMEWORK_DECODE_ERROR);
        }
        byte flag = data[3];
        byte dataType = (byte)(flag & 7);
        boolean isResponse = dataType != 0;
        byte[] body = new byte[bodyLength];
        System.arraycopy(data, RpcProtocolVersion.VERSION_1.getHeaderLength(), body, 0, bodyLength);
        long requestId = ByteUtil.bytes2long(data, 4);
        Serialization serialization = ExtensionLoader.getExtensionLoader(Serialization.class).getExtension(channel.getUrl().getParameter(URLParamType.serialize.getName(), URLParamType.serialize.getValue()));
        try {
            if (isResponse) {
                return this.decodeResponse(body, dataType, requestId, serialization);
            }
            return this.decodeRequest(body, requestId, serialization);
        }
        catch (ClassNotFoundException e) {
            throw new MotanFrameworkException("decode " + (isResponse ? "response" : "request") + " error: class not found", e, MotanErrorMsgConstant.FRAMEWORK_DECODE_ERROR);
        }
        catch (Exception e) {
            if (ExceptionUtil.isMotanException(e)) {
                throw (RuntimeException)e;
            }
            throw new MotanFrameworkException("decode error: isResponse=" + isResponse, e, MotanErrorMsgConstant.FRAMEWORK_DECODE_ERROR);
        }
    }

    private byte[] encodeRequest(Channel channel, Request request) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ObjectOutput output = this.createOutput(outputStream);
        output.writeUTF(request.getInterfaceName());
        output.writeUTF(request.getMethodName());
        output.writeUTF(request.getParamtersDesc());
        Serialization serialization = ExtensionLoader.getExtensionLoader(Serialization.class).getExtension(channel.getUrl().getParameter(URLParamType.serialize.getName(), URLParamType.serialize.getValue()));
        if (request.getArguments() != null && request.getArguments().length > 0) {
            for (Object obj : request.getArguments()) {
                this.serialize(output, obj, serialization);
            }
        }
        if (request.getAttachments() == null || request.getAttachments().isEmpty()) {
            output.writeInt(0);
        } else {
            output.writeInt(request.getAttachments().size());
            for (Map.Entry entry : request.getAttachments().entrySet()) {
                output.writeUTF((String)entry.getKey());
                output.writeUTF((String)entry.getValue());
            }
        }
        output.flush();
        byte[] body = outputStream.toByteArray();
        byte by = 0;
        output.close();
        return this.encode(body, by, request.getRequestId());
    }

    private byte[] encodeResponse(Channel channel, Response value) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ObjectOutput output = this.createOutput(outputStream);
        Serialization serialization = ExtensionLoader.getExtensionLoader(Serialization.class).getExtension(channel.getUrl().getParameter(URLParamType.serialize.getName(), URLParamType.serialize.getValue()));
        byte flag = 0;
        output.writeLong(value.getProcessTime());
        if (value.getException() != null) {
            output.writeUTF(value.getException().getClass().getName());
            this.serialize(output, value.getException(), serialization);
            flag = 5;
        } else if (value.getValue() == null) {
            flag = 3;
        } else {
            output.writeUTF(value.getValue().getClass().getName());
            this.serialize(output, value.getValue(), serialization);
            flag = 1;
        }
        output.flush();
        byte[] body = outputStream.toByteArray();
        output.close();
        return this.encode(body, flag, value.getRequestId());
    }

    private byte[] encode(byte[] body, byte flag, long requestId) throws IOException {
        byte[] header = new byte[RpcProtocolVersion.VERSION_1.getHeaderLength()];
        int offset = 0;
        ByteUtil.short2bytes((short)-3856, header, offset);
        offset += 2;
        header[offset++] = RpcProtocolVersion.VERSION_1.getVersion();
        header[offset++] = flag;
        ByteUtil.long2bytes(requestId, header, offset);
        ByteUtil.int2bytes(body.length, header, offset += 8);
        byte[] data = new byte[header.length + body.length];
        System.arraycopy(header, 0, data, 0, header.length);
        System.arraycopy(body, 0, data, header.length, body.length);
        return data;
    }

    private Object decodeRequest(byte[] body, long requestId, Serialization serialization) throws IOException, ClassNotFoundException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(body);
        ObjectInput input = this.createInput(inputStream);
        String interfaceName = input.readUTF();
        String methodName = input.readUTF();
        String paramtersDesc = input.readUTF();
        DefaultRequest rpcRequest = new DefaultRequest();
        rpcRequest.setRequestId(requestId);
        rpcRequest.setInterfaceName(interfaceName);
        rpcRequest.setMethodName(methodName);
        rpcRequest.setParamtersDesc(paramtersDesc);
        rpcRequest.setArguments(this.decodeRequestParameter(input, paramtersDesc, serialization));
        rpcRequest.setAttachments(this.decodeRequestAttachments(input));
        input.close();
        return rpcRequest;
    }

    private Object[] decodeRequestParameter(ObjectInput input, String parameterDesc, Serialization serialization) throws IOException, ClassNotFoundException {
        if (parameterDesc == null || parameterDesc.equals("")) {
            return null;
        }
        Class<?>[] classTypes = ReflectUtil.forNames(parameterDesc);
        Object[] paramObjs = new Object[classTypes.length];
        for (int i = 0; i < classTypes.length; ++i) {
            paramObjs[i] = this.deserialize((byte[])input.readObject(), classTypes[i], serialization);
        }
        return paramObjs;
    }

    private Map<String, String> decodeRequestAttachments(ObjectInput input) throws IOException, ClassNotFoundException {
        int size = input.readInt();
        if (size <= 0) {
            return null;
        }
        HashMap<String, String> attachments = new HashMap<String, String>();
        for (int i = 0; i < size; ++i) {
            attachments.put(input.readUTF(), input.readUTF());
        }
        return attachments;
    }

    private Object decodeResponse(byte[] body, byte dataType, long requestId, Serialization serialization) throws IOException, ClassNotFoundException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(body);
        ObjectInput input = this.createInput(inputStream);
        long processTime = input.readLong();
        DefaultResponse response = new DefaultResponse();
        response.setRequestId(requestId);
        response.setProcessTime(processTime);
        if (dataType == 3) {
            return response;
        }
        String className = input.readUTF();
        Class<?> clz = ReflectUtil.forName(className);
        Object result = this.deserialize((byte[])input.readObject(), clz, serialization);
        if (dataType == 1) {
            response.setValue(result);
        } else if (dataType == 5) {
            response.setException((Exception)result);
        } else {
            throw new MotanFrameworkException("decode error: response dataType not support " + dataType, MotanErrorMsgConstant.FRAMEWORK_DECODE_ERROR);
        }
        response.setRequestId(requestId);
        input.close();
        return response;
    }
}

