/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.log;

import com.xiaoleilu.hutool.log.LocationAwareLog;
import com.xiaoleilu.hutool.log.Log;
import com.xiaoleilu.hutool.log.LogFactory;
import com.xiaoleilu.hutool.log.level.Level;
import com.xiaoleilu.hutool.util.StrUtil;

public final class StaticLog {
    private static final String FQCN = StaticLog.class.getName();

    private StaticLog() {
    }

    public static void trace(String format, Object ... arguments) {
        StaticLog.trace(LogFactory.indirectGet(), format, arguments);
    }

    public static void trace(Log log, String format, Object ... arguments) {
        if (!StaticLog.log(log, Level.TRACE, null, format, arguments)) {
            log.trace(format, arguments);
        }
    }

    public static void debug(String format, Object ... arguments) {
        StaticLog.debug(LogFactory.indirectGet(), format, arguments);
    }

    public static void debug(Log log, String format, Object ... arguments) {
        if (!StaticLog.log(log, Level.DEBUG, null, format, arguments)) {
            log.debug(format, arguments);
        }
    }

    public static void info(String format, Object ... arguments) {
        StaticLog.info(LogFactory.indirectGet(), format, arguments);
    }

    public static void info(Log log, String format, Object ... arguments) {
        if (!StaticLog.log(log, Level.INFO, null, format, arguments)) {
            log.info(format, arguments);
        }
    }

    public static void warn(String format, Object ... arguments) {
        StaticLog.warn(LogFactory.indirectGet(), format, arguments);
    }

    public static void warn(Log log, String format, Object ... arguments) {
        StaticLog.warn(log, null, format, arguments);
    }

    public static void warn(Throwable e, String format, Object ... arguments) {
        StaticLog.warn(LogFactory.indirectGet(), e, StrUtil.format((CharSequence)format, arguments), new Object[0]);
    }

    public static void warn(Log log, Throwable e, String format, Object ... arguments) {
        if (!StaticLog.log(log, Level.TRACE, e, format, arguments)) {
            log.warn(e, format, arguments);
        }
    }

    public static void error(Throwable e) {
        StaticLog.error(LogFactory.indirectGet(), e);
    }

    public static void error(Log log, Throwable e) {
        StaticLog.error(log, e, e.getMessage(), new Object[0]);
    }

    public static void error(String format, Object ... arguments) {
        StaticLog.error(LogFactory.indirectGet(), format, arguments);
    }

    public static void error(Log log, String format, Object ... arguments) {
        StaticLog.error(log, null, format, arguments);
    }

    public static void error(Throwable e, String format, Object ... arguments) {
        StaticLog.error(LogFactory.indirectGet(), e, format, arguments);
    }

    public static void error(Log log, Throwable e, String format, Object ... arguments) {
        if (!StaticLog.log(log, Level.ERROR, e, format, arguments)) {
            log.error(e, format, arguments);
        }
    }

    public static boolean log(Level level, Throwable t, String format, Object ... arguments) {
        return StaticLog.log(LogFactory.indirectGet(), level, t, format, arguments);
    }

    public static boolean log(Log log, Level level, Throwable t, String format, Object ... arguments) {
        if (log instanceof LocationAwareLog) {
            ((LocationAwareLog)log).log(FQCN, level, t, format, arguments);
            return true;
        }
        return false;
    }

    public static Log get(Class<?> clazz) {
        return LogFactory.get(clazz);
    }

    public static Log get(String name) {
        return LogFactory.get(name);
    }

    public static Log get() {
        return LogFactory.indirectGet();
    }
}

