/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.office.io.excel.model.impl.jxl;

import ins.framework.office.io.excel.model.Cell;
import ins.framework.office.util.Lang;
import jxl.write.DateTime;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;

class JxlCell
implements Cell {
    WritableCell cell;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cell == null ? 0 : this.cell.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JxlCell other = (JxlCell)obj;
        return !(this.cell == null ? other.cell != null : this.cell != other.cell);
    }

    public String toString() {
        return "JxlCell(cell=" + this.cell + ",row=" + this.getRow() + ",col=" + this.getColumn() + ",contents=" + this.getContents() + ")";
    }

    JxlCell(WritableCell cell) {
        this.cell = cell;
    }

    @Override
    public int getRow() {
        return this.cell.getRow();
    }

    @Override
    public int getColumn() {
        return this.cell.getColumn();
    }

    @Override
    public boolean isHidden() {
        return this.cell.isHidden();
    }

    @Override
    public String getContents() {
        return this.cell.getContents();
    }

    @Override
    public Cell copyTo(int row, int col) {
        WritableCell wc = this.cell.copyTo(col, row);
        return new JxlCell(wc);
    }

    @Override
    public Object getValue() {
        if (this.cell instanceof Label) {
            return ((Label)this.cell).getString();
        }
        if (this.cell instanceof java.lang.Number) {
            return ((Number)this.cell).getValue();
        }
        if (this.cell instanceof DateTime) {
            return ((DateTime)this.cell).getDate();
        }
        return this.cell.getContents();
    }

    @Override
    public void setValue(Object value) {
        if (this.cell instanceof Label) {
            ((Label)this.cell).setString(value.toString());
        } else if (this.cell instanceof java.lang.Number) {
            ((Number)this.cell).setValue(Lang.toNumber(value).doubleValue());
        } else if (this.cell instanceof DateTime) {
            ((DateTime)this.cell).setDate(Lang.toDate(value));
        } else {
            throw new RuntimeException("\u65e0\u6cd5\u4e3a\u8be5\u5355\u5143\u683c\u8bbe\u7f6e\u5408\u9002\u7684\u503c");
        }
    }

    @Override
    public Object getSource() {
        return this.cell;
    }
}

