/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.office.io.excel.model.impl.jxl;

import ins.framework.office.io.excel.model.Cell;
import ins.framework.office.io.excel.model.Sheet;
import ins.framework.office.io.excel.model.impl.jxl.JxlCell;
import java.util.ArrayList;
import java.util.Date;
import jxl.write.Blank;
import jxl.write.DateTime;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;

class JxlSheet
implements Sheet {
    WritableSheet sheet;

    JxlSheet(WritableSheet sheet) {
        this.sheet = sheet;
    }

    @Override
    public Cell getCell(int rowIndex, int colIndex) {
        WritableCell wc = this.sheet.getWritableCell(colIndex, rowIndex);
        return new JxlCell(wc);
    }

    @Override
    public int getRows() {
        return this.sheet.getRows();
    }

    @Override
    public int getColumns() {
        return this.sheet.getColumns();
    }

    @Override
    public Cell[] getRow(int rowIndex) {
        jxl.Cell[] cs;
        ArrayList<Cell> li = new ArrayList<Cell>();
        for (jxl.Cell c : cs = this.sheet.getRow(rowIndex)) {
            li.add(this.getCell(c.getRow(), c.getColumn()));
        }
        return li.toArray(new Cell[0]);
    }

    @Override
    public Cell[] getColumn(int colIndex) {
        jxl.Cell[] cs;
        ArrayList<Cell> li = new ArrayList<Cell>();
        for (jxl.Cell c : cs = this.sheet.getColumn(colIndex)) {
            li.add(this.getCell(c.getRow(), c.getColumn()));
        }
        return li.toArray(new Cell[0]);
    }

    @Override
    public void insertRow(int index) {
        this.sheet.insertRow(index);
    }

    @Override
    public void insertColumn(int index) {
        this.sheet.insertColumn(index);
    }

    @Override
    public void removeColumn(int index) {
        this.sheet.removeColumn(index);
    }

    @Override
    public void removeRow(int index) {
        this.sheet.removeRow(index);
    }

    Cell addCell(WritableCell cell) {
        try {
            this.sheet.addCell(cell);
            return this.getCell(cell.getRow(), cell.getColumn());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Cell addCell(String cell, int row, int col) {
        if (cell == null) {
            return this.addNull(row, col);
        }
        Label label = new Label(col, row, cell);
        return this.addCell((WritableCell)label);
    }

    @Override
    public Cell addCell(java.lang.Number cell, int row, int col) {
        if (cell == null) {
            return this.addNull(row, col);
        }
        Number number = new Number(col, row, cell.doubleValue());
        return this.addCell((WritableCell)number);
    }

    @Override
    public Cell addCell(Date cell, int row, int col) {
        if (cell == null) {
            return this.addNull(row, col);
        }
        DateTime dateTime = new DateTime(col, row, cell);
        return this.addCell((WritableCell)dateTime);
    }

    Cell addNull(int row, int col) {
        Blank blank = new Blank(col, row);
        return this.addCell((WritableCell)blank);
    }

    @Override
    public void copyRowsTo(int startRowIndex, int stopRowIndex, int targetStartRowIndex) {
        block5: {
            int i;
            block4: {
                int i2;
                if (targetStartRowIndex <= startRowIndex) break block4;
                for (i2 = stopRowIndex; i2 >= startRowIndex; --i2) {
                    this.insertRow(targetStartRowIndex);
                }
                for (i2 = stopRowIndex; i2 >= startRowIndex; --i2) {
                    int n = i2 + (targetStartRowIndex - startRowIndex);
                    Cell[] row = this.getRow(i2);
                    this.copyRowTo(row, n);
                }
                break block5;
            }
            if (targetStartRowIndex >= startRowIndex) break block5;
            for (i = startRowIndex; i <= stopRowIndex; ++i) {
                this.insertRow(targetStartRowIndex);
            }
            for (i = startRowIndex; i <= stopRowIndex; ++i) {
                int n = i + (targetStartRowIndex - startRowIndex);
                Cell[] row = this.getRow(i);
                this.copyRowTo(row, n);
            }
        }
    }

    private void copyRowTo(Cell[] row, int n) {
        if (row != null) {
            for (Cell c : row) {
                WritableCell c2 = (WritableCell)c.copyTo(n, c.getColumn()).getSource();
                this.addCell(c2);
            }
        }
    }

    @Override
    public String getName() {
        return this.sheet.getName();
    }
}

