/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.office.template.excel;

import ins.framework.office.io.excel.model.Sheet;
import ins.framework.office.io.excel.model.Workbook;
import ins.framework.office.template.excel.antlr.SheetExecutor;
import ins.framework.office.template.excel.antlr.Test;
import ins.framework.office.util.Lang;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public final class ETE {
    Workbook workbook;
    File excelFile;
    Map<String, SheetExecutor> sheetExecutorMap = new HashMap<String, SheetExecutor>();
    long lastModified;

    private ETE(File file) {
        this.excelFile = file;
        this.init();
    }

    public static ETE createETE(File file) {
        return new ETE(file);
    }

    public static ETE createETE(String path) {
        return new ETE(new File(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init() {
        this.sheetExecutorMap.clear();
        this.workbook = Workbook.getWorkbook(this.excelFile);
        this.workbook.close();
        Sheet[] sheets = this.workbook.getSheets();
        if (sheets != null) {
            for (Sheet sheet : sheets) {
                this.sheetExecutorMap.put(sheet.getName(), new SheetExecutor(sheet));
            }
        }
        this.lastModified = this.excelFile.lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(File file, Object data) {
        if (this.lastModified != this.excelFile.lastModified()) {
            this.init();
        }
        Map map = Lang.toMap(data);
        Workbook wb = this.workbook.copyTo(file);
        try {
            Sheet[] sheets = wb.getSheets();
            if (sheets != null) {
                for (Sheet sheet : sheets) {
                    this.executeSheet(sheet, map);
                }
            }
        }
        finally {
            wb.close();
        }
    }

    public void execute(String path, Object data) {
        File newFile = new File(path);
        this.execute(newFile, data);
    }

    private void executeSheet(Sheet sheet, Map<String, Object> datas) {
        SheetExecutor se = this.sheetExecutorMap.get(sheet.getName());
        se.execute(sheet, datas);
    }

    public static void main(String[] args) {
        File file = new File("/Users/lujijiang/Desktop/1.xls");
        HashMap<String, Object> datas = new HashMap<String, Object>();
        datas.put("test", new Test());
        datas.put("aa", new String[][]{{"1:for\u5faa\u73af\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5", "1:eeeeeeee"}, {"2:aaaddd", "2:dasdfsa", "2:32323"}, {"3:aaaddd"}, {"4:aaaddd", "4:sssssssssssssss"}, {"5:55555555", "5:555sssssssssssssss"}});
        ETE aet = ETE.createETE(file);
        aet.execute(new File(file.getParentFile(), "2.xls"), datas);
    }
}

