/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.office.template.excel.antlr.model;

import ins.framework.office.template.excel.antlr.SheetExecutor;
import ins.framework.office.template.excel.antlr.model.CellMeta;
import ins.framework.office.template.excel.antlr.model.ETLNode;
import ins.framework.office.template.excel.antlr.model.LELSUMNode;
import ins.framework.office.template.excel.antlr.model.SumNode;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import org.antlr.runtime.tree.BaseTree;

public class ElNode
extends ETLNode {
    public ElNode(SheetExecutor sheetExecutor, BaseTree current, ETLNode parent) {
        super(sheetExecutor, current, parent);
    }

    @Override
    protected void parseChildren() {
        List childTrees = this.current.getChildren();
        if (childTrees != null) {
            for (BaseTree childTree : childTrees) {
                if (childTree.getType() == 45) {
                    this.childs.add(new SumNode(this.sheetExecutor, childTree, this));
                    continue;
                }
                if (childTree.getType() == 25) {
                    this.childs.add(new LELSUMNode(this.sheetExecutor, childTree, this));
                    continue;
                }
                if (childTree.getType() != 9) continue;
                this.childs.add(new ElNode(this.sheetExecutor, childTree, this));
            }
        }
    }

    @Override
    public Object execute() {
        try {
            CellMeta cellMeta = this.sheetExecutor.getCell(this.startCell);
            Object value = this.value();
            if (value instanceof BigDecimal) {
                value = ((BigDecimal)value).stripTrailingZeros();
            }
            if (value instanceof BigInteger) {
                value = ((BigInteger)value).toString();
            }
            if (value instanceof Number) {
                value = new BigDecimal(value.toString()).stripTrailingZeros();
            }
            cellMeta.setValue(value);
        }
        catch (Exception e) {
            this.log.error((Object)("\u5904\u7406\u5355\u5143\u683c\uff1a" + this.getCurrentCell() + "\u65f6\u53d1\u751f\u5f02\u5e38\uff1a"), (Throwable)e);
            throw new RuntimeException(e);
        }
        return null;
    }

    public Object value() {
        ETLNode n0 = (ETLNode)this.childs.get(0);
        if (n0 instanceof SumNode) {
            return n0.execute();
        }
        Object value = ((ElNode)this.childs.get(1)).value();
        if (value != null && value instanceof Number && "-".equals(n0.getText())) {
            value = new BigDecimal(0).subtract(new BigDecimal(value.toString()));
        }
        return value;
    }
}

