/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.office.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class LazyExcelList
extends AbstractList<Object[]> {
    private String password;
    private int sheetIndex;
    private Workbook wb;
    private int totalCount = 0;
    List<Object[]> list = new ArrayList<Object[]>();

    public LazyExcelList() {
    }

    public LazyExcelList(InputStream inputStream, int sheetIndex, String password) {
        this.sheetIndex = sheetIndex;
        this.password = password;
        this.initData(inputStream, null);
    }

    public LazyExcelList(File file, int sheetIndex, String password) {
        this.sheetIndex = sheetIndex;
        this.password = password;
        this.initData(null, file);
    }

    @Override
    public Object[] get(int index) {
        Sheet sheet = this.wb.getSheetAt(this.sheetIndex);
        Row row = sheet.getRow(index);
        return this.getRowData(row);
    }

    @Override
    public int size() {
        return this.totalCount;
    }

    public void initData(InputStream inputStream, File file) {
        try {
            if (file == null) {
                this.wb = WorkbookFactory.create((InputStream)inputStream);
                inputStream.close();
            } else {
                this.wb = WorkbookFactory.create((File)file);
            }
            if (this.sheetIndex < 0) {
                this.sheetIndex = this.wb.getActiveSheetIndex();
            }
            Sheet sheet = this.wb.getSheetAt(this.sheetIndex);
            this.totalCount = sheet.getLastRowNum() + 1;
        }
        catch (InvalidFormatException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private Object[] getRowData(Row row) {
        Object[] result = new Object[]{};
        int startCellNum = 1;
        if (row != null && row.getPhysicalNumberOfCells() > 0) {
            result = new Object[row.getLastCellNum() - --startCellNum];
            for (short n = (short)startCellNum; n < row.getLastCellNum(); n = (short)(n + 1)) {
                int celltype;
                Cell cell = row.getCell((int)n);
                Object value = "";
                value = cell != null && !"".equals(cell.toString().trim()) ? ((celltype = cell.getCellType()) == 0 ? (DateUtil.isCellDateFormatted((Cell)cell) ? cell.getDateCellValue() : Double.valueOf(cell.getNumericCellValue())) : (celltype == 1 ? cell.getStringCellValue().trim() : "")) : "";
                result[n - startCellNum] = value;
            }
            ++startCellNum;
        }
        return result;
    }
}

