/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.office.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class StackTreeMap<K, V>
implements Map<K, V>,
Serializable {
    Map<K, V> parent;
    Map<K, V> current = new TreeMap();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        Iterator<K> it = this.keySet().iterator();
        while (it.hasNext()) {
            K k = it.next();
            V v = this.get(k);
            sb.append(k);
            sb.append("=");
            sb.append(v);
            if (!it.hasNext()) continue;
            sb.append(',');
        }
        sb.append('}');
        return sb.toString();
    }

    public StackTreeMap(Map<K, V> m) {
        this.parent = m;
    }

    public StackTreeMap() {
        this(null);
    }

    @Override
    public void clear() {
        this.current.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.current.containsKey(key)) {
            return true;
        }
        return this.parent != null && this.parent.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.current.containsValue(value)) {
            return true;
        }
        return this.parent != null && this.parent.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> set = new HashSet<Map.Entry<K, V>>();
        if (this.parent != null) {
            set.addAll(this.parent.entrySet());
        }
        set.addAll(this.current.entrySet());
        return set;
    }

    @Override
    public V get(Object key) {
        if (this.current.containsKey(key)) {
            return this.current.get(key);
        }
        if (this.parent != null) {
            return this.parent.get(key);
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.current.isEmpty() && (this.parent == null || this.parent.isEmpty());
    }

    @Override
    public Set<K> keySet() {
        TreeSet<K> set = new TreeSet<K>();
        if (this.parent != null) {
            set.addAll(this.parent.keySet());
        }
        set.addAll(this.current.keySet());
        return set;
    }

    @Override
    public V put(K key, V value) {
        return this.current.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.current.putAll(m);
    }

    @Override
    public V remove(Object key) {
        return this.current.remove(key);
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public Collection<V> values() {
        ArrayList<V> values = new ArrayList<V>();
        if (this.parent != null) {
            values.addAll(this.parent.values());
        }
        values.addAll(this.current.values());
        return values;
    }

    public Map<K, V> getParent() {
        return this.parent;
    }
}

