/*
 * Decompiled with CFR 0.152.
 */
package io.github.yedaxia.apidocs.parser;

import io.github.yedaxia.apidocs.consts.ChangeFlag;
import io.github.yedaxia.apidocs.parser.ControllerNode;
import io.github.yedaxia.apidocs.parser.HeaderNode;
import io.github.yedaxia.apidocs.parser.ParamNode;
import io.github.yedaxia.apidocs.parser.RequestMethod;
import io.github.yedaxia.apidocs.parser.ResponseNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RequestNode {
    private List<String> method = new ArrayList<String>();
    private String url;
    private String methodName;
    private String description;
    private String supplement;
    private List<ParamNode> paramNodes = new ArrayList<ParamNode>();
    private List<HeaderNode> header = new ArrayList<HeaderNode>();
    private Boolean deprecated = Boolean.FALSE;
    private ResponseNode responseNode;
    private ControllerNode controllerNode;
    private String androidCodePath;
    private String iosCodePath;
    private String codeFileUrl;
    private String author;
    private Byte changeFlag = ChangeFlag.SAME;
    private RequestNode lastRequestNode;

    public String getSupplement() {
        return this.supplement;
    }

    public void setSupplement(String supplement) {
        this.supplement = supplement;
    }

    public String getCodeFileUrl() {
        return this.codeFileUrl;
    }

    public void setCodeFileUrl(String codeFileUrl) {
        this.codeFileUrl = codeFileUrl;
    }

    public RequestNode getLastRequestNode() {
        return this.lastRequestNode;
    }

    public void setLastRequestNode(RequestNode lastRequestNode) {
        this.lastRequestNode = lastRequestNode;
    }

    public List<String> getMethod() {
        if (this.method == null || this.method != null && this.method.size() == 0) {
            return Arrays.asList(RequestMethod.GET.name(), RequestMethod.POST.name());
        }
        return this.method;
    }

    public void setMethod(List<String> method) {
        this.method = method;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<ParamNode> getParamNodes() {
        return this.paramNodes;
    }

    public void setParamNodes(List<ParamNode> paramNodes) {
        this.paramNodes = paramNodes;
    }

    public List<HeaderNode> getHeader() {
        return this.header;
    }

    public void setHeader(List<HeaderNode> header) {
        this.header = header;
    }

    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
    }

    public ResponseNode getResponseNode() {
        return this.responseNode;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setResponseNode(ResponseNode responseNode) {
        this.responseNode = responseNode;
    }

    public void addMethod(String method) {
        if (this.method.contains(method)) {
            return;
        }
        this.method.add(method);
    }

    public void addHeaderNode(HeaderNode headerNode) {
        this.header.add(headerNode);
    }

    public void addParamNode(ParamNode paramNode) {
        this.paramNodes.add(paramNode);
    }

    public ControllerNode getControllerNode() {
        return this.controllerNode;
    }

    public void setControllerNode(ControllerNode controllerNode) {
        this.controllerNode = controllerNode;
    }

    public ParamNode getParamNodeByName(String name) {
        for (ParamNode node : this.paramNodes) {
            if (!node.getName().equals(name)) continue;
            return node;
        }
        return null;
    }

    public String getAndroidCodePath() {
        return this.androidCodePath;
    }

    public void setAndroidCodePath(String androidCodePath) {
        this.androidCodePath = androidCodePath;
    }

    public String getIosCodePath() {
        return this.iosCodePath;
    }

    public void setIosCodePath(String iosCodePath) {
        this.iosCodePath = iosCodePath;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public byte getChangeFlag() {
        return this.changeFlag;
    }

    public void setChangeFlag(Byte changeFlag) {
        this.changeFlag = changeFlag;
    }
}

