/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.resume;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.CharsetUtil;
import io.rsocket.DuplexConnection;
import io.rsocket.RSocketErrorException;
import io.rsocket.exceptions.ConnectionCloseException;
import io.rsocket.exceptions.ConnectionErrorException;
import io.rsocket.frame.FrameHeaderCodec;
import io.rsocket.internal.UnboundedProcessor;
import io.rsocket.resume.ResumableFramesStore;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.core.publisher.Sinks;
import reactor.util.annotation.Nullable;

public class ResumableDuplexConnection
extends Flux<ByteBuf>
implements DuplexConnection,
Subscription {
    static final Logger logger = LoggerFactory.getLogger(ResumableDuplexConnection.class);
    final String side;
    final String session;
    final ResumableFramesStore resumableFramesStore;
    final UnboundedProcessor savableFramesSender;
    final Disposable framesSaverDisposable;
    final Sinks.Empty<Void> onClose;
    final SocketAddress remoteAddress;
    final Sinks.Many<Integer> onConnectionClosedSink;
    CoreSubscriber<? super ByteBuf> receiveSubscriber;
    FrameReceivingSubscriber activeReceivingSubscriber;
    volatile int state;
    static final AtomicIntegerFieldUpdater<ResumableDuplexConnection> STATE = AtomicIntegerFieldUpdater.newUpdater(ResumableDuplexConnection.class, "state");
    volatile DuplexConnection activeConnection;
    static final AtomicReferenceFieldUpdater<ResumableDuplexConnection, DuplexConnection> ACTIVE_CONNECTION = AtomicReferenceFieldUpdater.newUpdater(ResumableDuplexConnection.class, DuplexConnection.class, "activeConnection");
    int connectionIndex = 0;

    public ResumableDuplexConnection(String side, ByteBuf session, DuplexConnection initialConnection, ResumableFramesStore resumableFramesStore) {
        this.side = side;
        this.session = session.toString(CharsetUtil.UTF_8);
        this.onConnectionClosedSink = Sinks.unsafe().many().unicast().onBackpressureBuffer();
        this.resumableFramesStore = resumableFramesStore;
        this.savableFramesSender = new UnboundedProcessor();
        this.framesSaverDisposable = resumableFramesStore.saveFrames((Flux<ByteBuf>)this.savableFramesSender).subscribe();
        this.onClose = Sinks.empty();
        this.remoteAddress = initialConnection.remoteAddress();
        ACTIVE_CONNECTION.lazySet(this, initialConnection);
    }

    public boolean connect(DuplexConnection nextConnection) {
        DuplexConnection activeConnection = this.activeConnection;
        if (activeConnection != DisposedConnection.INSTANCE && ACTIVE_CONNECTION.compareAndSet(this, activeConnection, nextConnection)) {
            activeConnection.dispose();
            this.initConnection(nextConnection);
            return true;
        }
        return false;
    }

    void initConnection(DuplexConnection nextConnection) {
        int nextConnectionIndex = this.connectionIndex + 1;
        FrameReceivingSubscriber frameReceivingSubscriber = new FrameReceivingSubscriber(this.side, this.resumableFramesStore, this.receiveSubscriber);
        this.connectionIndex = nextConnectionIndex;
        this.activeReceivingSubscriber = frameReceivingSubscriber;
        if (logger.isDebugEnabled()) {
            logger.debug("Side[{}]|Session[{}]|DuplexConnection[{}]. Connecting", new Object[]{this.side, this.session, this.connectionIndex});
        }
        Disposable resumeStreamSubscription = this.resumableFramesStore.resumeStream().subscribe(f -> nextConnection.sendFrame(FrameHeaderCodec.streamId(f), (ByteBuf)f), t -> this.sendErrorAndClose(new ConnectionErrorException(t.getMessage())), () -> this.sendErrorAndClose(new ConnectionCloseException("Connection Closed Unexpectedly")));
        nextConnection.receive().subscribe((CoreSubscriber)frameReceivingSubscriber);
        nextConnection.onClose().doFinally(__ -> {
            Sinks.EmitResult result;
            frameReceivingSubscriber.dispose();
            resumeStreamSubscription.dispose();
            if (logger.isDebugEnabled()) {
                logger.debug("Side[{}]|Session[{}]|DuplexConnection[{}]. Disconnected", new Object[]{this.side, this.session, this.connectionIndex});
            }
            if (!(result = this.onConnectionClosedSink.tryEmitNext((Object)nextConnectionIndex)).equals((Object)Sinks.EmitResult.OK)) {
                logger.error("Side[{}]|Session[{}]|DuplexConnection[{}]. Failed to notify session of closed connection: {}", new Object[]{this.side, this.session, this.connectionIndex, result});
            }
        }).subscribe();
    }

    public void disconnect() {
        DuplexConnection activeConnection = this.activeConnection;
        if (activeConnection != DisposedConnection.INSTANCE) {
            activeConnection.dispose();
        }
    }

    @Override
    public void sendFrame(int streamId, ByteBuf frame) {
        if (streamId == 0) {
            this.savableFramesSender.onNextPrioritized(frame);
        } else {
            this.savableFramesSender.onNext(frame);
        }
    }

    Flux<Integer> onActiveConnectionClosed() {
        return this.onConnectionClosedSink.asFlux();
    }

    @Override
    public void sendErrorAndClose(RSocketErrorException rSocketErrorException) {
        DuplexConnection activeConnection = ACTIVE_CONNECTION.getAndSet(this, DisposedConnection.INSTANCE);
        if (activeConnection == DisposedConnection.INSTANCE) {
            return;
        }
        activeConnection.sendErrorAndClose(rSocketErrorException);
        activeConnection.onClose().subscribe(null, t -> {
            this.framesSaverDisposable.dispose();
            this.activeReceivingSubscriber.dispose();
            this.savableFramesSender.dispose();
            this.onConnectionClosedSink.tryEmitComplete();
            this.onClose.tryEmitError(t);
        }, () -> {
            this.framesSaverDisposable.dispose();
            this.activeReceivingSubscriber.dispose();
            this.savableFramesSender.dispose();
            this.onConnectionClosedSink.tryEmitComplete();
            Throwable cause = rSocketErrorException.getCause();
            if (cause == null) {
                this.onClose.tryEmitEmpty();
            } else {
                this.onClose.tryEmitError(cause);
            }
        });
    }

    @Override
    public Flux<ByteBuf> receive() {
        return this;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.activeConnection.alloc();
    }

    @Override
    public Mono<Void> onClose() {
        return this.onClose.asMono();
    }

    public void dispose() {
        this.dispose(null);
    }

    void dispose(@Nullable Throwable e) {
        DuplexConnection activeConnection = ACTIVE_CONNECTION.getAndSet(this, DisposedConnection.INSTANCE);
        if (activeConnection == DisposedConnection.INSTANCE) {
            return;
        }
        if (activeConnection != null) {
            activeConnection.dispose();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Side[{}]|Session[{}]|DuplexConnection[{}]. Disposing...", new Object[]{this.side, this.session, this.connectionIndex});
        }
        this.framesSaverDisposable.dispose();
        this.activeReceivingSubscriber.dispose();
        this.savableFramesSender.dispose();
        this.onConnectionClosedSink.tryEmitComplete();
        if (e != null) {
            this.onClose.tryEmitError(e);
        } else {
            this.onClose.tryEmitEmpty();
        }
    }

    public boolean isDisposed() {
        return (Boolean)this.onClose.scan(Scannable.Attr.TERMINATED) != false || (Boolean)this.onClose.scan(Scannable.Attr.CANCELLED) != false;
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.remoteAddress;
    }

    public void request(long n) {
        if (this.state == 1 && STATE.compareAndSet(this, 1, 2)) {
            this.initConnection(this.activeConnection);
        }
    }

    public void cancel() {
        this.dispose();
    }

    public void subscribe(CoreSubscriber<? super ByteBuf> receiverSubscriber) {
        if (this.state == 0 && STATE.compareAndSet(this, 0, 1)) {
            this.receiveSubscriber = receiverSubscriber;
            receiverSubscriber.onSubscribe((Subscription)this);
        }
    }

    static boolean isResumableFrame(ByteBuf frame) {
        return FrameHeaderCodec.streamId(frame) != 0;
    }

    private static final class FrameReceivingSubscriber
    implements CoreSubscriber<ByteBuf>,
    Disposable {
        final ResumableFramesStore resumableFramesStore;
        final CoreSubscriber<? super ByteBuf> actual;
        final String tag;
        volatile Subscription s;
        static final AtomicReferenceFieldUpdater<FrameReceivingSubscriber, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(FrameReceivingSubscriber.class, Subscription.class, "s");
        boolean cancelled;

        private FrameReceivingSubscriber(String tag, ResumableFramesStore store, CoreSubscriber<? super ByteBuf> actual) {
            this.tag = tag;
            this.resumableFramesStore = store;
            this.actual = actual;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.setOnce(S, (Object)this, (Subscription)s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(ByteBuf frame) {
            if (this.cancelled || this.s == Operators.cancelledSubscription()) {
                return;
            }
            if (ResumableDuplexConnection.isResumableFrame(frame)) {
                if (this.resumableFramesStore.resumableFrameReceived(frame)) {
                    this.actual.onNext((Object)frame);
                }
                return;
            }
            this.actual.onNext((Object)frame);
        }

        public void onError(Throwable t) {
            Operators.set(S, (Object)this, (Subscription)Operators.cancelledSubscription());
        }

        public void onComplete() {
            Operators.set(S, (Object)this, (Subscription)Operators.cancelledSubscription());
        }

        public void dispose() {
            this.cancelled = true;
            Operators.terminate(S, (Object)this);
        }

        public boolean isDisposed() {
            return this.cancelled || this.s == Operators.cancelledSubscription();
        }
    }

    private static final class DisposedConnection
    implements DuplexConnection {
        static final DisposedConnection INSTANCE = new DisposedConnection();

        private DisposedConnection() {
        }

        public void dispose() {
        }

        @Override
        public Mono<Void> onClose() {
            return Mono.never();
        }

        @Override
        public void sendFrame(int streamId, ByteBuf frame) {
        }

        @Override
        public Flux<ByteBuf> receive() {
            return Flux.never();
        }

        @Override
        public void sendErrorAndClose(RSocketErrorException e) {
        }

        @Override
        public ByteBufAllocator alloc() {
            return ByteBufAllocator.DEFAULT;
        }

        @Override
        public SocketAddress remoteAddress() {
            return null;
        }
    }
}

