/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafka.common.message.UpdateFeaturesRequestData;
import org.apache.kafka.common.message.UpdateFeaturesResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.UpdateFeaturesResponse;

public class UpdateFeaturesRequest
extends AbstractRequest {
    private final UpdateFeaturesRequestData data;

    public UpdateFeaturesRequest(UpdateFeaturesRequestData data, short version) {
        super(ApiKeys.UPDATE_FEATURES, version);
        this.data = data;
    }

    public UpdateFeaturesRequest(Struct struct, short version) {
        super(ApiKeys.UPDATE_FEATURES, version);
        this.data = new UpdateFeaturesRequestData(struct, version);
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        ApiError apiError = ApiError.fromThrowable(e);
        UpdateFeaturesResponseData.UpdatableFeatureResultCollection results = new UpdateFeaturesResponseData.UpdatableFeatureResultCollection();
        for (UpdateFeaturesRequestData.FeatureUpdateKey update : this.data.featureUpdates().valuesSet()) {
            UpdateFeaturesResponseData.UpdatableFeatureResult result = new UpdateFeaturesResponseData.UpdatableFeatureResult().setFeature(update.feature()).setErrorCode(apiError.error().code()).setErrorMessage(apiError.message());
            results.add(result);
        }
        UpdateFeaturesResponseData responseData = new UpdateFeaturesResponseData().setThrottleTimeMs(throttleTimeMs).setResults(results);
        return new UpdateFeaturesResponse(responseData);
    }

    @Override
    protected Struct toStruct() {
        return this.data.toStruct(this.version());
    }

    public UpdateFeaturesRequestData data() {
        return this.data;
    }

    public static UpdateFeaturesRequest parse(ByteBuffer buffer, short version) {
        return new UpdateFeaturesRequest(ApiKeys.UPDATE_FEATURES.parseRequest(version, buffer), version);
    }

    public static boolean isDeleteRequest(UpdateFeaturesRequestData.FeatureUpdateKey update) {
        return update.maxVersionLevel() < 1 && update.allowDowngrade();
    }

    public static class Builder
    extends AbstractRequest.Builder<UpdateFeaturesRequest> {
        private final UpdateFeaturesRequestData data;

        public Builder(UpdateFeaturesRequestData data) {
            super(ApiKeys.UPDATE_FEATURES);
            this.data = data;
        }

        @Override
        public UpdateFeaturesRequest build(short version) {
            return new UpdateFeaturesRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

