/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util;

import org.apache.wicket.util.string.PrependingStringBuffer;

public class LongEncoder {
    public static String DEFAULT = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";

    private LongEncoder() {
    }

    public static String encode(long value) {
        return LongEncoder.encode(value, DEFAULT);
    }

    public static long decode(String value) {
        return LongEncoder.decode(value, DEFAULT);
    }

    public static String encode(long value, String alphabet) {
        boolean negative;
        int len = alphabet.length() - 1;
        PrependingStringBuffer buff = new PrependingStringBuffer();
        boolean bl = negative = value < 0L;
        if (negative) {
            value = -value;
        }
        do {
            int mod = (int)(value % (long)len);
            buff.prepend(alphabet.charAt(mod));
        } while ((value /= (long)len) > 0L);
        if (negative) {
            buff.prepend(alphabet.charAt(len));
        }
        return buff.toString();
    }

    public static long decode(String value, String alphabet) {
        int factor = alphabet.length() - 1;
        boolean negative = alphabet.charAt(factor) == value.charAt(0);
        long num = 0L;
        int len = value.length();
        for (int i = negative ? 1 : 0; i < len; ++i) {
            num = num * (long)factor + (long)alphabet.indexOf(value.charAt(i));
        }
        if (negative) {
            num = -num;
        }
        return num;
    }
}

