/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc;

import java.util.List;
import org.javalite.activejdbc.CallbackListener;
import org.javalite.activejdbc.Model;
import org.javalite.activejdbc.Registry;

class CallbackSupport {
    CallbackSupport() {
    }

    void fireBeforeSave(Model m) {
        this.beforeSave();
        List<CallbackListener> listeners = Registry.instance().getListeners(m.getClass());
        for (CallbackListener listener : listeners) {
            listener.beforeSave(m);
        }
    }

    void fireAfterSave(Model m) {
        this.afterSave();
        List<CallbackListener> listeners = Registry.instance().getListeners(m.getClass());
        for (CallbackListener listener : listeners) {
            listener.afterSave(m);
        }
    }

    void fireBeforeCreate(Model m) {
        this.beforeCreate();
        List<CallbackListener> listeners = Registry.instance().getListeners(m.getClass());
        for (CallbackListener listener : listeners) {
            listener.beforeCreate(m);
        }
    }

    void fireAfterCreate(Model m) {
        this.afterCreate();
        List<CallbackListener> listeners = Registry.instance().getListeners(m.getClass());
        for (CallbackListener listener : listeners) {
            listener.afterCreate(m);
        }
    }

    void fireBeforeDelete(Model m) {
        this.beforeDelete();
        List<CallbackListener> listeners = Registry.instance().getListeners(m.getClass());
        for (CallbackListener listener : listeners) {
            listener.beforeDelete(m);
        }
    }

    void fireAfterDelete(Model m) {
        this.afterDelete();
        List<CallbackListener> listeners = Registry.instance().getListeners(m.getClass());
        for (CallbackListener listener : listeners) {
            listener.afterDelete(m);
        }
    }

    void fireBeforeValidation(Model m) {
        this.beforeValidation();
        List<CallbackListener> listeners = Registry.instance().getListeners(m.getClass());
        for (CallbackListener listener : listeners) {
            listener.beforeValidation(m);
        }
    }

    void fireAfterValidation(Model m) {
        this.afterValidation();
        List<CallbackListener> listeners = Registry.instance().getListeners(m.getClass());
        for (CallbackListener listener : listeners) {
            listener.afterValidation(m);
        }
    }

    protected void beforeSave() {
    }

    protected void afterSave() {
    }

    protected void beforeCreate() {
    }

    protected void afterCreate() {
    }

    protected void beforeDelete() {
    }

    protected void afterDelete() {
    }

    protected void beforeValidation() {
    }

    protected void afterValidation() {
    }
}

