/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web;

import java.util.Arrays;
import java.util.List;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import javax.servlet.ServletRegistration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.web.EmbeddedServletContainerAutoConfiguration;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.WebMvcProperties;
import org.springframework.boot.context.embedded.ServletRegistrationBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.servlet.DispatcherServlet;

@AutoConfigureOrder(value=-2147483648)
@Configuration
@ConditionalOnWebApplication
@ConditionalOnClass(value={DispatcherServlet.class})
@AutoConfigureAfter(value={EmbeddedServletContainerAutoConfiguration.class})
public class DispatcherServletAutoConfiguration {
    public static final String DEFAULT_DISPATCHER_SERVLET_BEAN_NAME = "dispatcherServlet";
    public static final String DEFAULT_DISPATCHER_SERVLET_REGISTRATION_BEAN_NAME = "dispatcherServletRegistration";

    @Order(value=0x7FFFFFF5)
    private static class DefaultDispatcherServletCondition
    extends SpringBootCondition {
        private DefaultDispatcherServletCondition() {
        }

        @Override
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
            ConditionOutcome outcome = this.checkServlets(beanFactory);
            if (!outcome.isMatch()) {
                return outcome;
            }
            return this.checkServletRegistrations(beanFactory);
        }

        private ConditionOutcome checkServlets(ConfigurableListableBeanFactory beanFactory) {
            List<String> servlets = Arrays.asList(beanFactory.getBeanNamesForType(DispatcherServlet.class, false, false));
            boolean containsDispatcherBean = beanFactory.containsBean(DispatcherServletAutoConfiguration.DEFAULT_DISPATCHER_SERVLET_BEAN_NAME);
            if (servlets.isEmpty()) {
                if (containsDispatcherBean) {
                    return ConditionOutcome.noMatch("found no DispatcherServlet but a non-DispatcherServlet named dispatcherServlet");
                }
                return ConditionOutcome.match("no DispatcherServlet found");
            }
            if (servlets.contains(DispatcherServletAutoConfiguration.DEFAULT_DISPATCHER_SERVLET_BEAN_NAME)) {
                return ConditionOutcome.noMatch("found DispatcherServlet named dispatcherServlet");
            }
            if (containsDispatcherBean) {
                return ConditionOutcome.noMatch("found non-DispatcherServlet named dispatcherServlet");
            }
            return ConditionOutcome.match("one or more DispatcherServlets found and none is named dispatcherServlet");
        }

        private ConditionOutcome checkServletRegistrations(ConfigurableListableBeanFactory beanFactory) {
            List<String> registrations = Arrays.asList(beanFactory.getBeanNamesForType(ServletRegistrationBean.class, false, false));
            boolean containsDispatcherRegistrationBean = beanFactory.containsBean(DispatcherServletAutoConfiguration.DEFAULT_DISPATCHER_SERVLET_REGISTRATION_BEAN_NAME);
            if (registrations.isEmpty()) {
                if (containsDispatcherRegistrationBean) {
                    return ConditionOutcome.noMatch("found no ServletRegistrationBean but a non-ServletRegistrationBean named dispatcherServletRegistration");
                }
                return ConditionOutcome.match("no ServletRegistrationBean found");
            }
            if (registrations.contains(DispatcherServletAutoConfiguration.DEFAULT_DISPATCHER_SERVLET_REGISTRATION_BEAN_NAME)) {
                return ConditionOutcome.noMatch("found ServletRegistrationBean named dispatcherServletRegistration");
            }
            if (containsDispatcherRegistrationBean) {
                return ConditionOutcome.noMatch("found non-ServletRegistrationBean named dispatcherServletRegistration");
            }
            return ConditionOutcome.match("one or more ServletRegistrationBeans is found and none is named dispatcherServletRegistration");
        }
    }

    @Configuration
    @Conditional(value={DefaultDispatcherServletCondition.class})
    @ConditionalOnClass(value={ServletRegistration.class})
    @EnableConfigurationProperties(value={WebMvcProperties.class})
    protected static class DispatcherServletConfiguration {
        @Autowired
        private ServerProperties server;
        @Autowired
        private WebMvcProperties webMvcProperties;
        @Autowired(required=false)
        private MultipartConfigElement multipartConfig;

        protected DispatcherServletConfiguration() {
        }

        @Bean(name={"dispatcherServlet"})
        public DispatcherServlet dispatcherServlet() {
            DispatcherServlet dispatcherServlet = new DispatcherServlet();
            dispatcherServlet.setDispatchOptionsRequest(this.webMvcProperties.isDispatchOptionsRequest());
            dispatcherServlet.setDispatchTraceRequest(this.webMvcProperties.isDispatchTraceRequest());
            dispatcherServlet.setThrowExceptionIfNoHandlerFound(this.webMvcProperties.isThrowExceptionIfNoHandlerFound());
            return dispatcherServlet;
        }

        @Bean(name={"dispatcherServletRegistration"})
        public ServletRegistrationBean dispatcherServletRegistration() {
            ServletRegistrationBean registration = new ServletRegistrationBean((Servlet)this.dispatcherServlet(), new String[]{this.server.getServletMapping()});
            registration.setName(DispatcherServletAutoConfiguration.DEFAULT_DISPATCHER_SERVLET_BEAN_NAME);
            if (this.multipartConfig != null) {
                registration.setMultipartConfig(this.multipartConfig);
            }
            return registration;
        }

        @Bean
        @ConditionalOnBean(value={MultipartResolver.class})
        @ConditionalOnMissingBean(name={"multipartResolver"})
        public MultipartResolver multipartResolver(MultipartResolver resolver) {
            return resolver;
        }
    }
}

