/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.sentinel.datasource;

import com.alibaba.csp.sentinel.datasource.ReadableDataSource;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class DataSourceLoader {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceLoader.class);
    private static final String PROPERTIES_RESOURCE_LOCATION = "META-INF/sentinel-datasource.properties";
    private static final String ALL_PROPERTIES_RESOURCES_LOCATION = "classpath*:META-INF/sentinel-datasource.properties";
    private static final ConcurrentMap<String, Class<? extends ReadableDataSource>> dataSourceClassesCache = new ConcurrentHashMap<String, Class<? extends ReadableDataSource>>(4);

    static void loadAllDataSourceClassesCache() {
        Map<String, Class<? extends ReadableDataSource>> dataSourceClassesMap = DataSourceLoader.loadAllDataSourceClassesCache(ALL_PROPERTIES_RESOURCES_LOCATION);
        dataSourceClassesCache.putAll(dataSourceClassesMap);
    }

    static Map<String, Class<? extends ReadableDataSource>> loadAllDataSourceClassesCache(String resourcesLocation) {
        HashMap<String, Class<? extends ReadableDataSource>> dataSourcesMap;
        block5: {
            dataSourcesMap = new HashMap<String, Class<? extends ReadableDataSource>>(4);
            ClassLoader classLoader = DataSourceLoader.class.getClassLoader();
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            try {
                Resource[] resources;
                for (Resource resource : resources = resolver.getResources(resourcesLocation)) {
                    if (!resource.exists()) continue;
                    Properties properties = PropertiesLoaderUtils.loadProperties((Resource)resource);
                    for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                        String type = (String)entry.getKey();
                        String className = (String)entry.getValue();
                        if (!ClassUtils.isPresent((String)className, (ClassLoader)classLoader)) {
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug("Sentinel DataSource implementation [ type : " + type + ": , class : " + className + " , url : " + resource.getURL() + "] was not present in current classpath , thus loading will be ignored , please add dependency if required !");
                            continue;
                        }
                        Assert.isTrue((!dataSourcesMap.containsKey(type) ? 1 : 0) != 0, (String)("The duplicated type[" + type + "] of SentinelDataSource were found in resource [" + resource.getURL() + "]"));
                        Class dataSourceClass = ClassUtils.resolveClassName((String)className, (ClassLoader)classLoader);
                        Assert.isAssignable(ReadableDataSource.class, (Class)dataSourceClass);
                        dataSourcesMap.put(type, dataSourceClass);
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("Sentinel DataSource implementation [ type : " + type + ": , class : " + className + "] was loaded.");
                    }
                }
            }
            catch (IOException e) {
                if (!logger.isErrorEnabled()) break block5;
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return dataSourcesMap;
    }

    public static Class<? extends ReadableDataSource> loadClass(String type) throws IllegalArgumentException {
        Class dataSourceClass = (Class)dataSourceClassesCache.get(type);
        if (dataSourceClass == null && dataSourceClassesCache.isEmpty()) {
            DataSourceLoader.loadAllDataSourceClassesCache();
            dataSourceClass = (Class)dataSourceClassesCache.get(type);
        }
        if (dataSourceClass == null) {
            throw new IllegalArgumentException("Sentinel DataSource implementation [ type : " + type + " ] can't be found!");
        }
        return dataSourceClass;
    }
}

