/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Slice;
import org.springframework.data.elasticsearch.core.GetResultMapper;
import org.springframework.data.elasticsearch.core.MultiGetResultMapper;
import org.springframework.data.elasticsearch.core.ResultsExtractor;
import org.springframework.data.elasticsearch.core.ScrolledPage;
import org.springframework.data.elasticsearch.core.SearchResultMapper;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.query.AliasQuery;
import org.springframework.data.elasticsearch.core.query.BulkOptions;
import org.springframework.data.elasticsearch.core.query.CriteriaQuery;
import org.springframework.data.elasticsearch.core.query.DeleteQuery;
import org.springframework.data.elasticsearch.core.query.GetQuery;
import org.springframework.data.elasticsearch.core.query.IndexQuery;
import org.springframework.data.elasticsearch.core.query.MoreLikeThisQuery;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.data.elasticsearch.core.query.StringQuery;
import org.springframework.data.elasticsearch.core.query.UpdateQuery;
import org.springframework.data.util.CloseableIterator;
import org.springframework.lang.Nullable;

public interface ElasticsearchOperations {
    public boolean addAlias(AliasQuery var1);

    public boolean removeAlias(AliasQuery var1);

    public <T> boolean createIndex(Class<T> var1);

    public boolean createIndex(String var1);

    public boolean createIndex(String var1, Object var2);

    public <T> boolean createIndex(Class<T> var1, Object var2);

    public <T> boolean putMapping(Class<T> var1);

    public <T> boolean putMapping(String var1, String var2, Class<T> var3);

    public boolean putMapping(String var1, String var2, Object var3);

    public <T> boolean putMapping(Class<T> var1, Object var2);

    public <T> Map<String, Object> getMapping(Class<T> var1);

    public Map<String, Object> getMapping(String var1, String var2);

    public Map<String, Object> getSetting(String var1);

    public <T> Map<String, Object> getSetting(Class<T> var1);

    public List<AliasMetaData> queryForAlias(String var1);

    public <T> T query(SearchQuery var1, ResultsExtractor<T> var2);

    public <T> T queryForObject(GetQuery var1, Class<T> var2);

    public <T> T queryForObject(GetQuery var1, Class<T> var2, GetResultMapper var3);

    public <T> T queryForObject(CriteriaQuery var1, Class<T> var2);

    public <T> T queryForObject(StringQuery var1, Class<T> var2);

    public <T> Page<T> queryForPage(SearchQuery var1, Class<T> var2);

    public <T> Page<T> queryForPage(SearchQuery var1, Class<T> var2, SearchResultMapper var3);

    public <T> List<Page<T>> queryForPage(List<SearchQuery> var1, Class<T> var2);

    public <T> List<Page<T>> queryForPage(List<SearchQuery> var1, Class<T> var2, SearchResultMapper var3);

    public List<Page<?>> queryForPage(List<SearchQuery> var1, List<Class<?>> var2);

    public List<Page<?>> queryForPage(List<SearchQuery> var1, List<Class<?>> var2, SearchResultMapper var3);

    public <T> Page<T> queryForPage(CriteriaQuery var1, Class<T> var2);

    public <T> Page<T> queryForPage(StringQuery var1, Class<T> var2);

    public <T> Page<T> queryForPage(StringQuery var1, Class<T> var2, SearchResultMapper var3);

    public <T> CloseableIterator<T> stream(CriteriaQuery var1, Class<T> var2);

    public <T> CloseableIterator<T> stream(SearchQuery var1, Class<T> var2);

    public <T> CloseableIterator<T> stream(SearchQuery var1, Class<T> var2, SearchResultMapper var3);

    public <T> List<T> queryForList(CriteriaQuery var1, Class<T> var2);

    public <T> List<T> queryForList(StringQuery var1, Class<T> var2);

    public <T> List<T> queryForList(SearchQuery var1, Class<T> var2);

    default public <T> List<List<T>> queryForList(List<SearchQuery> queries, Class<T> clazz) {
        return this.queryForPage(queries, clazz).stream().map(Slice::getContent).collect(Collectors.toList());
    }

    default public List<List<?>> queryForList(List<SearchQuery> queries, List<Class<?>> classes) {
        return this.queryForPage(queries, classes).stream().map(Slice::getContent).collect(Collectors.toList());
    }

    public <T> List<String> queryForIds(SearchQuery var1);

    public <T> long count(CriteriaQuery var1, Class<T> var2);

    public <T> long count(CriteriaQuery var1);

    public <T> long count(SearchQuery var1, Class<T> var2);

    public <T> long count(SearchQuery var1);

    public <T> List<T> multiGet(SearchQuery var1, Class<T> var2);

    public <T> List<T> multiGet(SearchQuery var1, Class<T> var2, MultiGetResultMapper var3);

    public String index(IndexQuery var1);

    public UpdateResponse update(UpdateQuery var1);

    default public void bulkIndex(List<IndexQuery> queries) {
        this.bulkIndex(queries, BulkOptions.defaultOptions());
    }

    public void bulkIndex(List<IndexQuery> var1, BulkOptions var2);

    default public void bulkUpdate(List<UpdateQuery> queries) {
        this.bulkUpdate(queries, BulkOptions.defaultOptions());
    }

    public void bulkUpdate(List<UpdateQuery> var1, BulkOptions var2);

    public String delete(String var1, String var2, String var3);

    public <T> void delete(CriteriaQuery var1, Class<T> var2);

    public <T> String delete(Class<T> var1, String var2);

    public <T> void delete(DeleteQuery var1, Class<T> var2);

    public void delete(DeleteQuery var1);

    public <T> boolean deleteIndex(Class<T> var1);

    public boolean deleteIndex(String var1);

    public <T> boolean indexExists(Class<T> var1);

    public boolean indexExists(String var1);

    public boolean typeExists(String var1, String var2);

    public void refresh(String var1);

    public <T> void refresh(Class<T> var1);

    public <T> ScrolledPage<T> startScroll(long var1, SearchQuery var3, Class<T> var4);

    public <T> ScrolledPage<T> startScroll(long var1, SearchQuery var3, Class<T> var4, SearchResultMapper var5);

    public <T> ScrolledPage<T> startScroll(long var1, CriteriaQuery var3, Class<T> var4);

    public <T> ScrolledPage<T> startScroll(long var1, CriteriaQuery var3, Class<T> var4, SearchResultMapper var5);

    public <T> ScrolledPage<T> continueScroll(@Nullable String var1, long var2, Class<T> var4);

    public <T> ScrolledPage<T> continueScroll(@Nullable String var1, long var2, Class<T> var4, SearchResultMapper var5);

    public <T> void clearScroll(String var1);

    public <T> Page<T> moreLikeThis(MoreLikeThisQuery var1, Class<T> var2);

    public ElasticsearchPersistentEntity getPersistentEntityFor(Class var1);

    public ElasticsearchConverter getElasticsearchConverter();
}

