/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.target.EmptyTargetSource;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.cglib.core.NamingPolicy;
import org.springframework.cglib.core.SpringNamingPolicy;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.Factory;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.objenesis.ObjenesisStd;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PathMatcher;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.method.annotation.RequestParamMethodArgumentResolver;
import org.springframework.web.method.support.CompositeUriComponentsContributor;
import org.springframework.web.method.support.UriComponentsContributor;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.mvc.method.annotation.PathVariableMethodArgumentResolver;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class MvcUriComponentsBuilder
extends UriComponentsBuilder {
    public static final String MVC_URI_COMPONENTS_CONTRIBUTOR_BEAN_NAME = "mvcUriComponentsContributor";
    private static final Log logger = LogFactory.getLog(MvcUriComponentsBuilder.class);
    private static final ObjenesisStd objenesis = new ObjenesisStd(true);
    private static final PathMatcher pathMatcher = new AntPathMatcher();
    private static final ParameterNameDiscoverer parameterNameDiscoverer = new DefaultParameterNameDiscoverer();
    private static final CompositeUriComponentsContributor defaultUriComponentsContributor = new CompositeUriComponentsContributor(new UriComponentsContributor[]{new PathVariableMethodArgumentResolver(), new RequestParamMethodArgumentResolver(false)});

    public static UriComponentsBuilder fromController(Class<?> controllerType) {
        String mapping = MvcUriComponentsBuilder.getTypeRequestMapping(controllerType);
        return ServletUriComponentsBuilder.fromCurrentServletMapping().path(mapping);
    }

    private static String getTypeRequestMapping(Class<?> controllerType) {
        Assert.notNull(controllerType, (String)"'controllerType' must not be null");
        RequestMapping annot = (RequestMapping)AnnotationUtils.findAnnotation(controllerType, RequestMapping.class);
        if (annot == null || ObjectUtils.isEmpty((Object[])annot.value()) || StringUtils.isEmpty((Object)annot.value()[0])) {
            return "/";
        }
        if (annot.value().length > 1 && logger.isWarnEnabled()) {
            logger.warn((Object)("Multiple paths on controller " + controllerType.getName() + ", using first one"));
        }
        return annot.value()[0];
    }

    public static UriComponentsBuilder fromMethodName(Class<?> controllerType, String methodName, Object ... argumentValues) {
        Method method = MvcUriComponentsBuilder.getMethod(controllerType, methodName, argumentValues);
        return MvcUriComponentsBuilder.fromMethod(method, argumentValues);
    }

    private static Method getMethod(Class<?> controllerType, String methodName, Object[] argumentValues) {
        Method match = null;
        for (Method method : controllerType.getDeclaredMethods()) {
            if (!method.getName().equals(methodName) || method.getParameterTypes().length != argumentValues.length) continue;
            if (match != null) {
                throw new IllegalStateException("Found two methods named '" + methodName + "' having " + Arrays.asList(argumentValues) + " arguments, controller " + controllerType.getName());
            }
            match = method;
        }
        if (match == null) {
            throw new IllegalArgumentException("No method '" + methodName + "' with " + argumentValues.length + " parameters found in " + controllerType.getName());
        }
        return match;
    }

    public static UriComponentsBuilder fromMethodCall(Object invocationInfo) {
        Assert.isInstanceOf(MethodInvocationInfo.class, (Object)invocationInfo);
        MethodInvocationInfo info = (MethodInvocationInfo)invocationInfo;
        return MvcUriComponentsBuilder.fromMethod(info.getControllerMethod(), info.getArgumentValues());
    }

    public static UriComponentsBuilder fromMethod(Method method, Object ... argumentValues) {
        String typePath = MvcUriComponentsBuilder.getTypeRequestMapping(method.getDeclaringClass());
        String methodPath = MvcUriComponentsBuilder.getMethodRequestMapping(method);
        String path = pathMatcher.combine(typePath, methodPath);
        UriComponentsBuilder builder = ServletUriComponentsBuilder.fromCurrentServletMapping().path(path);
        UriComponents uriComponents = MvcUriComponentsBuilder.applyContributors(builder, method, argumentValues);
        return ServletUriComponentsBuilder.newInstance().uriComponents(uriComponents);
    }

    private static String getMethodRequestMapping(Method method) {
        RequestMapping annot = (RequestMapping)AnnotationUtils.findAnnotation((Method)method, RequestMapping.class);
        Assert.notNull((Object)annot, (String)("No @RequestMapping on: " + method.toGenericString()));
        if (ObjectUtils.isEmpty((Object[])annot.value()) || StringUtils.isEmpty((Object)annot.value()[0])) {
            return "/";
        }
        if (annot.value().length > 1 && logger.isWarnEnabled()) {
            logger.warn((Object)("Multiple paths on method " + method.toGenericString() + ", using first one"));
        }
        return annot.value()[0];
    }

    private static UriComponents applyContributors(UriComponentsBuilder builder, Method method, Object[] args) {
        int argCount;
        int paramCount;
        CompositeUriComponentsContributor contributor = MvcUriComponentsBuilder.getConfiguredUriComponentsContributor();
        if (contributor == null) {
            logger.debug((Object)"Using default CompositeUriComponentsContributor");
            contributor = defaultUriComponentsContributor;
        }
        Assert.isTrue(((paramCount = method.getParameterTypes().length) == (argCount = args.length) ? 1 : 0) != 0, (String)("Number of method parameters " + paramCount + " does not match number of argument values " + argCount));
        final HashMap uriVars = new HashMap();
        for (int i = 0; i < paramCount; ++i) {
            MethodParameter param = new MethodParameter(method, i);
            param.initParameterNameDiscovery(parameterNameDiscoverer);
            contributor.contributeMethodArgument(param, args[i], builder, uriVars);
        }
        return builder.build().expand(new UriComponents.UriTemplateVariables(){

            public Object getValue(String name) {
                return uriVars.containsKey(name) ? uriVars.get(name) : UriComponents.UriTemplateVariables.SKIP_VALUE;
            }
        });
    }

    protected static CompositeUriComponentsContributor getConfiguredUriComponentsContributor() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            logger.debug((Object)"No request bound to the current thread: is DispatcherSerlvet used?");
            return null;
        }
        HttpServletRequest request = ((ServletRequestAttributes)requestAttributes).getRequest();
        if (request == null) {
            logger.debug((Object)"Request bound to current thread is not an HttpServletRequest");
            return null;
        }
        String attributeName = DispatcherServlet.WEB_APPLICATION_CONTEXT_ATTRIBUTE;
        WebApplicationContext wac = (WebApplicationContext)request.getAttribute(attributeName);
        if (wac == null) {
            logger.debug((Object)"No WebApplicationContext found: not in a DispatcherServlet request?");
            return null;
        }
        try {
            return (CompositeUriComponentsContributor)wac.getBean(MVC_URI_COMPONENTS_CONTRIBUTOR_BEAN_NAME, CompositeUriComponentsContributor.class);
        }
        catch (NoSuchBeanDefinitionException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No CompositeUriComponentsContributor bean with name 'mvcUriComponentsContributor'");
            }
            return null;
        }
    }

    public static <T> T on(Class<T> controllerType) {
        return MvcUriComponentsBuilder.controller(controllerType);
    }

    public static <T> T controller(Class<T> controllerType) {
        Assert.notNull(controllerType, (String)"'controllerType' must not be null");
        return MvcUriComponentsBuilder.initProxy(controllerType, new ControllerMethodInvocationInterceptor());
    }

    private static <T> T initProxy(Class<?> type, ControllerMethodInvocationInterceptor interceptor) {
        if (type.isInterface()) {
            ProxyFactory factory = new ProxyFactory((Object)EmptyTargetSource.INSTANCE);
            factory.addInterface(type);
            factory.addInterface(MethodInvocationInfo.class);
            factory.addAdvice((Advice)interceptor);
            return (T)factory.getProxy();
        }
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(type);
        enhancer.setInterfaces(new Class[]{MethodInvocationInfo.class});
        enhancer.setNamingPolicy((NamingPolicy)SpringNamingPolicy.INSTANCE);
        enhancer.setCallbackType(MethodInterceptor.class);
        Factory factory = (Factory)objenesis.newInstance(enhancer.createClass());
        factory.setCallbacks(new Callback[]{interceptor});
        return (T)factory;
    }

    public static interface MethodInvocationInfo {
        public Method getControllerMethod();

        public Object[] getArgumentValues();
    }

    private static class ControllerMethodInvocationInterceptor
    implements MethodInterceptor,
    org.aopalliance.intercept.MethodInterceptor {
        private static final Method getControllerMethod = ReflectionUtils.findMethod(MethodInvocationInfo.class, (String)"getControllerMethod");
        private static final Method getArgumentValues = ReflectionUtils.findMethod(MethodInvocationInfo.class, (String)"getArgumentValues");
        private Method controllerMethod;
        private Object[] argumentValues;

        private ControllerMethodInvocationInterceptor() {
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) {
            if (getControllerMethod.equals(method)) {
                return this.controllerMethod;
            }
            if (getArgumentValues.equals(method)) {
                return this.argumentValues;
            }
            if (ReflectionUtils.isObjectMethod((Method)method)) {
                return ReflectionUtils.invokeMethod((Method)method, (Object)obj, (Object[])args);
            }
            this.controllerMethod = method;
            this.argumentValues = args;
            Class<?> returnType = method.getReturnType();
            return Void.TYPE.equals(returnType) ? null : returnType.cast(MvcUriComponentsBuilder.initProxy(returnType, this));
        }

        public Object invoke(MethodInvocation inv) throws Throwable {
            return this.intercept(inv.getThis(), inv.getMethod(), inv.getArguments(), null);
        }
    }
}

