/*
 * Decompiled with CFR 0.152.
 */
package tachyon;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import tachyon.Constants;
import tachyon.UnderFileSystem;
import tachyon.UserInfo;
import tachyon.conf.CommonConf;
import tachyon.util.CommonUtils;

public class Users {
    public static final int sDATASERVER_USER_ID = -1;
    public static final int sCHECKPOINT_USER_ID = -2;
    private final Logger LOG = Logger.getLogger((String)Constants.LOGGER_TYPE);
    private final String USER_FOLDER;
    private final String USER_UNDERFS_FOLDER;
    private final Map<Long, UserInfo> USERS;

    public Users(String userfolder, String userUnderfsFolder) {
        this.USER_FOLDER = userfolder;
        this.USER_UNDERFS_FOLDER = userUnderfsFolder;
        this.USERS = new HashMap<Long, UserInfo>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOwnBytes(long userId, long newBytes) {
        UserInfo tUser = null;
        Map<Long, UserInfo> map = this.USERS;
        synchronized (map) {
            this.userHeartbeat(userId);
            tUser = this.USERS.get(userId);
        }
        tUser.addOwnBytes(newBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long ownBytes(long userId) {
        Map<Long, UserInfo> map = this.USERS;
        synchronized (map) {
            UserInfo tUser = this.USERS.get(userId);
            return tUser == null ? 0L : tUser.getOwnBytes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> checkStatus() {
        this.LOG.debug((Object)"Worker is checking all users' status.");
        ArrayList<Long> ret = new ArrayList<Long>();
        Map<Long, UserInfo> map = this.USERS;
        synchronized (map) {
            for (Map.Entry<Long, UserInfo> entry : this.USERS.entrySet()) {
                if (!entry.getValue().timeout()) continue;
                ret.add(entry.getKey());
            }
        }
        return ret;
    }

    public String getUserTempFolder(long userId) {
        return this.USER_FOLDER + "/" + userId;
    }

    public String getUserUnderfsTempFolder(long userId) {
        return this.USER_UNDERFS_FOLDER + "/" + userId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long removeUser(long userId) {
        StringBuilder sb = new StringBuilder("Trying to cleanup user " + userId + " : ");
        UserInfo tUser = null;
        Map<Long, UserInfo> map = this.USERS;
        synchronized (map) {
            tUser = this.USERS.get(userId);
            this.USERS.remove(userId);
        }
        long returnedBytes = 0L;
        if (tUser == null) {
            returnedBytes = 0L;
            sb.append(" The user does not exist in the worker's current user pool.");
        } else {
            returnedBytes = tUser.getOwnBytes();
            String folder = this.getUserTempFolder(userId);
            sb.append(" The user returns " + returnedBytes + " bytes. Remove the user's folder " + folder + " ;");
            try {
                FileUtils.deleteDirectory((File)new File(folder));
            }
            catch (IOException e) {
                CommonUtils.runtimeException(e);
            }
            folder = this.getUserUnderfsTempFolder(userId);
            sb.append(" Also remove users underfs folder " + folder);
            try {
                UnderFileSystem.get(CommonConf.get().UNDERFS_ADDRESS).delete(folder, true);
            }
            catch (IOException e) {
                this.LOG.error((Object)e);
            }
        }
        this.LOG.info((Object)sb.toString());
        return returnedBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userHeartbeat(long userId) {
        Map<Long, UserInfo> map = this.USERS;
        synchronized (map) {
            if (this.USERS.containsKey(userId)) {
                this.USERS.get(userId).heartbeat();
            } else {
                this.USERS.put(userId, new UserInfo(userId));
            }
        }
    }
}

