/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client;

import java.io.IOException;
import tachyon.client.BlockInStream;
import tachyon.client.InStream;
import tachyon.client.ReadType;
import tachyon.client.TachyonFile;

public class FileInStream
extends InStream {
    private final long FILE_LENGTH;
    private final long BLOCK_CAPACITY;
    private long mCurrentPosition;
    private int mCurrentBlockIndex;
    private BlockInStream mCurrentBlockInStream;
    private long mCurrentBlockLeft;
    private boolean mClosed = false;

    public FileInStream(TachyonFile file, ReadType opType) throws IOException {
        super(file, opType);
        this.FILE_LENGTH = file.length();
        this.BLOCK_CAPACITY = file.getBlockSizeByte();
        this.mCurrentPosition = 0L;
        this.mCurrentBlockIndex = -1;
        this.mCurrentBlockInStream = null;
        this.mCurrentBlockLeft = 0L;
    }

    private int getCurrentBlockIndex() {
        return (int)(this.mCurrentPosition / this.BLOCK_CAPACITY);
    }

    private void checkAndAdvanceBlockInStream() throws IOException {
        if (this.mCurrentBlockLeft == 0L) {
            if (this.mCurrentBlockInStream != null) {
                this.mCurrentBlockInStream.close();
            }
            this.mCurrentBlockIndex = this.getCurrentBlockIndex();
            this.mCurrentBlockInStream = BlockInStream.get(this.FILE, this.READ_TYPE, this.mCurrentBlockIndex);
            this.mCurrentBlockLeft = this.BLOCK_CAPACITY;
        }
    }

    @Override
    public int read() throws IOException {
        if (this.mCurrentPosition >= this.FILE_LENGTH) {
            return -1;
        }
        this.checkAndAdvanceBlockInStream();
        ++this.mCurrentPosition;
        --this.mCurrentBlockLeft;
        return this.mCurrentBlockInStream.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int tOff = off;
        int tLen = len;
        while (tLen > 0 && this.mCurrentPosition < this.FILE_LENGTH) {
            this.checkAndAdvanceBlockInStream();
            int tRead = this.mCurrentBlockInStream.read(b, tOff, tLen);
            if (tRead == -1) continue;
            this.mCurrentPosition += (long)tRead;
            this.mCurrentBlockLeft -= (long)tRead;
            tLen -= tRead;
            tOff += tRead;
        }
        return len - tLen;
    }

    @Override
    public void close() throws IOException {
        if (!this.mClosed && this.mCurrentBlockInStream != null) {
            this.mCurrentBlockInStream.close();
        }
        this.mClosed = true;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        long ret = n;
        if (this.mCurrentPosition + n >= this.FILE.length()) {
            ret = this.FILE.length() - this.mCurrentPosition;
            this.mCurrentPosition += ret;
        } else {
            this.mCurrentPosition += n;
        }
        int tBlockIndex = (int)(this.mCurrentPosition / this.BLOCK_CAPACITY);
        if (tBlockIndex != this.mCurrentBlockIndex) {
            if (this.mCurrentBlockInStream != null) {
                this.mCurrentBlockInStream.close();
            }
            this.mCurrentBlockIndex = tBlockIndex;
            this.mCurrentBlockInStream = BlockInStream.get(this.FILE, this.READ_TYPE, this.mCurrentBlockIndex);
            long shouldSkip = this.mCurrentPosition % this.BLOCK_CAPACITY;
            long skip = this.mCurrentBlockInStream.skip(shouldSkip);
            this.mCurrentBlockLeft = this.BLOCK_CAPACITY - skip;
            if (skip != shouldSkip) {
                throw new IOException("The underlayer BlockInStream only skip " + skip + " instead of " + shouldSkip);
            }
        } else {
            long skip = this.mCurrentBlockInStream.skip(ret);
            if (skip != ret) {
                throw new IOException("The underlayer BlockInStream only skip " + skip + " instead of " + ret);
            }
        }
        return ret;
    }

    @Override
    public void seek(long pos) throws IOException {
        if (this.mCurrentPosition == pos) {
            return;
        }
        if (pos < 0L) {
            throw new IOException("pos is negative: " + pos);
        }
        if ((int)(pos / this.BLOCK_CAPACITY) != this.mCurrentBlockIndex) {
            this.mCurrentBlockIndex = (int)(pos / this.BLOCK_CAPACITY);
            if (this.mCurrentBlockInStream != null) {
                this.mCurrentBlockInStream.close();
            }
            this.mCurrentBlockInStream = BlockInStream.get(this.FILE, this.READ_TYPE, this.mCurrentBlockIndex);
        }
        this.mCurrentBlockInStream.seek(pos % this.BLOCK_CAPACITY);
        this.mCurrentPosition = pos;
        this.mCurrentBlockLeft = this.BLOCK_CAPACITY - pos % this.BLOCK_CAPACITY;
    }
}

