/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import tachyon.Constants;
import tachyon.UnderFileSystem;
import tachyon.client.TachyonByteBuffer;
import tachyon.client.TachyonFile;
import tachyon.client.table.RawTable;
import tachyon.conf.UserConf;
import tachyon.master.MasterClient;
import tachyon.org.apache.thrift.TException;
import tachyon.thrift.BlockInfoException;
import tachyon.thrift.ClientBlockInfo;
import tachyon.thrift.ClientDependencyInfo;
import tachyon.thrift.ClientFileInfo;
import tachyon.thrift.ClientRawTableInfo;
import tachyon.thrift.ClientWorkerInfo;
import tachyon.thrift.FileDoesNotExistException;
import tachyon.thrift.NetAddress;
import tachyon.thrift.NoWorkerException;
import tachyon.thrift.TachyonException;
import tachyon.util.CommonUtils;
import tachyon.worker.WorkerClient;

public class TachyonFS {
    private final Logger LOG = Logger.getLogger((String)Constants.LOGGER_TYPE);
    private final long USER_QUOTA_UNIT_BYTES;
    private final int USER_FAILED_SPACE_REQUEST_LIMITS;
    private MasterClient mMasterClient;
    private InetSocketAddress mMasterAddress;
    private boolean mZookeeperMode;
    private Map<String, ClientFileInfo> mCachedClientFileInfos;
    private Map<Integer, ClientFileInfo> mClientFileInfos;
    private WorkerClient mWorkerClient;
    private String mLocalDataFolder;
    private boolean mIsWorkerLocal;
    private String mUserTempFolder;
    private String mUserUnderfsTempFolder;
    private UnderFileSystem mUnderFileSystem;
    private long mUserId;
    private Map<Long, Set<Integer>> mLockedBlockIds;
    private AtomicInteger mBlockLockId;
    private Long mAvailableSpaceBytes;
    private boolean mConnected;

    private TachyonFS(InetSocketAddress masterAddress, boolean zookeeperMode) {
        this.USER_QUOTA_UNIT_BYTES = UserConf.get().QUOTA_UNIT_BYTES;
        this.USER_FAILED_SPACE_REQUEST_LIMITS = UserConf.get().FAILED_SPACE_REQUEST_LIMITS;
        this.mMasterClient = null;
        this.mMasterAddress = null;
        this.mCachedClientFileInfos = new HashMap<String, ClientFileInfo>();
        this.mClientFileInfos = new HashMap<Integer, ClientFileInfo>();
        this.mWorkerClient = null;
        this.mLocalDataFolder = null;
        this.mIsWorkerLocal = false;
        this.mUserTempFolder = null;
        this.mUserUnderfsTempFolder = null;
        this.mUnderFileSystem = null;
        this.mUserId = 0L;
        this.mLockedBlockIds = new HashMap<Long, Set<Integer>>();
        this.mBlockLockId = new AtomicInteger(0);
        this.mConnected = false;
        this.mMasterAddress = masterAddress;
        this.mZookeeperMode = zookeeperMode;
        this.mAvailableSpaceBytes = 0L;
    }

    public static synchronized TachyonFS get(String tachyonAddress) throws IOException {
        boolean zookeeperMode = false;
        String tempAddress = tachyonAddress;
        if (tachyonAddress.startsWith("tachyon://")) {
            tempAddress = tachyonAddress.substring("tachyon://".length());
        } else if (tachyonAddress.startsWith("tachyon-ft://")) {
            zookeeperMode = true;
            tempAddress = tachyonAddress.substring("tachyon-ft://".length());
        } else {
            throw new IOException("Invalid Path: " + tachyonAddress + ". Use " + "tachyon://" + "host:port/ ," + "tachyon-ft://" + "host:port/" + " , or /file");
        }
        String masterAddress = tempAddress;
        if (tempAddress.contains("/")) {
            masterAddress = tempAddress.substring(0, tempAddress.indexOf("/"));
        }
        if (masterAddress.split(":").length != 2) {
            CommonUtils.illegalArgumentException("Illegal Tachyon Master Address: " + tachyonAddress);
        }
        String masterHost = masterAddress.split(":")[0];
        int masterPort = Integer.parseInt(masterAddress.split(":")[1]);
        return new TachyonFS(new InetSocketAddress(masterHost, masterPort), zookeeperMode);
    }

    public synchronized void accessLocalBlock(long blockId) {
        this.connect();
        if (this.mWorkerClient != null && this.mIsWorkerLocal) {
            try {
                this.mWorkerClient.accessBlock(blockId);
                return;
            }
            catch (TException e) {
                this.mWorkerClient = null;
                this.LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        this.LOG.error((Object)("TachyonClient accessLocalBlock(" + blockId + ") failed"));
    }

    public synchronized void addCheckpoint(int fid) throws IOException {
        this.connect();
        if (!this.mConnected) {
            throw new IOException("Failed to add checkpoint for file " + fid);
        }
        if (this.mWorkerClient != null) {
            try {
                this.mWorkerClient.addCheckpoint(this.mUserId, fid);
            }
            catch (TException e) {
                this.LOG.error((Object)e.getMessage(), (Throwable)e);
                this.mWorkerClient = null;
                throw new IOException(e);
            }
        }
    }

    public synchronized void cacheBlock(long blockId) throws IOException {
        this.connect();
        if (!this.mConnected) {
            return;
        }
        if (this.mWorkerClient != null) {
            try {
                this.mWorkerClient.cacheBlock(this.mUserId, blockId);
            }
            catch (TException e) {
                this.LOG.error((Object)e.getMessage(), (Throwable)e);
                this.mWorkerClient = null;
                throw new IOException(e);
            }
        }
    }

    public synchronized void close() throws TException {
        if (this.mMasterClient != null) {
            this.mMasterClient.cleanConnect();
        }
        if (this.mWorkerClient != null && this.mWorkerClient.isConnected()) {
            this.mWorkerClient.returnSpace(this.mUserId, this.mAvailableSpaceBytes);
            this.mWorkerClient.close();
        }
    }

    public synchronized void connect() {
        if (this.mMasterClient != null) {
            return;
        }
        this.LOG.info((Object)("Trying to connect master @ " + this.mMasterAddress));
        this.mMasterClient = new MasterClient(this.mMasterAddress, this.mZookeeperMode);
        this.mConnected = this.mMasterClient.connect();
        if (!this.mConnected) {
            return;
        }
        try {
            this.mUserId = this.mMasterClient.getUserId();
        }
        catch (TException e) {
            this.LOG.error((Object)e.getMessage());
            this.mConnected = false;
            return;
        }
        InetSocketAddress workerAddress = null;
        NetAddress workerNetAddress = null;
        this.mIsWorkerLocal = false;
        try {
            String localHostName = InetAddress.getLocalHost().getCanonicalHostName();
            this.LOG.info((Object)("Trying to get local worker host : " + localHostName));
            workerNetAddress = this.mMasterClient.user_getWorker(false, localHostName);
            this.mIsWorkerLocal = true;
        }
        catch (NoWorkerException e) {
            this.LOG.info((Object)e.getMessage());
            workerNetAddress = null;
        }
        catch (UnknownHostException e) {
            this.LOG.error((Object)e.getMessage());
            workerNetAddress = null;
        }
        catch (TException e) {
            this.LOG.error((Object)e.getMessage());
            this.mConnected = false;
            workerNetAddress = null;
        }
        if (workerNetAddress == null) {
            try {
                workerNetAddress = this.mMasterClient.user_getWorker(true, "");
            }
            catch (NoWorkerException e) {
                this.LOG.info((Object)e.getMessage());
                workerNetAddress = null;
            }
            catch (TException e) {
                this.LOG.error((Object)e.getMessage());
                this.mConnected = false;
                workerNetAddress = null;
            }
        }
        if (workerNetAddress == null) {
            this.LOG.info((Object)"No worker running in the system");
            return;
        }
        workerAddress = new InetSocketAddress(workerNetAddress.mHost, workerNetAddress.mPort);
        this.LOG.info((Object)("Connecting " + (this.mIsWorkerLocal ? "local" : "remote") + " worker @ " + workerAddress));
        this.mWorkerClient = new WorkerClient(workerAddress, this.mUserId);
        if (!this.mWorkerClient.open()) {
            this.LOG.error((Object)("Failed to connect " + (this.mIsWorkerLocal ? "local" : "remote") + " worker @ " + workerAddress));
            this.mWorkerClient = null;
            return;
        }
        try {
            this.mLocalDataFolder = this.mWorkerClient.getDataFolder();
            this.mUserTempFolder = this.mWorkerClient.getUserTempFolder(this.mUserId);
            this.mUserUnderfsTempFolder = this.mWorkerClient.getUserUnderfsTempFolder(this.mUserId);
        }
        catch (TException e) {
            this.LOG.error((Object)e.getMessage());
            this.mLocalDataFolder = null;
            this.mUserTempFolder = null;
            this.mWorkerClient = null;
            return;
        }
    }

    public synchronized void completeFile(int fId) throws IOException {
        this.connect();
        try {
            this.mMasterClient.user_completeFile(fId);
        }
        catch (TException e) {
            this.mConnected = false;
            throw new IOException(e);
        }
    }

    public synchronized File createAndGetUserTempFolder() throws IOException {
        this.connect();
        if (this.mUserTempFolder == null) {
            return null;
        }
        File ret = new File(this.mUserTempFolder);
        if (!ret.exists()) {
            if (ret.mkdir()) {
                CommonUtils.changeLocalFileToFullPermission(ret.getAbsolutePath());
                this.LOG.info((Object)("Folder " + ret + " was created!"));
            } else {
                this.LOG.error((Object)("Failed to create folder " + ret));
                return null;
            }
        }
        return ret;
    }

    public synchronized String createAndGetUserUnderfsTempFolder() throws IOException {
        this.connect();
        if (this.mUserUnderfsTempFolder == null) {
            return null;
        }
        if (this.mUnderFileSystem == null) {
            this.mUnderFileSystem = UnderFileSystem.get(this.mUserUnderfsTempFolder);
        }
        this.mUnderFileSystem.mkdirs(this.mUserUnderfsTempFolder, true);
        return this.mUserUnderfsTempFolder;
    }

    public synchronized int createRawTable(String path, int columns) throws IOException {
        return this.createRawTable(path, columns, ByteBuffer.allocate(0));
    }

    public synchronized int createRawTable(String path, int columns, ByteBuffer metadata) throws IOException {
        this.connect();
        if (!this.mConnected) {
            return -1;
        }
        path = CommonUtils.cleanPath(path);
        if (columns < 1 || columns > 1000) {
            throw new IOException("Column count " + columns + " is smaller than 1 or " + "bigger than " + 1000);
        }
        try {
            return this.mMasterClient.user_createRawTable(path, columns, metadata);
        }
        catch (TException e) {
            this.LOG.error((Object)e.getMessage());
            this.mConnected = false;
            return -1;
        }
    }

    public synchronized int createFile(String path) throws IOException {
        return this.createFile(path, UserConf.get().DEFAULT_BLOCK_SIZE_BYTE);
    }

    public synchronized int createFile(String path, long blockSizeByte) throws IOException {
        if (blockSizeByte > 0x80000000L) {
            throw new IOException("Block size must be less than 2GB: " + blockSizeByte);
        }
        this.connect();
        if (!this.mConnected) {
            return -1;
        }
        path = CommonUtils.cleanPath(path);
        int fid = -1;
        try {
            fid = this.mMasterClient.user_createFile(path, blockSizeByte);
        }
        catch (TException e) {
            this.mConnected = false;
            throw new IOException(e);
        }
        return fid;
    }

    public synchronized int createFile(String path, String checkpointPath) throws IOException {
        this.connect();
        if (!this.mConnected) {
            return -1;
        }
        path = CommonUtils.cleanPath(path);
        int fid = -1;
        try {
            fid = this.mMasterClient.user_createFileOnCheckpoint(path, checkpointPath);
        }
        catch (TException e) {
            this.mConnected = false;
            throw new IOException(e);
        }
        return fid;
    }

    public synchronized boolean delete(int fid, boolean recursive) throws IOException {
        this.connect();
        if (!this.mConnected) {
            return false;
        }
        try {
            return this.mMasterClient.user_delete(fid, recursive);
        }
        catch (TException e) {
            this.mConnected = false;
            throw new IOException(e);
        }
    }

    public synchronized boolean delete(String path, boolean recursive) throws IOException {
        this.connect();
        if (!this.mConnected) {
            return false;
        }
        try {
            return this.mMasterClient.user_delete(path, recursive);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public synchronized boolean exist(String path) throws IOException {
        return this.getFileId(path) != -1;
    }

    public synchronized long getBlockId(int fId, int blockIndex) throws IOException {
        ClientFileInfo info = this.mClientFileInfos.get(fId);
        if (info == null) {
            info = this.fetchClientFileInfo(fId);
            if (info != null) {
                this.mClientFileInfos.put(fId, info);
            } else {
                throw new IOException("File " + fId + " does not exist.");
            }
        }
        if (info.blockIds.size() > blockIndex) {
            return info.blockIds.get(blockIndex);
        }
        this.connect();
        try {
            return this.mMasterClient.user_getBlockId(fId, blockIndex);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public synchronized long getBlockIdBasedOnOffset(int fId, long offset) throws IOException {
        ClientFileInfo info;
        if (!this.mClientFileInfos.containsKey(fId)) {
            info = this.fetchClientFileInfo(fId);
            this.mClientFileInfos.put(fId, info);
        }
        info = this.mClientFileInfos.get(fId);
        int index = (int)(offset / info.getBlockSizeByte());
        return this.getBlockId(fId, index);
    }

    public synchronized ClientBlockInfo getClientBlockInfo(int fId, int blockIndex) throws IOException {
        boolean fetch = false;
        if (!this.mClientFileInfos.containsKey(fId)) {
            fetch = true;
        }
        ClientFileInfo info = null;
        if (!fetch && ((info = this.mClientFileInfos.get(fId)).isFolder() || info.blockIds.size() <= blockIndex)) {
            fetch = true;
        }
        if (fetch) {
            this.connect();
            info = this.fetchClientFileInfo(fId);
            this.mClientFileInfos.put(fId, info);
        }
        if (info == null) {
            throw new IOException("File " + fId + " does not exist.");
        }
        if (info.isFolder()) {
            throw new IOException(new FileDoesNotExistException("File " + fId + " is a folder."));
        }
        if (info.blockIds.size() <= blockIndex) {
            throw new IOException("BlockIndex " + blockIndex + " is out of the bound in file " + info);
        }
        try {
            return this.mMasterClient.user_getClientBlockInfo(info.blockIds.get(blockIndex));
        }
        catch (FileDoesNotExistException e) {
            throw new IOException(e);
        }
        catch (BlockInfoException e) {
            throw new IOException(e);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    private synchronized ClientFileInfo getClientFileInfo(String path, boolean useCachedMetadata) throws IOException {
        ClientFileInfo ret;
        this.connect();
        if (!this.mConnected) {
            return null;
        }
        path = CommonUtils.cleanPath(path);
        if (useCachedMetadata && this.mCachedClientFileInfos.containsKey(path)) {
            return this.mCachedClientFileInfos.get(path);
        }
        try {
            ret = this.mMasterClient.user_getClientFileInfoByPath(path);
        }
        catch (IOException e) {
            this.LOG.info((Object)(e.getMessage() + path));
            return null;
        }
        catch (TException e) {
            this.LOG.error((Object)e.getMessage());
            this.mConnected = false;
            return null;
        }
        if (ret != null && useCachedMetadata) {
            this.mCachedClientFileInfos.put(path, ret);
        } else {
            this.mCachedClientFileInfos.remove(path);
        }
        return ret;
    }

    private synchronized ClientFileInfo fetchClientFileInfo(int fid) {
        this.connect();
        if (!this.mConnected) {
            return null;
        }
        ClientFileInfo ret = null;
        try {
            ret = this.mMasterClient.getClientFileInfoById(fid);
        }
        catch (IOException e) {
            this.LOG.info((Object)(e.getMessage() + fid));
            return null;
        }
        catch (TException e) {
            this.LOG.error((Object)e.getMessage());
            this.mConnected = false;
            return null;
        }
        return ret;
    }

    public synchronized long getBlockSizeByte(int fId) {
        return this.mClientFileInfos.get(fId).getBlockSizeByte();
    }

    synchronized String getCheckpointPath(int fid) {
        ClientFileInfo info = this.mClientFileInfos.get(fid);
        if (info == null || !info.getCheckpointPath().equals("")) {
            info = this.fetchClientFileInfo(fid);
            this.mClientFileInfos.put(fid, info);
        }
        return info.getCheckpointPath();
    }

    public synchronized long getCreationTimeMs(int fId) {
        return this.mClientFileInfos.get(fId).getCreationTimeMs();
    }

    public synchronized List<Long> getFileBlockIdList(int fId) throws IOException {
        this.connect();
        ClientFileInfo info = this.mClientFileInfos.get(fId);
        if (info == null || !info.isComplete()) {
            info = this.fetchClientFileInfo(fId);
            this.mClientFileInfos.put(fId, info);
        }
        if (info == null) {
            throw new IOException("File " + fId + " does not exist.");
        }
        return info.blockIds;
    }

    public synchronized List<ClientBlockInfo> getFileBlocks(int fid) throws IOException {
        this.connect();
        if (!this.mConnected) {
            return null;
        }
        try {
            return this.mMasterClient.user_getFileBlocks(fid);
        }
        catch (TException e) {
            this.mConnected = false;
            throw new IOException(e);
        }
    }

    public synchronized TachyonFile getFile(String path) throws IOException {
        return this.getFile(path, false);
    }

    public synchronized TachyonFile getFile(String path, boolean useCachedMetadata) throws IOException {
        ClientFileInfo clientFileInfo = this.getClientFileInfo(path = CommonUtils.cleanPath(path), useCachedMetadata);
        if (clientFileInfo == null) {
            return null;
        }
        this.mClientFileInfos.put(clientFileInfo.getId(), clientFileInfo);
        return new TachyonFile(this, clientFileInfo.getId());
    }

    public synchronized TachyonFile getFile(int fid) {
        if (!this.mClientFileInfos.containsKey(fid)) {
            ClientFileInfo clientFileInfo = this.fetchClientFileInfo(fid);
            if (clientFileInfo == null) {
                return null;
            }
            this.mClientFileInfos.put(fid, clientFileInfo);
        }
        return new TachyonFile(this, fid);
    }

    public synchronized int getFileId(String path) throws IOException {
        this.connect();
        if (!this.mConnected) {
            return -1;
        }
        int fid = -1;
        path = CommonUtils.cleanPath(path);
        try {
            fid = this.mMasterClient.user_getFileId(path);
        }
        catch (TException e) {
            this.LOG.error((Object)e.getMessage());
            this.mConnected = false;
            return -1;
        }
        return fid;
    }

    synchronized long getFileLength(int fid) {
        if (!this.mClientFileInfos.get(fid).isComplete()) {
            ClientFileInfo info = this.fetchClientFileInfo(fid);
            this.mClientFileInfos.put(fid, info);
        }
        return this.mClientFileInfos.get(fid).getLength();
    }

    synchronized long getNextBlockId(int fId) throws IOException {
        this.connect();
        try {
            return this.mMasterClient.user_createNewBlock(fId);
        }
        catch (TException e) {
            this.mConnected = false;
            throw new IOException(e);
        }
    }

    synchronized int getNumberOfBlocks(int fId) throws IOException {
        ClientFileInfo info = this.mClientFileInfos.get(fId);
        if (info == null || !info.isComplete()) {
            info = this.fetchClientFileInfo(fId);
            this.mClientFileInfos.put(fId, info);
        }
        if (info == null) {
            throw new IOException("File " + fId + " does not exist.");
        }
        return info.getBlockIds().size();
    }

    public synchronized int getNumberOfFiles(String folderPath) throws IOException {
        this.connect();
        try {
            return this.mMasterClient.user_getNumberOfFiles(folderPath);
        }
        catch (TException e) {
            this.mConnected = false;
            throw new IOException(e);
        }
    }

    synchronized String getPath(int fid) {
        return this.mClientFileInfos.get(fid).getPath();
    }

    public synchronized RawTable getRawTable(String path) throws IOException {
        ClientRawTableInfo clientRawTableInfo;
        this.connect();
        path = CommonUtils.cleanPath(path);
        try {
            clientRawTableInfo = this.mMasterClient.user_getClientRawTableInfoByPath(path);
        }
        catch (TException e) {
            this.mConnected = false;
            throw new IOException(e);
        }
        return new RawTable(this, clientRawTableInfo);
    }

    public synchronized RawTable getRawTable(int id) throws IOException {
        this.connect();
        ClientRawTableInfo clientRawTableInfo = null;
        try {
            clientRawTableInfo = this.mMasterClient.user_getClientRawTableInfoById(id);
        }
        catch (TException e) {
            this.mConnected = false;
            throw new IOException(e);
        }
        return new RawTable(this, clientRawTableInfo);
    }

    public synchronized String getRootFolder() {
        this.connect();
        return this.mLocalDataFolder;
    }

    public int getBlockLockId() {
        return this.mBlockLockId.getAndIncrement();
    }

    public synchronized String getUnderfsAddress() throws IOException {
        this.connect();
        try {
            return this.mMasterClient.user_getUnderfsAddress();
        }
        catch (TException e) {
            throw new IOException(e.getMessage());
        }
    }

    public synchronized List<ClientWorkerInfo> getWorkersInfo() throws IOException {
        this.connect();
        try {
            return this.mMasterClient.getWorkersInfo();
        }
        catch (TException e) {
            this.mConnected = false;
            throw new IOException(e);
        }
    }

    public synchronized boolean hasLocalWorker() {
        this.connect();
        return this.mIsWorkerLocal && this.mWorkerClient != null;
    }

    public synchronized boolean isConnected() {
        return this.mConnected;
    }

    synchronized boolean isDirectory(int fid) {
        return this.mClientFileInfos.get(fid).isFolder();
    }

    synchronized boolean isInMemory(int fid) {
        ClientFileInfo info = this.fetchClientFileInfo(fid);
        this.mClientFileInfos.put(info.getId(), info);
        return info.isInMemory();
    }

    synchronized boolean isNeedPin(int fid) {
        return this.mClientFileInfos.get(fid).isNeedPin();
    }

    synchronized boolean isComplete(int fid) {
        if (!this.mClientFileInfos.get(fid).isComplete()) {
            this.mClientFileInfos.put(fid, this.fetchClientFileInfo(fid));
        }
        return this.mClientFileInfos.get(fid).isComplete();
    }

    public synchronized List<Integer> listFiles(String path, boolean recursive) throws IOException {
        this.connect();
        try {
            return this.mMasterClient.user_listFiles(path, recursive);
        }
        catch (TException e) {
            this.mConnected = false;
            throw new IOException(e);
        }
    }

    public synchronized List<ClientFileInfo> listStatus(String path) throws IOException {
        this.connect();
        try {
            return this.mMasterClient.listStatus(path);
        }
        catch (TException e) {
            this.mConnected = false;
            throw new IOException(e);
        }
    }

    public synchronized List<String> ls(String path, boolean recursive) throws IOException {
        this.connect();
        try {
            return this.mMasterClient.user_ls(path, recursive);
        }
        catch (TException e) {
            this.mConnected = false;
            throw new IOException(e);
        }
    }

    synchronized boolean lockBlock(long blockId, int blockLockId) {
        if (blockId <= 0L || blockLockId < 0) {
            return false;
        }
        if (this.mLockedBlockIds.containsKey(blockId)) {
            this.mLockedBlockIds.get(blockId).add(blockLockId);
            return true;
        }
        this.connect();
        if (!this.mConnected || this.mWorkerClient == null || !this.mIsWorkerLocal) {
            return false;
        }
        try {
            this.mWorkerClient.lockBlock(blockId, this.mUserId);
        }
        catch (TException e) {
            this.LOG.error((Object)e.getMessage());
            return false;
        }
        HashSet<Integer> lockIds = new HashSet<Integer>(4);
        lockIds.add(blockLockId);
        this.mLockedBlockIds.put(blockId, lockIds);
        return true;
    }

    public synchronized boolean mkdir(String path) throws IOException {
        this.connect();
        if (!this.mConnected) {
            return false;
        }
        path = CommonUtils.cleanPath(path);
        try {
            return this.mMasterClient.user_mkdir(path);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public synchronized void outOfMemoryForPinFile(int fid) {
        this.connect();
        if (this.mConnected) {
            try {
                this.mMasterClient.user_outOfMemoryForPinFile(fid);
            }
            catch (TException e) {
                this.LOG.error((Object)e.getMessage());
            }
        }
    }

    TachyonByteBuffer readLocalByteBuffer(long blockId) throws IOException {
        return this.readLocalByteBuffer(blockId, 0L, -1L);
    }

    String getLocalFilename(long blockId) {
        String localFileName;
        File file;
        String rootFolder = this.getRootFolder();
        if (rootFolder != null && (file = new File(localFileName = rootFolder + "/" + blockId)).exists()) {
            return localFileName;
        }
        return null;
    }

    TachyonByteBuffer readLocalByteBuffer(long blockId, long offset, long len) throws IOException {
        if (offset < 0L) {
            throw new IOException("Offset can not be negative: " + offset);
        }
        if (len < 0L && len != -1L) {
            throw new IOException("Length can not be negative except -1: " + len);
        }
        int blockLockId = this.getBlockLockId();
        if (!this.lockBlock(blockId, blockLockId)) {
            return null;
        }
        String localFileName = this.getLocalFilename(blockId);
        if (localFileName != null) {
            try {
                RandomAccessFile localFile = new RandomAccessFile(localFileName, "r");
                long fileLength = localFile.length();
                String error = null;
                if (offset > fileLength) {
                    error = String.format("Offset(%d) is larger than file length(%d)", offset, fileLength);
                }
                if (error == null && len != -1L && offset + len > fileLength) {
                    error = String.format("Offset(%d) plus length(%d) is larger than file length(%d)", offset, len, fileLength);
                }
                if (error != null) {
                    localFile.close();
                    throw new IOException(error);
                }
                if (len == -1L) {
                    len = fileLength - offset;
                }
                FileChannel localFileChannel = localFile.getChannel();
                MappedByteBuffer buf = localFileChannel.map(FileChannel.MapMode.READ_ONLY, offset, len);
                localFileChannel.close();
                localFile.close();
                this.accessLocalBlock(blockId);
                return new TachyonByteBuffer(this, buf, blockId, blockLockId);
            }
            catch (FileNotFoundException e) {
                this.LOG.info((Object)(localFileName + " is not on local disk."));
            }
            catch (IOException e) {
                this.LOG.info((Object)("Failed to read local file " + localFileName + " because: \n" + e.getMessage()));
            }
        }
        this.unlockBlock(blockId, blockLockId);
        return null;
    }

    public synchronized void releaseSpace(long releaseSpaceBytes) {
        this.mAvailableSpaceBytes = this.mAvailableSpaceBytes + releaseSpaceBytes;
    }

    public synchronized boolean rename(String srcPath, String dstPath) throws IOException {
        this.connect();
        if (!this.mConnected) {
            return false;
        }
        try {
            if (srcPath.equals(dstPath) && this.exist(srcPath)) {
                return true;
            }
            this.mMasterClient.user_rename(srcPath, dstPath);
        }
        catch (TException e) {
            this.LOG.error((Object)e.getMessage());
            return false;
        }
        return true;
    }

    public synchronized boolean rename(int fId, String path) throws IOException {
        this.connect();
        if (!this.mConnected) {
            return false;
        }
        try {
            this.mMasterClient.user_renameTo(fId, path);
        }
        catch (TException e) {
            this.LOG.error((Object)e.getMessage());
            return false;
        }
        return true;
    }

    public synchronized boolean requestSpace(long requestSpaceBytes) {
        this.connect();
        if (this.mWorkerClient == null || !this.mIsWorkerLocal) {
            return false;
        }
        int failedTimes = 0;
        while (this.mAvailableSpaceBytes < requestSpaceBytes) {
            if (this.mWorkerClient == null) {
                this.LOG.error((Object)"The current host does not have a Tachyon worker.");
                return false;
            }
            try {
                long toRequestSpaceBytes = Math.max(requestSpaceBytes - this.mAvailableSpaceBytes, this.USER_QUOTA_UNIT_BYTES);
                if (this.mWorkerClient.requestSpace(this.mUserId, toRequestSpaceBytes)) {
                    this.mAvailableSpaceBytes = this.mAvailableSpaceBytes + toRequestSpaceBytes;
                    continue;
                }
                this.LOG.info((Object)("Failed to request " + toRequestSpaceBytes + " bytes local space. " + "Time " + failedTimes++));
                if (failedTimes != this.USER_FAILED_SPACE_REQUEST_LIMITS) continue;
                return false;
            }
            catch (TException e) {
                this.LOG.error((Object)e.getMessage(), (Throwable)e);
                this.mWorkerClient = null;
                return false;
            }
        }
        if (this.mAvailableSpaceBytes < requestSpaceBytes) {
            return false;
        }
        this.mAvailableSpaceBytes = this.mAvailableSpaceBytes - requestSpaceBytes;
        return true;
    }

    public synchronized boolean unpinFile(int fid) throws IOException {
        this.connect();
        if (!this.mConnected) {
            return false;
        }
        try {
            this.mMasterClient.user_unpinFile(fid);
        }
        catch (TException e) {
            this.LOG.error((Object)e.getMessage());
            return false;
        }
        return true;
    }

    synchronized boolean unlockBlock(long blockId, int blockLockId) {
        if (blockId <= 0L || blockLockId < 0) {
            return false;
        }
        if (!this.mLockedBlockIds.containsKey(blockId)) {
            return true;
        }
        Set<Integer> lockIds = this.mLockedBlockIds.get(blockId);
        lockIds.remove(blockLockId);
        if (!lockIds.isEmpty()) {
            return true;
        }
        this.connect();
        if (!this.mConnected || this.mWorkerClient == null || !this.mIsWorkerLocal) {
            return false;
        }
        try {
            this.mWorkerClient.unlockBlock(blockId, this.mUserId);
            this.mLockedBlockIds.remove(blockId);
        }
        catch (TException e) {
            this.LOG.error((Object)e.getMessage());
            return false;
        }
        return true;
    }

    public synchronized void updateRawTableMetadata(int id, ByteBuffer metadata) throws IOException {
        this.connect();
        try {
            this.mMasterClient.user_updateRawTableMetadata(id, metadata);
        }
        catch (TException e) {
            this.mConnected = false;
            throw new IOException(e);
        }
    }

    public synchronized int createDependency(List<String> parents, List<String> children, String commandPrefix, List<ByteBuffer> data, String comment, String framework, String frameworkVersion, int dependencyType, long childrenBlockSizeByte) throws IOException {
        this.connect();
        try {
            return this.mMasterClient.user_createDependency(parents, children, commandPrefix, data, comment, framework, frameworkVersion, dependencyType, childrenBlockSizeByte);
        }
        catch (TException e) {
            this.mConnected = false;
            throw new IOException(e);
        }
    }

    public synchronized void reportLostFile(int fileId) throws IOException {
        this.connect();
        try {
            this.mMasterClient.user_reportLostFile(fileId);
        }
        catch (TException e) {
            this.mConnected = false;
            throw new IOException(e);
        }
    }

    public synchronized void requestFilesInDependency(int depId) throws IOException {
        this.connect();
        try {
            this.mMasterClient.user_requestFilesInDependency(depId);
        }
        catch (TException e) {
            this.mConnected = false;
            throw new IOException(e);
        }
    }

    public synchronized boolean asyncCheckpoint(int fid) throws IOException {
        this.connect();
        try {
            return this.mWorkerClient.asyncCheckpoint(fid);
        }
        catch (TachyonException e) {
            throw new IOException(e);
        }
        catch (TException e) {
            this.mConnected = false;
            throw new IOException(e);
        }
    }

    public synchronized ClientDependencyInfo getClientDependencyInfo(int did) throws IOException {
        this.connect();
        try {
            return this.mMasterClient.getClientDependencyInfo(did);
        }
        catch (TException e) {
            this.mConnected = false;
            throw new IOException(e);
        }
    }

    public synchronized List<NetAddress> getFileNetAddresses(int fileId) throws IOException {
        this.connect();
        if (!this.mConnected) {
            return null;
        }
        ArrayList<NetAddress> ret = new ArrayList<NetAddress>();
        try {
            List<ClientBlockInfo> blocks = this.mMasterClient.user_getFileBlocks(fileId);
            HashSet<NetAddress> locationSet = new HashSet<NetAddress>();
            for (ClientBlockInfo info : blocks) {
                locationSet.addAll(info.getLocations());
            }
            ret.addAll(locationSet);
        }
        catch (TException e) {
            this.mConnected = false;
            throw new IOException(e);
        }
        return ret;
    }

    public synchronized List<List<NetAddress>> getFilesNetAddresses(List<Integer> fileIds) throws IOException {
        ArrayList<List<NetAddress>> ret = new ArrayList<List<NetAddress>>();
        for (int k = 0; k < fileIds.size(); ++k) {
            ret.add(this.getFileNetAddresses(fileIds.get(k)));
        }
        return ret;
    }

    public synchronized List<String> getFileHosts(int fileId) throws IOException {
        this.connect();
        if (!this.mConnected) {
            return null;
        }
        List<NetAddress> adresses = this.getFileNetAddresses(fileId);
        ArrayList<String> ret = new ArrayList<String>(adresses.size());
        for (NetAddress address : adresses) {
            ret.add(address.mHost);
            if (!address.mHost.endsWith(".ec2.internal")) continue;
            ret.add(address.mHost.substring(0, address.mHost.length() - 13));
        }
        return ret;
    }

    public synchronized List<List<String>> getFilesHosts(List<Integer> fileIds) throws IOException {
        ArrayList<List<String>> ret = new ArrayList<List<String>>();
        for (int k = 0; k < fileIds.size(); ++k) {
            ret.add(this.getFileHosts(fileIds.get(k)));
        }
        return ret;
    }
}

