/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client.table;

import java.io.IOException;
import java.nio.ByteBuffer;
import tachyon.client.TachyonFS;
import tachyon.client.table.RawColumn;
import tachyon.thrift.ClientRawTableInfo;
import tachyon.util.CommonUtils;

public class RawTable {
    private final TachyonFS TACHYON_CLIENT;
    private final ClientRawTableInfo CLIENT_RAW_TABLE_INFO;

    public RawTable(TachyonFS tachyonClient, ClientRawTableInfo clientRawTableInfo) {
        this.TACHYON_CLIENT = tachyonClient;
        this.CLIENT_RAW_TABLE_INFO = clientRawTableInfo;
    }

    public int getColumns() {
        return this.CLIENT_RAW_TABLE_INFO.getColumns();
    }

    public int getId() {
        return this.CLIENT_RAW_TABLE_INFO.getId();
    }

    public String getName() {
        return this.CLIENT_RAW_TABLE_INFO.getName();
    }

    public String getPath() {
        return this.CLIENT_RAW_TABLE_INFO.getPath();
    }

    public ByteBuffer getMetadata() {
        return CommonUtils.cloneByteBuffer(this.CLIENT_RAW_TABLE_INFO.metadata);
    }

    public RawColumn getRawColumn(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.CLIENT_RAW_TABLE_INFO.getColumns()) {
            CommonUtils.runtimeException(this.CLIENT_RAW_TABLE_INFO.getPath() + " does not have column " + columnIndex + ". It has " + this.CLIENT_RAW_TABLE_INFO.getColumns() + " columns.");
        }
        return new RawColumn(this.TACHYON_CLIENT, this, columnIndex);
    }

    public void updateMetadata(ByteBuffer metadata) throws IOException {
        this.TACHYON_CLIENT.updateRawTableMetadata(this.CLIENT_RAW_TABLE_INFO.getId(), metadata);
        this.CLIENT_RAW_TABLE_INFO.setMetadata(CommonUtils.cloneByteBuffer(metadata));
    }
}

