/*
 * Decompiled with CFR 0.152.
 */
package tachyon.master;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tachyon.Pair;
import tachyon.UnderFileSystem;
import tachyon.master.InodeFile;
import tachyon.thrift.ClientBlockInfo;
import tachyon.thrift.NetAddress;

public class BlockInfo {
    private final InodeFile INODE_FILE;
    public final int BLOCK_INDEX;
    public final long BLOCK_ID;
    public final long OFFSET;
    public final long LENGTH;
    private Map<Long, NetAddress> mLocations = new HashMap<Long, NetAddress>(5);

    BlockInfo(InodeFile inodeFile, int blockIndex, long length) {
        this.INODE_FILE = inodeFile;
        this.BLOCK_INDEX = blockIndex;
        this.BLOCK_ID = BlockInfo.computeBlockId(this.INODE_FILE.getId(), this.BLOCK_INDEX);
        this.OFFSET = inodeFile.getBlockSizeByte() * (long)blockIndex;
        this.LENGTH = length;
    }

    public synchronized void addLocation(long workerId, NetAddress workerAddress) {
        this.mLocations.put(workerId, workerAddress);
    }

    public synchronized InodeFile getInodeFile() {
        return this.INODE_FILE;
    }

    public synchronized List<NetAddress> getLocations() {
        ArrayList<NetAddress> ret = new ArrayList<NetAddress>(this.mLocations.size());
        ret.addAll(this.mLocations.values());
        if (ret.isEmpty() && this.INODE_FILE.hasCheckpointed()) {
            UnderFileSystem ufs = UnderFileSystem.get(this.INODE_FILE.getCheckpointPath());
            List<String> locs = null;
            try {
                locs = ufs.getFileLocations(this.INODE_FILE.getCheckpointPath(), this.OFFSET);
            }
            catch (IOException e) {
                return ret;
            }
            if (locs != null) {
                for (String loc : locs) {
                    ret.add(new NetAddress(loc, -1));
                }
            }
        }
        return ret;
    }

    public synchronized ClientBlockInfo generateClientBlockInfo() {
        ClientBlockInfo ret = new ClientBlockInfo();
        ret.blockId = this.BLOCK_ID;
        ret.offset = this.OFFSET;
        ret.length = this.LENGTH;
        ret.locations = this.getLocations();
        return ret;
    }

    public synchronized List<Pair<Long, Long>> getBlockIdWorkerIdPairs() {
        ArrayList<Pair<Long, Long>> ret = new ArrayList<Pair<Long, Long>>(this.mLocations.size());
        for (long workerId : this.mLocations.keySet()) {
            ret.add(new Pair<Long, Long>(this.BLOCK_ID, workerId));
        }
        return ret;
    }

    public synchronized boolean isInMemory() {
        return this.mLocations.size() > 0;
    }

    public synchronized void removeLocation(long workerId) {
        this.mLocations.remove(workerId);
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder("BlockInfo(BLOCK_INDEX: ");
        sb.append(this.BLOCK_INDEX);
        sb.append(", BLOCK_ID: ").append(this.BLOCK_ID);
        sb.append(", OFFSET: ").append(this.OFFSET);
        sb.append(", LENGTH: ").append(this.LENGTH);
        sb.append(", mLocations: ").append(this.mLocations).append(")");
        return sb.toString();
    }

    public static long computeBlockId(int inodeId, int blockIndex) {
        return ((long)inodeId << 30) + (long)blockIndex;
    }

    public static int computeBlockIndex(long blockId) {
        return (int)(blockId & 0x3FFFFFFFL);
    }

    public static int computeInodeId(long blockId) {
        return (int)(blockId >> 30);
    }
}

