/*
 * Decompiled with CFR 0.152.
 */
package tachyon.master;

import java.util.ArrayList;
import java.util.List;
import tachyon.Pair;
import tachyon.master.BlockInfo;
import tachyon.master.Inode;
import tachyon.master.InodeType;
import tachyon.thrift.BlockInfoException;
import tachyon.thrift.ClientBlockInfo;
import tachyon.thrift.ClientFileInfo;
import tachyon.thrift.NetAddress;
import tachyon.thrift.SuspectedFileSizeException;

public class InodeFile
extends Inode {
    private final long BLOCK_SIZE_BYTE;
    private long mLength = 0L;
    private boolean mIsComplete = false;
    private boolean mPin = false;
    private boolean mCache = false;
    private String mCheckpointPath = "";
    private List<BlockInfo> mBlocks = new ArrayList<BlockInfo>(3);
    private int mDependencyId;

    public InodeFile(String name, int id, int parentId, long blockSizeByte, long creationTimeMs) {
        super(name, id, parentId, InodeType.File, creationTimeMs);
        this.BLOCK_SIZE_BYTE = blockSizeByte;
        this.mDependencyId = -1;
    }

    public synchronized long getLength() {
        return this.mLength;
    }

    public synchronized void setLength(long length) throws SuspectedFileSizeException, BlockInfoException {
        if (this.isComplete()) {
            throw new SuspectedFileSizeException("InodeFile length was set previously.");
        }
        if (length < 0L) {
            throw new SuspectedFileSizeException("InodeFile new length " + length + " is illegal.");
        }
        this.mLength = 0L;
        while (length >= this.BLOCK_SIZE_BYTE) {
            this.addBlock(new BlockInfo(this, this.mBlocks.size(), this.BLOCK_SIZE_BYTE));
            length -= this.BLOCK_SIZE_BYTE;
        }
        if (length > 0L) {
            this.addBlock(new BlockInfo(this, this.mBlocks.size(), (int)length));
        }
        this.mIsComplete = true;
    }

    public synchronized boolean isComplete() {
        return this.mIsComplete;
    }

    public synchronized void setComplete() {
        this.mIsComplete = true;
    }

    public synchronized void setComplete(boolean complete) {
        this.mIsComplete = complete;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("InodeFile(");
        sb.append(super.toString()).append(", LENGTH: ").append(this.mLength);
        sb.append(", CheckpointPath: ").append(this.mCheckpointPath);
        sb.append(", mBlocks: ").append(this.mBlocks);
        sb.append(", DependencyId:").append(this.mDependencyId).append(")");
        return sb.toString();
    }

    public synchronized void setCheckpointPath(String checkpointPath) {
        this.mCheckpointPath = checkpointPath;
    }

    public synchronized String getCheckpointPath() {
        return this.mCheckpointPath;
    }

    public synchronized long getNewBlockId() {
        return BlockInfo.computeBlockId(this.getId(), this.mBlocks.size());
    }

    public synchronized void addBlock(BlockInfo blockInfo) throws BlockInfoException {
        if (this.mIsComplete) {
            throw new BlockInfoException("The file is complete: " + this);
        }
        if (this.mBlocks.size() > 0 && this.mBlocks.get((int)(this.mBlocks.size() - 1)).LENGTH != this.BLOCK_SIZE_BYTE) {
            throw new BlockInfoException("BLOCK_SIZE_BYTE is " + this.BLOCK_SIZE_BYTE + ", but the " + "previous block size is " + this.mBlocks.get((int)(this.mBlocks.size() - 1)).LENGTH);
        }
        if (blockInfo.getInodeFile() != this) {
            throw new BlockInfoException("InodeFile unmatch: " + this + " != " + blockInfo);
        }
        if (blockInfo.BLOCK_INDEX != this.mBlocks.size()) {
            throw new BlockInfoException("BLOCK_INDEX unmatch: " + this.mBlocks.size() + " != " + blockInfo);
        }
        if (blockInfo.OFFSET != (long)this.mBlocks.size() * this.BLOCK_SIZE_BYTE) {
            throw new BlockInfoException("OFFSET unmatch: " + (long)this.mBlocks.size() * this.BLOCK_SIZE_BYTE + " != " + blockInfo);
        }
        if (blockInfo.LENGTH > this.BLOCK_SIZE_BYTE) {
            throw new BlockInfoException("LENGTH too big: " + this.BLOCK_SIZE_BYTE + " " + blockInfo);
        }
        this.mLength += blockInfo.LENGTH;
        this.mBlocks.add(blockInfo);
    }

    public synchronized void addLocation(int blockIndex, long workerId, NetAddress workerAddress) throws BlockInfoException {
        if (blockIndex < 0 || blockIndex >= this.mBlocks.size()) {
            throw new BlockInfoException("BlockIndex " + blockIndex + " out of bounds." + this.toString());
        }
        this.mBlocks.get(blockIndex).addLocation(workerId, workerAddress);
    }

    public synchronized void removeLocation(int blockIndex, long workerId) throws BlockInfoException {
        if (blockIndex < 0 || blockIndex >= this.mBlocks.size()) {
            throw new BlockInfoException("BlockIndex " + blockIndex + " out of bounds." + this.toString());
        }
        this.mBlocks.get(blockIndex).removeLocation(workerId);
    }

    public long getBlockIdBasedOnOffset(long offset) {
        int index = (int)(offset / this.BLOCK_SIZE_BYTE);
        return BlockInfo.computeBlockId(this.getId(), index);
    }

    public long getBlockSizeByte() {
        return this.BLOCK_SIZE_BYTE;
    }

    public synchronized List<NetAddress> getBlockLocations(int blockIndex) throws BlockInfoException {
        if (blockIndex < 0 || blockIndex > this.mBlocks.size()) {
            throw new BlockInfoException("BlockIndex is out of the boundry: " + blockIndex);
        }
        return this.mBlocks.get(blockIndex).getLocations();
    }

    public synchronized ClientBlockInfo getClientBlockInfo(int blockIndex) throws BlockInfoException {
        if (blockIndex < 0 || blockIndex > this.mBlocks.size()) {
            throw new BlockInfoException("BlockIndex is out of the boundry: " + blockIndex);
        }
        return this.mBlocks.get(blockIndex).generateClientBlockInfo();
    }

    public synchronized List<ClientBlockInfo> getClientBlockInfos() {
        ArrayList<ClientBlockInfo> ret = new ArrayList<ClientBlockInfo>(this.mBlocks.size());
        for (BlockInfo tInfo : this.mBlocks) {
            ret.add(tInfo.generateClientBlockInfo());
        }
        return ret;
    }

    public synchronized boolean isFullyInMemory() {
        return this.getInMemoryPercentage() == 100;
    }

    private synchronized int getInMemoryPercentage() {
        if (this.mLength == 0L) {
            return 100;
        }
        long inMemoryLength = 0L;
        for (BlockInfo info : this.mBlocks) {
            if (!info.isInMemory()) continue;
            inMemoryLength += info.LENGTH;
        }
        return (int)(inMemoryLength * 100L / this.mLength);
    }

    public synchronized void setPin(boolean pin) {
        this.mPin = pin;
    }

    public synchronized boolean isPin() {
        return this.mPin;
    }

    public synchronized void setCache(boolean cache) {
        this.mCache = cache;
    }

    public synchronized boolean isCache() {
        return this.mCache;
    }

    public synchronized boolean hasCheckpointed() {
        return !this.mCheckpointPath.equals("");
    }

    public synchronized void setDependencyId(int dependencyId) {
        this.mDependencyId = dependencyId;
    }

    public synchronized int getDependencyId() {
        return this.mDependencyId;
    }

    public synchronized List<Long> getBlockIds() {
        ArrayList<Long> ret = new ArrayList<Long>(this.mBlocks.size());
        for (int k = 0; k < this.mBlocks.size(); ++k) {
            ret.add(this.mBlocks.get((int)k).BLOCK_ID);
        }
        return ret;
    }

    public synchronized int getNumberOfBlocks() {
        return this.mBlocks.size();
    }

    public List<BlockInfo> getBlockList() {
        return this.mBlocks;
    }

    public synchronized List<Pair<Long, Long>> getBlockIdWorkerIdPairs() {
        ArrayList<Pair<Long, Long>> ret = new ArrayList<Pair<Long, Long>>();
        for (BlockInfo info : this.mBlocks) {
            ret.addAll(info.getBlockIdWorkerIdPairs());
        }
        return ret;
    }

    @Override
    public ClientFileInfo generateClientFileInfo(String path) {
        ClientFileInfo ret = new ClientFileInfo();
        ret.id = this.getId();
        ret.name = this.getName();
        ret.path = path;
        ret.checkpointPath = this.mCheckpointPath;
        ret.length = this.mLength;
        ret.blockSizeByte = this.BLOCK_SIZE_BYTE;
        ret.creationTimeMs = this.getCreationTimeMs();
        ret.complete = this.isComplete();
        ret.folder = false;
        ret.inMemory = this.isFullyInMemory();
        ret.needPin = this.mPin;
        ret.needCache = this.mCache;
        ret.blockIds = this.getBlockIds();
        ret.dependencyId = this.mDependencyId;
        ret.inMemoryPercentage = this.getInMemoryPercentage();
        return ret;
    }
}

