/*
 * Decompiled with CFR 0.152.
 */
package tachyon.master;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import tachyon.Constants;
import tachyon.HeartbeatExecutor;
import tachyon.HeartbeatThread;
import tachyon.Pair;
import tachyon.PrefixList;
import tachyon.UnderFileSystem;
import tachyon.conf.CommonConf;
import tachyon.conf.MasterConf;
import tachyon.io.Utils;
import tachyon.master.BlockInfo;
import tachyon.master.CheckpointInfo;
import tachyon.master.Dependency;
import tachyon.master.DependencyType;
import tachyon.master.Inode;
import tachyon.master.InodeFile;
import tachyon.master.InodeFolder;
import tachyon.master.InodeRawTable;
import tachyon.master.InodeType;
import tachyon.master.Journal;
import tachyon.master.MasterWorkerInfo;
import tachyon.thrift.BlockInfoException;
import tachyon.thrift.ClientBlockInfo;
import tachyon.thrift.ClientDependencyInfo;
import tachyon.thrift.ClientFileInfo;
import tachyon.thrift.ClientRawTableInfo;
import tachyon.thrift.ClientWorkerInfo;
import tachyon.thrift.Command;
import tachyon.thrift.CommandType;
import tachyon.thrift.DependencyDoesNotExistException;
import tachyon.thrift.FileAlreadyExistException;
import tachyon.thrift.FileDoesNotExistException;
import tachyon.thrift.InvalidPathException;
import tachyon.thrift.NetAddress;
import tachyon.thrift.SuspectedFileSizeException;
import tachyon.thrift.TableColumnException;
import tachyon.thrift.TableDoesNotExistException;
import tachyon.thrift.TachyonException;
import tachyon.util.CommonUtils;

public class MasterInfo {
    public static final String COL = "COL_";
    private final Logger LOG = Logger.getLogger((String)Constants.LOGGER_TYPE);
    private final InetSocketAddress MASTER_ADDRESS;
    private final long START_TIME_NS_PREFIX;
    private final long START_TIME_MS;
    private final MasterConf MASTER_CONF;
    private CheckpointInfo mCheckpointInfo = new CheckpointInfo(0, 0L, 0);
    private AtomicInteger mInodeCounter = new AtomicInteger(0);
    private AtomicInteger mDependencyCounter = new AtomicInteger(0);
    private AtomicInteger mRerunCounter = new AtomicInteger(0);
    private AtomicInteger mUserCounter = new AtomicInteger(0);
    private AtomicInteger mWorkerCounter = new AtomicInteger(0);
    private InodeFolder mRoot;
    private Map<Integer, Inode> mInodes = new HashMap<Integer, Inode>();
    private Map<Integer, Dependency> mDependencies = new HashMap<Integer, Dependency>();
    private Set<Integer> mUncheckpointedDependencies = new HashSet<Integer>();
    private Set<Integer> mPriorityDependencies = new HashSet<Integer>();
    private Set<Integer> mLostFiles = new HashSet<Integer>();
    private Set<Integer> mBeingRecomputedFiles = new HashSet<Integer>();
    private Set<Integer> mMustRecomputeDependencies = new HashSet<Integer>();
    private Map<Long, MasterWorkerInfo> mWorkers = new HashMap<Long, MasterWorkerInfo>();
    private Map<InetSocketAddress, Long> mWorkerAddressToId = new HashMap<InetSocketAddress, Long>();
    private BlockingQueue<MasterWorkerInfo> mLostWorkers = new ArrayBlockingQueue<MasterWorkerInfo>(32);
    private PrefixList mWhiteList;
    private PrefixList mPinList;
    private Set<Integer> mFileIdPinList;
    private Journal mJournal;
    private HeartbeatThread mHeartbeatThread;
    private Thread mRecomputeThread;

    public MasterInfo(InetSocketAddress address, Journal journal) throws IOException {
        this.MASTER_CONF = MasterConf.get();
        this.mRoot = new InodeFolder("", this.mInodeCounter.incrementAndGet(), -1, System.currentTimeMillis());
        this.mInodes.put(this.mRoot.getId(), this.mRoot);
        this.MASTER_ADDRESS = address;
        this.START_TIME_MS = System.currentTimeMillis();
        this.START_TIME_NS_PREFIX = this.START_TIME_MS - this.START_TIME_MS % 1000000L;
        this.mJournal = journal;
        this.mWhiteList = new PrefixList(this.MASTER_CONF.WHITELIST);
        this.mPinList = new PrefixList(this.MASTER_CONF.PINLIST);
        this.mFileIdPinList = Collections.synchronizedSet(new HashSet());
        this.mJournal.loadImage(this);
    }

    public void init() throws IOException {
        this.mCheckpointInfo.updateEditTransactionCounter(this.mJournal.loadEditLog(this));
        this.mJournal.createImage(this);
        this.mJournal.createEditLog(this.mCheckpointInfo.getEditTransactionCounter());
        this.mHeartbeatThread = new HeartbeatThread("Master Heartbeat", new MasterInfoHeartbeatExecutor(), this.MASTER_CONF.HEARTBEAT_INTERVAL_MS);
        this.mHeartbeatThread.start();
        this.mRecomputeThread = new Thread(new RecomputationScheduler());
        this.mRecomputeThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addCheckpoint(long workerId, int fileId, long length, String checkpointPath) throws FileNotFoundException, SuspectedFileSizeException, BlockInfoException {
        this.LOG.info((Object)CommonUtils.parametersToString(workerId, fileId, length, checkpointPath));
        if (workerId != -1L) {
            MasterWorkerInfo tWorkerInfo = this.getWorkerInfo(workerId);
            tWorkerInfo.updateLastUpdatedTimeMs();
        }
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            Inode inode = this.mInodes.get(fileId);
            if (inode == null) {
                throw new FileNotFoundException("File " + fileId + " does not exist.");
            }
            if (inode.isDirectory()) {
                throw new FileNotFoundException("File " + fileId + " is a folder.");
            }
            InodeFile tFile = (InodeFile)inode;
            boolean needLog = false;
            if (tFile.isComplete()) {
                if (tFile.getLength() != length) {
                    throw new SuspectedFileSizeException(fileId + ". Original Size: " + tFile.getLength() + ". New Size: " + length);
                }
            } else {
                tFile.setLength(length);
                needLog = true;
            }
            if (!tFile.hasCheckpointed()) {
                tFile.setCheckpointPath(checkpointPath);
                needLog = true;
                Map<Integer, Dependency> map = this.mDependencies;
                synchronized (map) {
                    int depId = tFile.getDependencyId();
                    if (depId != -1) {
                        Dependency dep = this.mDependencies.get(depId);
                        dep.childCheckpointed(tFile.getId());
                        if (dep.hasCheckpointed()) {
                            this.mUncheckpointedDependencies.remove(dep.ID);
                            this.mPriorityDependencies.remove(dep.ID);
                        }
                    }
                }
            }
            this.addFile(fileId, tFile.getDependencyId());
            tFile.setComplete();
            if (needLog) {
                this.mJournal.getEditLog().addCheckpoint(fileId, length, checkpointPath);
                this.mJournal.getEditLog().flush();
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFile(int fileId, int dependencyId) {
        Map<Integer, Dependency> map = this.mDependencies;
        synchronized (map) {
            if (this.mLostFiles.contains(fileId)) {
                this.mLostFiles.remove(fileId);
            }
            if (this.mBeingRecomputedFiles.contains(fileId)) {
                this.mBeingRecomputedFiles.remove(fileId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int cacheBlock(long workerId, long workerUsedBytes, long blockId, long length) throws FileDoesNotExistException, SuspectedFileSizeException, BlockInfoException {
        this.LOG.debug((Object)CommonUtils.parametersToString(workerId, workerUsedBytes, blockId, length));
        MasterWorkerInfo tWorkerInfo = this.getWorkerInfo(workerId);
        tWorkerInfo.updateBlock(true, blockId);
        tWorkerInfo.updateUsedBytes(workerUsedBytes);
        tWorkerInfo.updateLastUpdatedTimeMs();
        int fileId = BlockInfo.computeInodeId(blockId);
        int blockIndex = BlockInfo.computeBlockIndex(blockId);
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            Inode inode = this.mInodes.get(fileId);
            if (inode == null) {
                throw new FileDoesNotExistException("File " + fileId + " does not exist.");
            }
            if (inode.isDirectory()) {
                throw new FileDoesNotExistException("File " + fileId + " is a folder.");
            }
            InodeFile tFile = (InodeFile)inode;
            if (tFile.getNumberOfBlocks() <= blockIndex) {
                this.addBlock(tFile, new BlockInfo(tFile, blockIndex, length));
            }
            InetSocketAddress address = tWorkerInfo.ADDRESS;
            tFile.addLocation(blockIndex, workerId, new NetAddress(address.getHostName(), address.getPort()));
            if (tFile.hasCheckpointed()) {
                return -1;
            }
            return tFile.getDependencyId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void opAddBlock(int fileId, int blockIndex, long blockLength) throws FileDoesNotExistException, BlockInfoException {
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            Inode inode = this.mInodes.get(fileId);
            if (inode == null) {
                throw new FileDoesNotExistException("File " + fileId + " does not exist.");
            }
            if (inode.isDirectory()) {
                throw new FileDoesNotExistException("File " + fileId + " is a folder.");
            }
            this.addBlock((InodeFile)inode, new BlockInfo((InodeFile)inode, blockIndex, blockLength));
        }
    }

    private void addBlock(InodeFile tFile, BlockInfo blockInfo) throws BlockInfoException {
        tFile.addBlock(blockInfo);
        this.mJournal.getEditLog().addBlock(tFile.getId(), blockInfo.BLOCK_INDEX, blockInfo.LENGTH);
        this.mJournal.getEditLog().flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createDependency(List<String> parents, List<String> children, String commandPrefix, List<ByteBuffer> data, String comment, String framework, String frameworkVersion, DependencyType dependencyType) throws InvalidPathException, FileDoesNotExistException {
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            this.LOG.info((Object)("ParentList: " + CommonUtils.listToString(parents)));
            List<Integer> parentsIdList = this.getFilesIds(parents);
            List<Integer> childrenIdList = this.getFilesIds(children);
            int depId = this.mDependencyCounter.incrementAndGet();
            long creationTimeMs = System.currentTimeMillis();
            int ret = this._createDependency(parentsIdList, childrenIdList, commandPrefix, data, comment, framework, frameworkVersion, dependencyType, depId, creationTimeMs);
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int _createDependency(List<Integer> parentsIdList, List<Integer> childrenIdList, String commandPrefix, List<ByteBuffer> data, String comment, String framework, String frameworkVersion, DependencyType dependencyType, int dependencyId, long creationTimeMs) throws InvalidPathException, FileDoesNotExistException {
        Dependency dep = null;
        Object object = this.mRoot;
        synchronized (object) {
            Inode inode;
            HashSet<Integer> parentDependencyIds = new HashSet<Integer>();
            for (int k = 0; k < parentsIdList.size(); ++k) {
                int parentId = parentsIdList.get(k);
                inode = this.mInodes.get(parentId);
                if (inode.isFile()) {
                    this.LOG.info((Object)("PARENT DEPENDENCY ID IS " + ((InodeFile)inode).getDependencyId() + " " + (InodeFile)inode));
                    if (((InodeFile)inode).getDependencyId() == -1) continue;
                    parentDependencyIds.add(((InodeFile)inode).getDependencyId());
                    continue;
                }
                throw new InvalidPathException("Parent " + parentId + " is not a file.");
            }
            dep = new Dependency(dependencyId, parentsIdList, childrenIdList, commandPrefix, data, comment, framework, frameworkVersion, dependencyType, parentDependencyIds, creationTimeMs);
            ArrayList<Inode> childrenInodeList = new ArrayList<Inode>();
            for (int k = 0; k < childrenIdList.size(); ++k) {
                inode = (InodeFile)this.mInodes.get(childrenIdList.get(k));
                ((InodeFile)inode).setDependencyId(dep.ID);
                childrenInodeList.add(inode);
                if (!((InodeFile)inode).hasCheckpointed()) continue;
                dep.childCheckpointed(inode.getId());
            }
        }
        object = this.mDependencies;
        synchronized (object) {
            this.mDependencies.put(dep.ID, dep);
            if (!dep.hasCheckpointed()) {
                this.mUncheckpointedDependencies.add(dep.ID);
            }
            for (int parentDependencyId : dep.PARENT_DEPENDENCIES) {
                this.mDependencies.get(parentDependencyId).addChildrenDependency(dep.ID);
            }
        }
        this.mJournal.getEditLog().createDependency(parentsIdList, childrenIdList, commandPrefix, data, comment, framework, frameworkVersion, dependencyType, dependencyId, creationTimeMs);
        this.mJournal.getEditLog().flush();
        this.LOG.info((Object)("Dependency created: " + dep));
        return dep.ID;
    }

    public int createFile(String path, long blockSizeByte) throws FileAlreadyExistException, InvalidPathException, BlockInfoException, TachyonException {
        return this.createFile(true, path, false, -1, null, blockSizeByte);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int _createFile(boolean recursive, String path, boolean directory, int columns, ByteBuffer metadata, long blockSizeByte, long creationTimeMs) throws FileAlreadyExistException, InvalidPathException, BlockInfoException, TachyonException {
        if (!directory && blockSizeByte < 1L) {
            throw new BlockInfoException("Invalid block size " + blockSizeByte);
        }
        this.LOG.debug((Object)("createFile" + CommonUtils.parametersToString(path)));
        String[] pathNames = MasterInfo.getPathNames(path);
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            Inode inode = this.getInode(pathNames);
            if (inode != null) {
                if (inode.isDirectory() && directory && columns == -1) {
                    return inode.getId();
                }
                this.LOG.info((Object)("FileAlreadyExistException: File " + path + " already exist."));
                throw new FileAlreadyExistException("File " + path + " already exist.");
            }
            String name = pathNames[pathNames.length - 1];
            String folderPath = null;
            folderPath = path.length() - name.length() == 1 ? path.substring(0, path.length() - name.length()) : path.substring(0, path.length() - name.length() - 1);
            inode = this.getInode(folderPath);
            if (inode == null) {
                int succeed = 0;
                if (recursive) {
                    succeed = this.createFile(true, folderPath, true, -1, null, blockSizeByte);
                }
                if (!recursive || succeed <= 0) {
                    this.LOG.info((Object)("InvalidPathException: File " + path + " creation failed. Folder " + folderPath + " does not exist."));
                    throw new InvalidPathException("InvalidPathException: File " + path + " creation " + "failed. Folder " + folderPath + " does not exist.");
                }
                inode = this.mInodes.get(succeed);
            } else if (inode.isFile()) {
                this.LOG.info((Object)("InvalidPathException: File " + path + " creation failed. " + folderPath + " is a file."));
                throw new InvalidPathException("File " + path + " creation failed. " + folderPath + " is a file");
            }
            Inode ret = null;
            if (directory) {
                ret = columns != -1 ? new InodeRawTable(name, this.mInodeCounter.incrementAndGet(), inode.getId(), columns, metadata, creationTimeMs) : new InodeFolder(name, this.mInodeCounter.incrementAndGet(), inode.getId(), creationTimeMs);
            } else {
                ret = new InodeFile(name, this.mInodeCounter.incrementAndGet(), inode.getId(), blockSizeByte, creationTimeMs);
                String curPath = this.getPath(ret);
                if (this.mPinList.inList(curPath)) {
                    Set<Integer> set = this.mFileIdPinList;
                    synchronized (set) {
                        this.mFileIdPinList.add(ret.getId());
                        ((InodeFile)ret).setPin(true);
                    }
                }
                if (this.mWhiteList.inList(curPath)) {
                    ((InodeFile)ret).setCache(true);
                }
            }
            this.mInodes.put(ret.getId(), ret);
            ((InodeFolder)inode).addChild(ret.getId());
            this.LOG.debug((Object)("createFile: File Created: " + ret + " parent: " + inode));
            return ret.getId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createFile(boolean recursive, String path, boolean directory, int columns, ByteBuffer metadata, long blockSizeByte) throws FileAlreadyExistException, InvalidPathException, BlockInfoException, TachyonException {
        long creationTimeMs = System.currentTimeMillis();
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            int ret = this._createFile(recursive, path, directory, columns, metadata, blockSizeByte, creationTimeMs);
            this.mJournal.getEditLog().createFile(recursive, path, directory, columns, metadata, blockSizeByte, creationTimeMs);
            this.mJournal.getEditLog().flush();
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createImage(DataOutputStream os) throws IOException {
        LinkedList<Inode> nodesQueue = new LinkedList<Inode>();
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            for (Dependency dep : this.mDependencies.values()) {
                this.createImageDependencyWriter(dep, os);
            }
            this.createImageInodeWriter(this.mRoot, os);
            nodesQueue.add(this.mRoot);
            while (!nodesQueue.isEmpty()) {
                InodeFolder tFolder = (InodeFolder)nodesQueue.poll();
                List<Integer> childrenIds = tFolder.getChildrenIds();
                for (int id : childrenIds) {
                    Inode tInode = this.mInodes.get(id);
                    this.createImageInodeWriter(tInode, os);
                    if (tInode.isDirectory()) {
                        nodesQueue.add(tInode);
                        continue;
                    }
                    if (!((InodeFile)tInode).isPin()) continue;
                    Set<Integer> set = this.mFileIdPinList;
                    synchronized (set) {
                        this.mFileIdPinList.add(tInode.getId());
                    }
                }
            }
            os.writeByte(0);
            os.writeInt(this.mInodeCounter.get());
            os.writeLong(this.mCheckpointInfo.getEditTransactionCounter());
            os.writeInt(this.mCheckpointInfo.getDependencyCounter());
        }
    }

    public void loadImage(DataInputStream is) throws IOException {
        block6: while (true) {
            int type = -1;
            try {
                type = is.readByte();
            }
            catch (EOFException e) {
                return;
            }
            if (type == 0) {
                this.mInodeCounter.set(is.readInt());
                this.mCheckpointInfo.updateEditTransactionCounter(is.readLong());
                this.mCheckpointInfo.updateDependencyCounter(is.readInt());
                continue;
            }
            if (type == 4) {
                Dependency dep = new Dependency(is.readInt(), Utils.readIntegerList(is), Utils.readIntegerList(is), Utils.readString(is), Utils.readByteBufferList(is), Utils.readString(is), Utils.readString(is), Utils.readString(is), DependencyType.getDependencyType(is.readInt()), Utils.readIntegerList(is), is.readLong());
                dep.resetUncheckpointedChildrenFiles(Utils.readIntegerList(is));
                this.mDependencies.put(dep.ID, dep);
                if (!dep.hasCheckpointed()) {
                    this.mUncheckpointedDependencies.add(dep.ID);
                }
                Iterator<Integer> i$ = dep.PARENT_DEPENDENCIES.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block6;
                    int parentDependencyId = i$.next();
                    this.mDependencies.get(parentDependencyId).addChildrenDependency(dep.ID);
                }
            }
            if (type > 3) {
                throw new IOException("Corrupted image with unknown element type: " + type);
            }
            long creationTimeMs = is.readLong();
            int fileId = is.readInt();
            String fileName = Utils.readString(is);
            int parentId = is.readInt();
            Inode inode = null;
            if (type == 1) {
                long blockSizeByte = is.readLong();
                long length = is.readLong();
                boolean isComplete = is.readBoolean();
                boolean isPin = is.readBoolean();
                boolean isCache = is.readBoolean();
                String checkpointPath = Utils.readString(is);
                InodeFile tInode = new InodeFile(fileName, fileId, parentId, blockSizeByte, creationTimeMs);
                try {
                    tInode.setLength(length);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
                tInode.setComplete(isComplete);
                tInode.setPin(isPin);
                tInode.setCache(isCache);
                tInode.setCheckpointPath(checkpointPath);
                tInode.setDependencyId(is.readInt());
                inode = tInode;
            } else {
                int numberOfChildren = is.readInt();
                int[] children = new int[numberOfChildren];
                for (int k = 0; k < numberOfChildren; ++k) {
                    children[k] = is.readInt();
                }
                if (type == 2) {
                    InodeFolder folder = new InodeFolder(fileName, fileId, parentId, creationTimeMs);
                    folder.addChildren(children);
                    inode = folder;
                } else {
                    int columns = is.readInt();
                    ByteBuffer metadata = Utils.readByteBuffer(is);
                    try {
                        InodeRawTable table = new InodeRawTable(fileName, fileId, parentId, columns, metadata, creationTimeMs);
                        table.addChildren(children);
                        inode = table;
                    }
                    catch (TachyonException e) {
                        throw new IOException(e);
                    }
                }
            }
            this.LOG.info((Object)("Putting " + inode));
            if (inode.getId() > this.mInodeCounter.get()) {
                this.mInodeCounter.set(inode.getId());
            }
            if (inode.getId() == 1) {
                this.mRoot = inode;
            }
            this.mInodes.put(inode.getId(), inode);
        }
    }

    private void createImageDependencyWriter(Dependency dep, DataOutputStream os) throws IOException {
        os.writeByte(4);
        os.writeInt(dep.ID);
        Utils.writeIntegerList(dep.PARENT_FILES, os);
        Utils.writeIntegerList(dep.CHILDREN_FILES, os);
        Utils.writeString(dep.COMMAND_PREFIX, os);
        Utils.writeByteBufferList(dep.DATA, os);
        Utils.writeString(dep.COMMENT, os);
        Utils.writeString(dep.FRAMEWORK, os);
        Utils.writeString(dep.FRAMEWORK_VERSION, os);
        os.writeInt(dep.TYPE.getValue());
        Utils.writeIntegerList(dep.PARENT_DEPENDENCIES, os);
        os.writeLong(dep.CREATION_TIME_MS);
        Utils.writeIntegerList(dep.getUncheckpointedChildrenFiles(), os);
    }

    private void createImageInodeWriter(Inode inode, DataOutputStream os) throws IOException {
        if (inode.isFile()) {
            InodeFile file = (InodeFile)inode;
            os.writeByte(1);
            os.writeLong(file.getCreationTimeMs());
            os.writeInt(file.getId());
            Utils.writeString(file.getName(), os);
            os.writeInt(file.getParentId());
            os.writeLong(file.getBlockSizeByte());
            os.writeLong(file.getLength());
            os.writeBoolean(file.isComplete());
            os.writeBoolean(file.isPin());
            os.writeBoolean(file.isCache());
            Utils.writeString(file.getCheckpointPath(), os);
            os.writeInt(file.getDependencyId());
        } else {
            InodeFolder folder = (InodeFolder)inode;
            if (folder.isRawTable()) {
                os.writeByte(3);
            } else {
                os.writeByte(2);
            }
            os.writeLong(folder.getCreationTimeMs());
            os.writeInt(folder.getId());
            Utils.writeString(folder.getName(), os);
            os.writeInt(folder.getParentId());
            List<Integer> children = folder.getChildrenIds();
            os.writeInt(children.size());
            for (int k = 0; k < children.size(); ++k) {
                os.writeInt(children.get(k));
            }
            if (folder.isRawTable()) {
                InodeRawTable table = (InodeRawTable)folder;
                os.writeInt(table.getColumns());
                Utils.writeByteBuffer(table.getMetadata(), os);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createNewBlock(int fileId) throws FileDoesNotExistException {
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            Inode inode = this.mInodes.get(fileId);
            if (inode == null) {
                throw new FileDoesNotExistException("File " + fileId + " does not exit.");
            }
            if (!inode.isFile()) {
                throw new FileDoesNotExistException("File " + fileId + " is not a file.");
            }
            return ((InodeFile)inode).getNewBlockId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeFile(int fileId) throws FileDoesNotExistException {
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            Inode inode = this.mInodes.get(fileId);
            if (inode == null) {
                throw new FileDoesNotExistException("File " + fileId + " does not exit.");
            }
            if (!inode.isFile()) {
                throw new FileDoesNotExistException("File " + fileId + " is not a file.");
            }
            this.addFile(fileId, ((InodeFile)inode).getDependencyId());
            ((InodeFile)inode).setComplete();
            this.mJournal.getEditLog().completeFile(fileId);
            this.mJournal.getEditLog().flush();
        }
    }

    public int createRawTable(String path, int columns, ByteBuffer metadata) throws FileAlreadyExistException, InvalidPathException, TableColumnException, TachyonException {
        int id;
        this.LOG.info((Object)("createRawTable" + CommonUtils.parametersToString(path, columns)));
        if (columns <= 0 || columns >= 1000) {
            throw new TableColumnException("Column " + columns + " should between 0 to " + 1000);
        }
        try {
            id = this.createFile(true, path, true, columns, metadata, 0L);
        }
        catch (BlockInfoException e) {
            throw new FileAlreadyExistException(e.getMessage());
        }
        for (int k = 0; k < columns; ++k) {
            this.mkdir(path + "/" + COL + k);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _delete(int fileId, boolean recursive) throws TachyonException {
        this.LOG.info((Object)("delete(" + fileId + ")"));
        boolean succeed = true;
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            Inode inode = this.mInodes.get(fileId);
            if (inode == null) {
                return true;
            }
            if (inode.isDirectory()) {
                List<Integer> childrenIds = ((InodeFolder)inode).getChildrenIds();
                if (!recursive && childrenIds.size() != 0) {
                    return false;
                }
                for (int childId : childrenIds) {
                    succeed = succeed && this.delete(childId, recursive);
                }
            }
            InodeFolder parent = (InodeFolder)this.mInodes.get(inode.getParentId());
            parent.removeChild(inode.getId());
            this.mInodes.remove(inode.getId());
            if (inode.isFile()) {
                String checkpointPath = ((InodeFile)inode).getCheckpointPath();
                if (!checkpointPath.equals("")) {
                    UnderFileSystem ufs = UnderFileSystem.get(checkpointPath);
                    try {
                        if (!ufs.delete(checkpointPath, true)) {
                            return false;
                        }
                    }
                    catch (IOException e) {
                        throw new TachyonException(e.getMessage());
                    }
                }
                List<Pair<Long, Long>> blockIdWorkerIdList = ((InodeFile)inode).getBlockIdWorkerIdPairs();
                Object object = this.mWorkers;
                synchronized (object) {
                    for (Pair<Long, Long> blockIdWorkerId : blockIdWorkerIdList) {
                        MasterWorkerInfo workerInfo = this.mWorkers.get(blockIdWorkerId.getSecond());
                        if (workerInfo == null) continue;
                        workerInfo.updateToRemovedBlock(true, blockIdWorkerId.getFirst());
                    }
                }
                if (((InodeFile)inode).isPin()) {
                    object = this.mFileIdPinList;
                    synchronized (object) {
                        this.mFileIdPinList.remove(inode.getId());
                    }
                }
            }
            inode.reverseId();
            return succeed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(int fileId, boolean recursive) throws TachyonException {
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            boolean ret = this._delete(fileId, recursive);
            this.mJournal.getEditLog().delete(fileId, recursive);
            this.mJournal.getEditLog().flush();
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(String path, boolean recursive) throws TachyonException {
        this.LOG.info((Object)("delete(" + path + ")"));
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            Inode inode = null;
            try {
                inode = this.getInode(path);
            }
            catch (InvalidPathException e) {
                return false;
            }
            if (inode == null) {
                return true;
            }
            return this.delete(inode.getId(), recursive);
        }
    }

    public List<BlockInfo> getBlockList(String path) throws InvalidPathException, FileDoesNotExistException {
        Inode inode = this.getInode(path);
        if (inode == null) {
            throw new FileDoesNotExistException(path + " does not exist.");
        }
        if (!inode.isFile()) {
            throw new FileDoesNotExistException(path + " is not a file.");
        }
        InodeFile inodeFile = (InodeFile)inode;
        return inodeFile.getBlockList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBlockIdBasedOnOffset(int fileId, long offset) throws FileDoesNotExistException {
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            Inode inode = this.mInodes.get(fileId);
            if (inode == null) {
                throw new FileDoesNotExistException("FileId " + fileId + " does not exist.");
            }
            if (!inode.isFile()) {
                throw new FileDoesNotExistException(fileId + " is not a file.");
            }
            return ((InodeFile)inode).getBlockIdBasedOnOffset(offset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCapacityBytes() {
        long ret = 0L;
        Map<Long, MasterWorkerInfo> map = this.mWorkers;
        synchronized (map) {
            for (MasterWorkerInfo worker : this.mWorkers.values()) {
                ret += worker.getCapacityBytes();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientDependencyInfo getClientDependencyInfo(int dependencyId) throws DependencyDoesNotExistException {
        Dependency dep = null;
        Map<Integer, Dependency> map = this.mDependencies;
        synchronized (map) {
            dep = this.mDependencies.get(dependencyId);
            if (dep == null) {
                throw new DependencyDoesNotExistException("No dependency with id " + dependencyId);
            }
        }
        return dep.generateClientDependencyInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientBlockInfo getClientBlockInfo(long blockId) throws FileDoesNotExistException, IOException, BlockInfoException {
        int fileId = BlockInfo.computeInodeId(blockId);
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            Inode inode = this.mInodes.get(fileId);
            if (inode == null || inode.isDirectory()) {
                throw new FileDoesNotExistException("FileId " + fileId + " does not exist.");
            }
            ClientBlockInfo ret = ((InodeFile)inode).getClientBlockInfo(BlockInfo.computeBlockIndex(blockId));
            this.LOG.debug((Object)("getClientBlockInfo: " + blockId + ret));
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientFileInfo getClientFileInfo(int fid) throws FileDoesNotExistException {
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            Inode inode = this.mInodes.get(fid);
            if (inode == null) {
                throw new FileDoesNotExistException("FileId " + fid + " does not exist.");
            }
            ClientFileInfo ret = inode.generateClientFileInfo(this.getPath(inode));
            this.LOG.debug((Object)("getClientFileInfo(" + fid + "): " + ret));
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientFileInfo getClientFileInfo(String path) throws FileDoesNotExistException, InvalidPathException {
        this.LOG.info((Object)("getClientFileInfo(" + path + ")"));
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            Inode inode = this.getInode(path);
            if (inode == null) {
                throw new FileDoesNotExistException(path);
            }
            return this.getClientFileInfo(inode.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientRawTableInfo getClientRawTableInfo(int id) throws TableDoesNotExistException {
        this.LOG.info((Object)("getClientRawTableInfo(" + id + ")"));
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            Inode inode = this.mInodes.get(id);
            if (inode == null || inode.isFile() || !((InodeFolder)inode).isRawTable()) {
                throw new TableDoesNotExistException("Table " + id + " does not exist.");
            }
            ClientRawTableInfo ret = new ClientRawTableInfo();
            ret.id = inode.getId();
            ret.name = inode.getName();
            ret.path = this.getPath(inode);
            ret.columns = ((InodeRawTable)inode).getColumns();
            ret.metadata = ((InodeRawTable)inode).getMetadata();
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientRawTableInfo getClientRawTableInfo(String path) throws TableDoesNotExistException, InvalidPathException {
        this.LOG.info((Object)("getClientRawTableInfo(" + path + ")"));
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            Inode inode = this.getInode(path);
            if (inode == null) {
                throw new TableDoesNotExistException(path);
            }
            return this.getClientRawTableInfo(inode.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ClientFileInfo> getFilesInfo(String path) throws FileDoesNotExistException, InvalidPathException {
        ArrayList<ClientFileInfo> ret = new ArrayList<ClientFileInfo>();
        Inode inode = this.getInode(path);
        if (inode == null) {
            throw new FileDoesNotExistException(path);
        }
        if (inode.isDirectory()) {
            List<Integer> childernIds = ((InodeFolder)inode).getChildrenIds();
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            InodeFolder inodeFolder = this.mRoot;
            synchronized (inodeFolder) {
                for (int k : childernIds) {
                    ret.add(this.getClientFileInfo(k));
                }
            }
        } else {
            ret.add(this.getClientFileInfo(inode.getId()));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFileNameById(int fileId) throws FileDoesNotExistException {
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            Inode inode = this.mInodes.get(fileId);
            if (inode == null) {
                throw new FileDoesNotExistException("FileId " + fileId + " does not exist");
            }
            return this.getPath(inode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ClientBlockInfo> getFileLocations(int fileId) throws FileDoesNotExistException, IOException {
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            Inode inode = this.mInodes.get(fileId);
            if (inode == null || inode.isDirectory()) {
                throw new FileDoesNotExistException("FileId " + fileId + " does not exist.");
            }
            List<ClientBlockInfo> ret = ((InodeFile)inode).getClientBlockInfos();
            this.LOG.debug((Object)("getFileLocations: " + fileId + ret));
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ClientBlockInfo> getFileLocations(String path) throws FileDoesNotExistException, InvalidPathException, IOException {
        this.LOG.info((Object)("getFileLocations: " + path));
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            Inode inode = this.getInode(path);
            if (inode == null) {
                throw new FileDoesNotExistException(path);
            }
            return this.getFileLocations(inode.getId());
        }
    }

    public int getFileId(String path) throws InvalidPathException {
        this.LOG.debug((Object)("getFileId(" + path + ")"));
        Inode inode = this.getInode(path);
        int ret = -1;
        if (inode != null) {
            ret = inode.getId();
        }
        this.LOG.debug((Object)("getFileId(" + path + "): " + ret));
        return ret;
    }

    private List<Integer> getFilesIds(List<String> pathList) throws InvalidPathException, FileDoesNotExistException {
        ArrayList<Integer> ret = new ArrayList<Integer>(pathList.size());
        for (int k = 0; k < pathList.size(); ++k) {
            ret.addAll(this.listFiles(pathList.get(k), true));
        }
        return ret;
    }

    private Inode getInode(String path) throws InvalidPathException {
        return this.getInode(MasterInfo.getPathNames(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Inode getInode(String[] pathNames) throws InvalidPathException {
        if (pathNames == null || pathNames.length == 0) {
            return null;
        }
        if (pathNames.length == 1) {
            if (pathNames[0].equals("")) {
                return this.mRoot;
            }
            this.LOG.info((Object)("InvalidPathException: File name starts with " + pathNames[0]));
            throw new InvalidPathException("File name starts with " + pathNames[0]);
        }
        Inode cur = this.mRoot;
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            String name;
            for (int k = 1; k < pathNames.length && cur != null; cur = cur.getChild(name, this.mInodes), ++k) {
                name = pathNames[k];
                if (!cur.isFile()) continue;
                return null;
            }
            return cur;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getInMemoryFiles() {
        ArrayList<String> ret = new ArrayList<String>();
        this.LOG.info((Object)"getInMemoryFiles()");
        LinkedList<Pair<InodeFolder, String>> nodesQueue = new LinkedList<Pair<InodeFolder, String>>();
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            nodesQueue.add(new Pair<InodeFolder, String>(this.mRoot, ""));
            while (!nodesQueue.isEmpty()) {
                Pair tPair = (Pair)nodesQueue.poll();
                InodeFolder tFolder = (InodeFolder)tPair.getFirst();
                String curPath = (String)tPair.getSecond();
                List<Integer> childrenIds = tFolder.getChildrenIds();
                for (int id : childrenIds) {
                    Inode tInode = this.mInodes.get(id);
                    String newPath = curPath + "/" + tInode.getName();
                    if (tInode.isDirectory()) {
                        nodesQueue.add(new Pair<InodeFolder, String>((InodeFolder)tInode, newPath));
                        continue;
                    }
                    if (!((InodeFile)tInode).isFullyInMemory()) continue;
                    ret.add(newPath);
                }
            }
        }
        return ret;
    }

    public InetSocketAddress getMasterAddress() {
        return this.MASTER_ADDRESS;
    }

    private static String getName(String path) throws InvalidPathException {
        String[] pathNames = MasterInfo.getPathNames(path);
        return pathNames[pathNames.length - 1];
    }

    public long getNewUserId() {
        return this.mUserCounter.incrementAndGet();
    }

    public int getNumberOfFiles(String path) throws InvalidPathException, FileDoesNotExistException {
        Inode inode = this.getInode(path);
        if (inode == null) {
            throw new FileDoesNotExistException(path);
        }
        if (inode.isFile()) {
            return 1;
        }
        return ((InodeFolder)inode).getNumberOfChildren();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPath(Inode inode) {
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            if (inode.getId() == 1) {
                return "/";
            }
            if (inode.getParentId() == 1) {
                return "/" + inode.getName();
            }
            return this.getPath(this.mInodes.get(inode.getParentId())) + "/" + inode.getName();
        }
    }

    private static String[] getPathNames(String path) throws InvalidPathException {
        CommonUtils.validatePath(path);
        if (path.length() == 1 && path.equals("/")) {
            String[] ret = new String[]{""};
            return ret;
        }
        return path.split("/");
    }

    public List<String> getPinList() {
        return this.mPinList.getList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getPinIdList() {
        Set<Integer> set = this.mFileIdPinList;
        synchronized (set) {
            ArrayList<Integer> ret = new ArrayList<Integer>();
            for (int id : this.mFileIdPinList) {
                ret.add(id);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getPriorityDependencyList() {
        Map<Integer, Dependency> map = this.mDependencies;
        synchronized (map) {
            int earliestDepId = -1;
            if (this.mPriorityDependencies.isEmpty()) {
                long earliest = Long.MAX_VALUE;
                for (int depId : this.mUncheckpointedDependencies) {
                    Dependency dep = this.mDependencies.get(depId);
                    if (!dep.hasChildrenDependency()) {
                        this.mPriorityDependencies.add(dep.ID);
                    }
                    if (dep.CREATION_TIME_MS >= earliest) continue;
                    earliest = dep.CREATION_TIME_MS;
                    earliestDepId = dep.ID;
                }
                if (!this.mPriorityDependencies.isEmpty()) {
                    this.LOG.info((Object)("New computed priority dependency list " + this.mPriorityDependencies));
                }
            }
            if (this.mPriorityDependencies.isEmpty() && earliestDepId != -1) {
                this.mPriorityDependencies.add(earliestDepId);
                this.LOG.info((Object)("Priority dependency list by earliest creation time: " + this.mPriorityDependencies));
            }
            ArrayList<Integer> ret = new ArrayList<Integer>(this.mPriorityDependencies.size());
            ret.addAll(this.mPriorityDependencies);
            return ret;
        }
    }

    public int getRawTableId(String path) throws InvalidPathException {
        Inode inode = this.getInode(path);
        if (inode == null || inode.isFile() || !((InodeFolder)inode).isRawTable()) {
            return -1;
        }
        return inode.getId();
    }

    public long getStarttimeMs() {
        return this.START_TIME_MS;
    }

    public long getUnderFsCapacityBytes() throws IOException {
        UnderFileSystem ufs = UnderFileSystem.get(CommonConf.get().UNDERFS_DATA_FOLDER);
        return ufs.getSpace(CommonConf.get().UNDERFS_DATA_FOLDER, UnderFileSystem.SpaceType.SPACE_TOTAL);
    }

    public long getUnderFsUsedBytes() throws IOException {
        UnderFileSystem ufs = UnderFileSystem.get(CommonConf.get().UNDERFS_DATA_FOLDER);
        return ufs.getSpace(CommonConf.get().UNDERFS_DATA_FOLDER, UnderFileSystem.SpaceType.SPACE_USED);
    }

    public long getUnderFsFreeBytes() throws IOException {
        UnderFileSystem ufs = UnderFileSystem.get(CommonConf.get().UNDERFS_DATA_FOLDER);
        return ufs.getSpace(CommonConf.get().UNDERFS_DATA_FOLDER, UnderFileSystem.SpaceType.SPACE_FREE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUsedBytes() {
        long ret = 0L;
        Map<Long, MasterWorkerInfo> map = this.mWorkers;
        synchronized (map) {
            for (MasterWorkerInfo worker : this.mWorkers.values()) {
                ret += worker.getUsedBytes();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetAddress getWorker(boolean random, String host) {
        Map<Long, MasterWorkerInfo> map = this.mWorkers;
        synchronized (map) {
            if (this.mWorkerAddressToId.isEmpty()) {
                return null;
            }
            if (random) {
                int index = new Random(this.mWorkerAddressToId.size()).nextInt(this.mWorkerAddressToId.size());
                for (InetSocketAddress address : this.mWorkerAddressToId.keySet()) {
                    if (index == 0) {
                        this.LOG.debug((Object)("getRandomWorker: " + address));
                        return new NetAddress(address.getHostName(), address.getPort());
                    }
                    --index;
                }
                Iterator<InetSocketAddress> i$ = this.mWorkerAddressToId.keySet().iterator();
                if (i$.hasNext()) {
                    InetSocketAddress address;
                    address = i$.next();
                    this.LOG.debug((Object)("getRandomWorker: " + address));
                    return new NetAddress(address.getHostName(), address.getPort());
                }
            } else {
                for (InetSocketAddress address : this.mWorkerAddressToId.keySet()) {
                    if (!address.getHostName().equals(host) && !address.getAddress().getHostAddress().equals(host) && !address.getAddress().getCanonicalHostName().equals(host)) continue;
                    this.LOG.debug((Object)("getLocalWorker: " + address));
                    return new NetAddress(address.getHostName(), address.getPort());
                }
            }
        }
        this.LOG.info((Object)("getLocalWorker: no local worker on " + host));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWorkerCount() {
        Map<Long, MasterWorkerInfo> map = this.mWorkers;
        synchronized (map) {
            return this.mWorkers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MasterWorkerInfo getWorkerInfo(long workerId) {
        MasterWorkerInfo ret = null;
        Map<Long, MasterWorkerInfo> map = this.mWorkers;
        synchronized (map) {
            ret = this.mWorkers.get(workerId);
            if (ret == null) {
                this.LOG.error((Object)("No worker: " + workerId));
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ClientWorkerInfo> getWorkersInfo() {
        ArrayList<ClientWorkerInfo> ret = new ArrayList<ClientWorkerInfo>();
        Map<Long, MasterWorkerInfo> map = this.mWorkers;
        synchronized (map) {
            for (MasterWorkerInfo worker : this.mWorkers.values()) {
                ret.add(worker.generateClientWorkerInfo());
            }
        }
        return ret;
    }

    public List<String> getWhiteList() {
        return this.mWhiteList.getList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> listFiles(String path, boolean recursive) throws InvalidPathException, FileDoesNotExistException {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            Inode inode = this.getInode(path);
            if (inode == null) {
                throw new FileDoesNotExistException(path);
            }
            if (inode.isFile()) {
                ret.add(inode.getId());
            } else if (recursive) {
                LinkedList<Integer> queue = new LinkedList<Integer>();
                queue.addAll(((InodeFolder)inode).getChildrenIds());
                while (!queue.isEmpty()) {
                    int id = (Integer)queue.poll();
                    inode = this.mInodes.get(id);
                    if (inode.isDirectory()) {
                        queue.addAll(((InodeFolder)inode).getChildrenIds());
                        continue;
                    }
                    ret.add(id);
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> ls(String path, boolean recursive) throws InvalidPathException, FileDoesNotExistException {
        ArrayList<String> ret = new ArrayList<String>();
        Inode inode = this.getInode(path);
        if (inode == null) {
            throw new FileDoesNotExistException(path);
        }
        if (inode.isFile()) {
            ret.add(path);
        } else {
            List<Integer> childernIds = ((InodeFolder)inode).getChildrenIds();
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            ret.add(path);
            InodeFolder inodeFolder = this.mRoot;
            synchronized (inodeFolder) {
                for (int k : childernIds) {
                    inode = this.mInodes.get(k);
                    if (inode == null) continue;
                    if (recursive) {
                        ret.addAll(this.ls(path + inode.getName(), true));
                        continue;
                    }
                    ret.add(path + inode.getName());
                }
            }
        }
        return ret;
    }

    public boolean mkdir(String path) throws FileAlreadyExistException, InvalidPathException, TachyonException {
        try {
            return this.createFile(true, path, true, -1, null, 0L) > 0;
        }
        catch (BlockInfoException e) {
            throw new FileAlreadyExistException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long registerWorker(NetAddress workerNetAddress, long totalBytes, long usedBytes, List<Long> currentBlockIds) throws BlockInfoException {
        long id = 0L;
        InetSocketAddress workerAddress = new InetSocketAddress(workerNetAddress.mHost, workerNetAddress.mPort);
        this.LOG.info((Object)("registerWorker(): WorkerNetAddress: " + workerAddress));
        Object object = this.mWorkers;
        synchronized (object) {
            MasterWorkerInfo tWorkerInfo;
            if (this.mWorkerAddressToId.containsKey(workerAddress)) {
                id = this.mWorkerAddressToId.get(workerAddress);
                this.mWorkerAddressToId.remove(workerAddress);
                this.LOG.warn((Object)("The worker " + workerAddress + " already exists as id " + id + "."));
            }
            if (id != 0L && this.mWorkers.containsKey(id)) {
                tWorkerInfo = this.mWorkers.get(id);
                this.mWorkers.remove(id);
                this.mLostWorkers.add(tWorkerInfo);
                this.LOG.warn((Object)("The worker with id " + id + " has been removed."));
            }
            id = this.START_TIME_NS_PREFIX + (long)this.mWorkerCounter.incrementAndGet();
            tWorkerInfo = new MasterWorkerInfo(id, workerAddress, totalBytes);
            tWorkerInfo.updateUsedBytes(usedBytes);
            tWorkerInfo.updateBlocks(true, currentBlockIds);
            tWorkerInfo.updateLastUpdatedTimeMs();
            this.mWorkers.put(id, tWorkerInfo);
            this.mWorkerAddressToId.put(workerAddress, id);
            this.LOG.info((Object)("registerWorker(): " + tWorkerInfo));
        }
        object = this.mRoot;
        synchronized (object) {
            for (long blockId : currentBlockIds) {
                int fileId = BlockInfo.computeInodeId(blockId);
                int blockIndex = BlockInfo.computeBlockIndex(blockId);
                Inode inode = this.mInodes.get(fileId);
                if (inode != null && inode.isFile()) {
                    ((InodeFile)inode).addLocation(blockIndex, id, workerNetAddress);
                    continue;
                }
                this.LOG.warn((Object)("registerWorker failed to add fileId " + fileId + " blockIndex " + blockIndex));
            }
        }
        return id;
    }

    private void rename(Inode srcInode, String dstPath) throws FileAlreadyExistException, InvalidPathException, FileDoesNotExistException {
        Inode dstFolderInode;
        if (this.getInode(dstPath) != null) {
            throw new FileAlreadyExistException("Failed to rename: " + dstPath + " already exist");
        }
        String dstName = MasterInfo.getName(dstPath);
        String dstFolderPath = dstPath.substring(0, dstPath.length() - dstName.length() - 1);
        if (dstFolderPath.isEmpty()) {
            dstFolderPath = "/";
        }
        if ((dstFolderInode = this.getInode(dstFolderPath)) == null || dstFolderInode.isFile()) {
            throw new FileDoesNotExistException("Failed to rename: " + dstFolderPath + " does not exist.");
        }
        srcInode.setName(dstName);
        InodeFolder parent = (InodeFolder)this.mInodes.get(srcInode.getParentId());
        parent.removeChild(srcInode.getId());
        srcInode.setParentId(dstFolderInode.getId());
        ((InodeFolder)dstFolderInode).addChild(srcInode.getId());
        this.mJournal.getEditLog().rename(srcInode.getId(), dstPath);
        this.mJournal.getEditLog().flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(int fileId, String dstPath) throws FileDoesNotExistException, FileAlreadyExistException, InvalidPathException {
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            Inode inode = this.mInodes.get(fileId);
            if (inode == null) {
                throw new FileDoesNotExistException("Failed to rename: " + fileId + " does not exist");
            }
            this.rename(inode, dstPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(String srcPath, String dstPath) throws FileAlreadyExistException, FileDoesNotExistException, InvalidPathException {
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            Inode inode = this.getInode(srcPath);
            if (inode == null) {
                throw new FileDoesNotExistException("Failed to rename: " + srcPath + " does not exist");
            }
            this.rename(inode, dstPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportLostFile(int fileId) {
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            Inode inode = this.mInodes.get(fileId);
            if (inode == null) {
                this.LOG.warn((Object)("Tachyon does not have file " + fileId));
            } else if (inode.isDirectory()) {
                this.LOG.warn((Object)("Reported file is a directory " + inode));
            } else {
                InodeFile iFile = (InodeFile)inode;
                int depId = iFile.getDependencyId();
                Map<Integer, Dependency> map = this.mDependencies;
                synchronized (map) {
                    this.mLostFiles.add(fileId);
                    if (depId == -1) {
                        this.LOG.error((Object)("There is no dependency info for " + iFile + " . No recovery on that"));
                    } else {
                        this.LOG.info((Object)("Reported file loss. Tachyon will recompute it: " + iFile.toString()));
                        Dependency dep = this.mDependencies.get(depId);
                        dep.addLostFile(fileId);
                        this.mMustRecomputeDependencies.add(depId);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestFilesInDependency(int depId) {
        Map<Integer, Dependency> map = this.mDependencies;
        synchronized (map) {
            if (this.mDependencies.containsKey(depId)) {
                Dependency dep = this.mDependencies.get(depId);
                this.LOG.info((Object)("Request files in dependency " + dep));
                if (dep.hasLostFile()) {
                    this.mMustRecomputeDependencies.add(depId);
                }
            } else {
                this.LOG.error((Object)("There is no dependency with id " + depId));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unpinFile(int fileId) throws FileDoesNotExistException {
        this.LOG.info((Object)("unpinFile(" + fileId + ")"));
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            Inode inode = this.mInodes.get(fileId);
            if (inode == null) {
                throw new FileDoesNotExistException("Failed to unpin " + fileId);
            }
            ((InodeFile)inode).setPin(false);
            Set<Integer> set = this.mFileIdPinList;
            synchronized (set) {
                this.mFileIdPinList.remove(fileId);
            }
            this.mJournal.getEditLog().unpinFile(fileId);
            this.mJournal.getEditLog().flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRawTableMetadata(int tableId, ByteBuffer metadata) throws TableDoesNotExistException, TachyonException {
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            Inode inode = this.mInodes.get(tableId);
            if (inode == null || inode.getInodeType() != InodeType.RawTable) {
                throw new TableDoesNotExistException("Table " + tableId + " does not exist.");
            }
            ((InodeRawTable)inode).updateMetadata(metadata);
            this.mJournal.getEditLog().updateRawTableMetadata(tableId, metadata);
            this.mJournal.getEditLog().flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Command workerHeartbeat(long workerId, long usedBytes, List<Long> removedBlockIds) throws BlockInfoException {
        this.LOG.debug((Object)("WorkerId: " + workerId));
        InodeFolder inodeFolder = this.mRoot;
        synchronized (inodeFolder) {
            Map<Long, MasterWorkerInfo> map = this.mWorkers;
            synchronized (map) {
                MasterWorkerInfo tWorkerInfo = this.mWorkers.get(workerId);
                if (tWorkerInfo == null) {
                    this.LOG.info((Object)("worker_heartbeat(): Does not contain worker with ID " + workerId + " . Send command to let it re-register."));
                    return new Command(CommandType.Register, new ArrayList<Long>());
                }
                tWorkerInfo.updateUsedBytes(usedBytes);
                tWorkerInfo.updateBlocks(false, removedBlockIds);
                tWorkerInfo.updateToRemovedBlocks(false, removedBlockIds);
                tWorkerInfo.updateLastUpdatedTimeMs();
                for (long blockId : removedBlockIds) {
                    int fileId = BlockInfo.computeInodeId(blockId);
                    int blockIndex = BlockInfo.computeBlockIndex(blockId);
                    Inode inode = this.mInodes.get(fileId);
                    if (inode == null) {
                        this.LOG.error((Object)("File " + fileId + " does not exist"));
                        continue;
                    }
                    if (!inode.isFile()) continue;
                    ((InodeFile)inode).removeLocation(blockIndex, workerId);
                    this.LOG.debug((Object)("File " + fileId + " block " + blockIndex + " was evicted from worker " + workerId));
                }
                List<Long> toRemovedBlocks = tWorkerInfo.getToRemovedBlocks();
                if (toRemovedBlocks.size() != 0) {
                    return new Command(CommandType.Free, toRemovedBlocks);
                }
            }
        }
        return new Command(CommandType.Nothing, new ArrayList<Long>());
    }

    public void stop() {
        this.mHeartbeatThread.shutdown();
    }

    public Journal getJournal() {
        return this.mJournal;
    }

    public class RecomputationScheduler
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                boolean hasLostFiles = false;
                boolean launched = false;
                ArrayList<String> cmds = new ArrayList<String>();
                InodeFolder inodeFolder = MasterInfo.this.mRoot;
                synchronized (inodeFolder) {
                    Map map = MasterInfo.this.mDependencies;
                    synchronized (map) {
                        if (!MasterInfo.this.mMustRecomputeDependencies.isEmpty()) {
                            Dependency dep;
                            ArrayList<Integer> recomputeList = new ArrayList<Integer>();
                            LinkedList<Integer> checkQueue = new LinkedList<Integer>();
                            checkQueue.addAll(MasterInfo.this.mMustRecomputeDependencies);
                            while (!checkQueue.isEmpty()) {
                                int depId = (Integer)checkQueue.poll();
                                dep = (Dependency)MasterInfo.this.mDependencies.get(depId);
                                boolean canLaunch = true;
                                for (int k = 0; k < dep.PARENT_FILES.size(); ++k) {
                                    int tDepId;
                                    int fildId = dep.PARENT_FILES.get(k);
                                    if (!MasterInfo.this.mLostFiles.contains(fildId)) continue;
                                    canLaunch = false;
                                    InodeFile iFile = (InodeFile)MasterInfo.this.mInodes.get(fildId);
                                    if (MasterInfo.this.mBeingRecomputedFiles.contains(fildId) || (tDepId = iFile.getDependencyId()) == -1 || MasterInfo.this.mMustRecomputeDependencies.contains(tDepId)) continue;
                                    MasterInfo.this.mMustRecomputeDependencies.add(tDepId);
                                    checkQueue.add(tDepId);
                                }
                                if (!canLaunch) continue;
                                recomputeList.add(depId);
                            }
                            hasLostFiles = !MasterInfo.this.mMustRecomputeDependencies.isEmpty();
                            launched = recomputeList.size() > 0;
                            for (int k = 0; k < recomputeList.size(); ++k) {
                                MasterInfo.this.mMustRecomputeDependencies.remove(recomputeList.get(k));
                                dep = (Dependency)MasterInfo.this.mDependencies.get(recomputeList.get(k));
                                MasterInfo.this.mBeingRecomputedFiles.addAll(dep.getLostFiles());
                                cmds.add(dep.getCommand());
                            }
                        }
                    }
                }
                for (String cmd : cmds) {
                    String filePath = CommonConf.get().TACHYON_HOME + "/logs/rerun-" + MasterInfo.this.mRerunCounter.incrementAndGet();
                    new Thread(new RecomputeCmd(cmd, filePath)).start();
                }
                if (launched) continue;
                if (hasLostFiles) {
                    MasterInfo.this.LOG.info((Object)"HasLostFiles, but no job can be launched.");
                }
                CommonUtils.sleepMs(MasterInfo.this.LOG, 1000L);
            }
        }
    }

    public class RecomputeCmd
    implements Runnable {
        private final String CMD;
        private final String FILE_PATH;

        public RecomputeCmd(String cmd, String filePath) {
            this.CMD = cmd;
            this.FILE_PATH = filePath;
        }

        @Override
        public void run() {
            try {
                String line;
                MasterInfo.this.LOG.info((Object)("Exec " + this.CMD + " output to " + this.FILE_PATH));
                Process p = Runtime.getRuntime().exec(this.CMD);
                BufferedReader bri = new BufferedReader(new InputStreamReader(p.getInputStream()));
                BufferedReader bre = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                File file = new File(this.FILE_PATH);
                FileWriter fw = new FileWriter(file.getAbsoluteFile());
                BufferedWriter bw = new BufferedWriter(fw);
                while ((line = bri.readLine()) != null) {
                    bw.write(line + "\n");
                }
                bri.close();
                while ((line = bre.readLine()) != null) {
                    bw.write(line + "\n");
                }
                bre.close();
                bw.flush();
                bw.close();
                p.waitFor();
                MasterInfo.this.LOG.info((Object)("Exec " + this.CMD + " output to " + this.FILE_PATH + " done."));
            }
            catch (IOException e) {
                MasterInfo.this.LOG.error((Object)e.getMessage());
            }
            catch (InterruptedException e) {
                MasterInfo.this.LOG.error((Object)e.getMessage());
            }
        }
    }

    public class MasterInfoHeartbeatExecutor
    implements HeartbeatExecutor {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void heartbeat() {
            MasterInfo.this.LOG.debug((Object)"System status checking.");
            HashSet lostWorkers = new HashSet();
            Map map = MasterInfo.this.mWorkers;
            synchronized (map) {
                for (Map.Entry worker : MasterInfo.this.mWorkers.entrySet()) {
                    if (CommonUtils.getCurrentMs() - ((MasterWorkerInfo)worker.getValue()).getLastUpdatedTimeMs() <= (long)((MasterInfo)MasterInfo.this).MASTER_CONF.WORKER_TIMEOUT_MS) continue;
                    MasterInfo.this.LOG.error((Object)("The worker " + worker.getValue() + " got timed out!"));
                    MasterInfo.this.mLostWorkers.add(worker.getValue());
                    lostWorkers.add(worker.getKey());
                }
                Iterator i$ = lostWorkers.iterator();
                while (i$.hasNext()) {
                    long workerId = (Long)((Object)i$.next());
                    MasterWorkerInfo workerInfo = (MasterWorkerInfo)MasterInfo.this.mWorkers.get(workerId);
                    MasterInfo.this.mWorkerAddressToId.remove(workerInfo.getAddress());
                    MasterInfo.this.mWorkers.remove(workerId);
                }
            }
            boolean hadFailedWorker = false;
            while (MasterInfo.this.mLostWorkers.size() != 0) {
                hadFailedWorker = true;
                MasterWorkerInfo worker = (MasterWorkerInfo)MasterInfo.this.mLostWorkers.poll();
                InodeFolder inodeFolder = MasterInfo.this.mRoot;
                synchronized (inodeFolder) {
                    Map map2 = MasterInfo.this.mDependencies;
                    synchronized (map2) {
                        try {
                            for (long blockId : worker.getBlocks()) {
                                int fileId = BlockInfo.computeInodeId(blockId);
                                InodeFile tFile = (InodeFile)MasterInfo.this.mInodes.get(fileId);
                                if (tFile == null) continue;
                                int blockIndex = BlockInfo.computeBlockIndex(blockId);
                                tFile.removeLocation(blockIndex, worker.getId());
                                if (!tFile.hasCheckpointed() && tFile.getBlockLocations(blockIndex).size() == 0) {
                                    MasterInfo.this.LOG.info((Object)("Block " + blockId + " got lost from worker " + worker.getId() + " ."));
                                    int depId = tFile.getDependencyId();
                                    if (depId == -1) {
                                        MasterInfo.this.LOG.error((Object)("Permanent Data loss: " + tFile));
                                        continue;
                                    }
                                    MasterInfo.this.mLostFiles.add(tFile.getId());
                                    Dependency dep = (Dependency)MasterInfo.this.mDependencies.get(depId);
                                    dep.addLostFile(tFile.getId());
                                    MasterInfo.this.LOG.info((Object)("File " + tFile.getId() + " got lost from worker " + worker.getId() + " . Trying to recompute it using dependency " + dep.ID));
                                    if (MasterInfo.this.getPath(tFile).startsWith(((MasterInfo)MasterInfo.this).MASTER_CONF.TEMPORARY_FOLDER)) continue;
                                    MasterInfo.this.mMustRecomputeDependencies.add(depId);
                                    continue;
                                }
                                MasterInfo.this.LOG.info((Object)("Block " + blockId + " only lost an in memory copy from worker " + worker.getId()));
                            }
                        }
                        catch (BlockInfoException e) {
                            MasterInfo.this.LOG.error((Object)e);
                        }
                    }
                }
            }
            if (hadFailedWorker) {
                MasterInfo.this.LOG.warn((Object)"Restarting failed workers.");
                try {
                    Runtime.getRuntime().exec(CommonConf.get().TACHYON_HOME + "/bin/tachyon-start.sh restart_workers");
                }
                catch (IOException e) {
                    MasterInfo.this.LOG.error((Object)e.getMessage());
                }
            }
        }
    }
}

