/*
 * Decompiled with CFR 0.152.
 */
package tachyon.web;

import java.io.File;
import java.net.InetSocketAddress;
import javax.servlet.Servlet;
import org.apache.log4j.Logger;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.webapp.WebAppContext;
import tachyon.Constants;
import tachyon.conf.CommonConf;
import tachyon.master.MasterInfo;
import tachyon.util.CommonUtils;
import tachyon.web.WebInterfaceBrowseServlet;
import tachyon.web.WebInterfaceDependencyServlet;
import tachyon.web.WebInterfaceGeneralServlet;
import tachyon.web.WebInterfaceMemoryServlet;

public class UIWebServer {
    private final Logger LOG = Logger.getLogger((String)Constants.LOGGER_TYPE);
    private Server mServer;
    private String mServerName;
    private InetSocketAddress mAddress;

    public UIWebServer(String serverName, InetSocketAddress address, MasterInfo masterInfo) {
        this.mAddress = address;
        this.mServerName = serverName;
        this.mServer = new Server(this.mAddress);
        WebAppContext webappcontext = new WebAppContext();
        webappcontext.setContextPath("/");
        File warPath = new File(CommonConf.get().WEB_RESOURCES);
        webappcontext.setWar(warPath.getAbsolutePath());
        HandlerList handlers = new HandlerList();
        webappcontext.addServlet(new ServletHolder((Servlet)new WebInterfaceGeneralServlet(masterInfo)), "/home");
        webappcontext.addServlet(new ServletHolder((Servlet)new WebInterfaceBrowseServlet(masterInfo)), "/browse");
        webappcontext.addServlet(new ServletHolder((Servlet)new WebInterfaceMemoryServlet(masterInfo)), "/memory");
        webappcontext.addServlet(new ServletHolder((Servlet)new WebInterfaceDependencyServlet(masterInfo)), "/dependency");
        handlers.setHandlers(new Handler[]{webappcontext, new DefaultHandler()});
        this.mServer.setHandler((Handler)handlers);
    }

    public void setHandler(AbstractHandler handler) {
        this.mServer.setHandler((Handler)handler);
    }

    public void startWebServer() {
        try {
            this.mServer.start();
            this.LOG.info((Object)(this.mServerName + " started @ " + this.mAddress));
        }
        catch (Exception e) {
            CommonUtils.runtimeException(e);
        }
    }

    public void shutdownWebServer() throws Exception {
        this.mServer.stop();
    }
}

